/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.configuration.distributed;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.cluster.DistributedConfigurationUtils;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedBooleanProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedChangeableProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedConfigurationLifecycleListener;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedPropertyDispatcher;
import org.apache.ignite.internal.processors.subscription.GridInternalSubscriptionProcessor;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.jetbrains.annotations.Nullable;

public class DistributedThinClientConfiguration {
    private final IgniteLogger log;
    private final DistributedChangeableProperty<Boolean> showStackTrace = DistributedBooleanProperty.detachedBooleanProperty("thinClientProperty.showStackTrace");
    private static final String PROPERTY_UPDATE_MESSAGE = "ThinClientProperty parameter '%s' was changed from '%s' to '%s'";

    public DistributedThinClientConfiguration(GridKernalContext ctx) {
        this.log = ctx.log(DistributedThinClientConfiguration.class);
        GridInternalSubscriptionProcessor isp = ctx.internalSubscriptionProcessor();
        isp.registerDistributedConfigurationListener(new DistributedConfigurationLifecycleListener(){

            @Override
            public void onReadyToRegister(DistributedPropertyDispatcher dispatcher) {
                DistributedThinClientConfiguration.this.showStackTrace.addListener(DistributedConfigurationUtils.makeUpdateListener(DistributedThinClientConfiguration.PROPERTY_UPDATE_MESSAGE, DistributedThinClientConfiguration.this.log));
                dispatcher.registerProperties(new DistributedChangeableProperty[]{DistributedThinClientConfiguration.this.showStackTrace});
            }
        });
    }

    public GridFutureAdapter<?> updateThinClientSendServerStackTraceAsync(boolean showStack) throws IgniteCheckedException {
        return this.showStackTrace.propagateAsync(showStack);
    }

    @Nullable
    public Boolean sendServerExceptionStackTraceToClient() {
        return (Boolean)this.showStackTrace.get();
    }
}

