/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterTopologyException;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterGroupEmptyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheInvalidStateException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtUnreservedPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.mvcc.MvccQueryTracker;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.query.CacheQuery;
import org.apache.ignite.internal.processors.cache.query.CacheQueryEntry;
import org.apache.ignite.internal.processors.cache.query.CacheQueryFuture;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryBean;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryErrorFuture;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryFutureAdapter;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryManager;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.cache.query.IndexQueryDesc;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.GridCloseableIteratorAdapter;
import org.apache.ignite.internal.util.GridEmptyCloseableIterator;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteReducer;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridCacheQueryAdapter<T>
implements CacheQuery<T> {
    private final GridCacheContext<?, ?> cctx;
    private final GridCacheQueryType type;
    private final IgniteLogger log;
    private final String clsName;
    @GridToStringInclude(sensitive=true)
    private final String clause;
    private final IndexQueryDesc idxQryDesc;
    private final IgniteBiPredicate<Object, Object> filter;
    private int limit;
    private IgniteClosure<?, ?> transform;
    private Integer part;
    private final boolean incMeta;
    private volatile int pageSize = 1024;
    private volatile long timeout;
    private volatile boolean incBackups;
    private boolean forceLocal;
    private volatile boolean dedup;
    private volatile ClusterGroup prj;
    private boolean keepBinary;
    private int taskHash;
    private MvccSnapshot mvccSnapshot;
    private Boolean dataPageScanEnabled;

    public GridCacheQueryAdapter(GridCacheContext<?, ?> cctx, GridCacheQueryType type, @Nullable IgniteBiPredicate<Object, Object> filter, @Nullable IgniteClosure<Map.Entry, Object> transform, @Nullable Integer part, boolean keepBinary, boolean forceLocal, Boolean dataPageScanEnabled) {
        assert (cctx != null);
        assert (type != null);
        assert (part == null || part >= 0);
        this.cctx = cctx;
        this.type = type;
        this.filter = filter;
        this.transform = transform;
        this.part = part;
        this.keepBinary = keepBinary;
        this.forceLocal = forceLocal;
        this.dataPageScanEnabled = dataPageScanEnabled;
        this.log = cctx.logger(this.getClass());
        this.incMeta = false;
        this.clsName = null;
        this.clause = null;
        this.idxQryDesc = null;
    }

    public GridCacheQueryAdapter(GridCacheContext<?, ?> cctx, GridCacheQueryType type, @Nullable String clsName, @Nullable String clause, @Nullable IgniteBiPredicate<Object, Object> filter, @Nullable Integer part, boolean incMeta, boolean keepBinary, Boolean dataPageScanEnabled) {
        assert (cctx != null);
        assert (type != null);
        assert (part == null || part >= 0);
        this.cctx = cctx;
        this.type = type;
        this.clsName = clsName;
        this.clause = clause;
        this.filter = filter;
        this.part = part;
        this.incMeta = incMeta;
        this.keepBinary = keepBinary;
        this.dataPageScanEnabled = dataPageScanEnabled;
        this.log = cctx.logger(this.getClass());
        this.idxQryDesc = null;
    }

    public GridCacheQueryAdapter(GridCacheContext<?, ?> cctx, GridCacheQueryType type, IgniteLogger log, int pageSize, long timeout, boolean incBackups, boolean dedup, ClusterGroup prj, IgniteBiPredicate<Object, Object> filter, @Nullable Integer part, @Nullable String clsName, String clause, IndexQueryDesc idxQryDesc, int limit, boolean incMeta, boolean keepBinary, int taskHash, MvccSnapshot mvccSnapshot, Boolean dataPageScanEnabled) {
        this.cctx = cctx;
        this.type = type;
        this.log = log;
        this.pageSize = pageSize;
        this.timeout = timeout;
        this.incBackups = incBackups;
        this.dedup = dedup;
        this.prj = prj;
        this.filter = filter;
        this.part = part;
        this.clsName = clsName;
        this.clause = clause;
        this.idxQryDesc = idxQryDesc;
        this.limit = limit;
        this.incMeta = incMeta;
        this.keepBinary = keepBinary;
        this.taskHash = taskHash;
        this.mvccSnapshot = mvccSnapshot;
        this.dataPageScanEnabled = dataPageScanEnabled;
    }

    public GridCacheQueryAdapter(GridCacheContext<?, ?> cctx, GridCacheQueryType type, IndexQueryDesc idxQryDesc, @Nullable Integer part, @Nullable String clsName, @Nullable IgniteBiPredicate<Object, Object> filter) {
        this.cctx = cctx;
        this.type = type;
        this.clsName = clsName;
        this.idxQryDesc = idxQryDesc;
        this.filter = filter;
        this.part = part;
        this.log = cctx.logger(this.getClass());
        this.clause = null;
        this.incMeta = false;
    }

    public Boolean isDataPageScanEnabled() {
        return this.dataPageScanEnabled;
    }

    @Nullable
    MvccSnapshot mvccSnapshot() {
        return this.mvccSnapshot;
    }

    public GridCacheQueryType type() {
        return this.type;
    }

    @Nullable
    public String queryClassName() {
        return this.clsName;
    }

    @Nullable
    public String clause() {
        return this.clause;
    }

    public boolean includeMetadata() {
        return this.incMeta;
    }

    public boolean keepBinary() {
        return this.keepBinary;
    }

    public void keepBinary(boolean keepBinary) {
        this.keepBinary = keepBinary;
    }

    public boolean forceLocal() {
        return this.forceLocal;
    }

    public int taskHash() {
        return this.taskHash;
    }

    @Override
    public CacheQuery<T> pageSize(int pageSize) {
        A.ensure(pageSize > 0, "pageSize > 0");
        this.pageSize = pageSize;
        return this;
    }

    public int pageSize() {
        return this.pageSize;
    }

    @Override
    public CacheQuery<T> timeout(long timeout) {
        A.ensure(timeout >= 0L, "timeout >= 0");
        this.timeout = timeout;
        return this;
    }

    public int limit() {
        return this.limit;
    }

    @Override
    public CacheQuery<T> limit(int limit) {
        this.limit = limit;
        return this;
    }

    public long timeout() {
        return this.timeout;
    }

    @Override
    public CacheQuery<T> includeBackups(boolean incBackups) {
        this.incBackups = incBackups;
        return this;
    }

    public boolean includeBackups() {
        return this.incBackups;
    }

    @Override
    public CacheQuery<T> enableDedup(boolean dedup) {
        this.dedup = dedup;
        return this;
    }

    public boolean enableDedup() {
        return this.dedup;
    }

    @Override
    public CacheQuery<T> projection(ClusterGroup prj) {
        this.prj = prj;
        return this;
    }

    public ClusterGroup projection() {
        return this.prj;
    }

    @Nullable
    public <K, V> IgniteBiPredicate<K, V> scanFilter() {
        return this.filter;
    }

    @Nullable
    public <K, V> IgniteClosure<Map.Entry<K, V>, Object> transform() {
        return this.transform;
    }

    @Nullable
    public Integer partition() {
        return this.part;
    }

    @Nullable
    public IndexQueryDesc idxQryDesc() {
        return this.idxQryDesc;
    }

    public void validate() throws IgniteCheckedException {
        if (this.type != GridCacheQueryType.SCAN && this.type != GridCacheQueryType.SET && this.type != GridCacheQueryType.SPI && this.type != GridCacheQueryType.INDEX && !QueryUtils.isEnabled(this.cctx.config())) {
            throw new IgniteCheckedException("Indexing is disabled for cache: " + this.cctx.cache().name());
        }
    }

    @Override
    public CacheQueryFuture<T> execute(Object ... args) {
        return this.execute0(null, args);
    }

    @Override
    public <R> CacheQueryFuture<R> execute(IgniteReducer<T, R> rmtReducer, Object ... args) {
        return this.execute0(rmtReducer, args);
    }

    private <R> CacheQueryFuture<R> execute0(@Nullable IgniteReducer<T, R> rmtReducer, Object ... args) {
        boolean loc;
        Collection<ClusterNode> nodes;
        assert (this.type != GridCacheQueryType.SCAN) : this;
        try {
            nodes = this.nodes();
        }
        catch (IgniteCheckedException e) {
            return new GridCacheQueryErrorFuture(this.cctx.kernalContext(), e);
        }
        this.cctx.checkSecurity(SecurityPermission.CACHE_READ);
        if (nodes.isEmpty()) {
            return new GridCacheQueryErrorFuture(this.cctx.kernalContext(), new ClusterGroupEmptyCheckedException());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Executing query [query=" + this + ", nodes=" + nodes + ']');
        }
        if (this.cctx.deploymentEnabled()) {
            try {
                this.cctx.deploy().registerClasses(this.filter, rmtReducer);
                this.cctx.deploy().registerClasses(args);
            }
            catch (IgniteCheckedException e) {
                return new GridCacheQueryErrorFuture(this.cctx.kernalContext(), e);
            }
        }
        this.taskHash = this.cctx.kernalContext().job().currentTaskNameHash();
        GridCacheQueryBean bean = new GridCacheQueryBean(this, rmtReducer, null, args);
        GridCacheQueryManager<?, ?> qryMgr = this.cctx.queries();
        boolean bl = loc = nodes.size() == 1 && F.first(nodes).id().equals(this.cctx.localNodeId());
        if (this.type == GridCacheQueryType.SQL_FIELDS || this.type == GridCacheQueryType.SPI) {
            return loc ? qryMgr.queryFieldsLocal(bean) : qryMgr.queryFieldsDistributed(bean, nodes);
        }
        return loc ? qryMgr.queryLocal(bean) : qryMgr.queryDistributed(bean, nodes);
    }

    @Override
    public GridCloseableIterator executeScanQuery() throws IgniteCheckedException {
        boolean loc;
        assert (this.type == GridCacheQueryType.SCAN) : "Wrong processing of query: " + (Object)((Object)this.type);
        GridDhtCacheAdapter<?, ?> cacheAdapter = this.cctx.isNear() ? this.cctx.near().dht() : this.cctx.dht();
        Set<Integer> lostParts = cacheAdapter.topology().lostPartitions();
        if (!lostParts.isEmpty() && (this.part == null || lostParts.contains(this.part))) {
            throw new CacheException((Throwable)new CacheInvalidStateException("Failed to execute query because cache partition has been lostParts [cacheName=" + this.cctx.name() + ", part=" + (this.part == null ? lostParts.iterator().next() : this.part) + ']'));
        }
        ArrayList<ClusterNode> nodes = new ArrayList<ClusterNode>(this.nodes());
        this.cctx.checkSecurity(SecurityPermission.CACHE_READ);
        if (nodes.isEmpty()) {
            if (this.part != null && this.forceLocal) {
                throw new IgniteCheckedException("No queryable nodes for partition " + this.part + " [forced local query=" + this + "]");
            }
            return new GridEmptyCloseableIterator();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Executing query [query=" + this + ", nodes=" + nodes + ']');
        }
        if (this.cctx.deploymentEnabled()) {
            this.cctx.deploy().registerClasses(this.filter);
        }
        this.taskHash = this.cctx.kernalContext().job().currentTaskNameHash();
        GridCacheQueryManager<?, ?> qryMgr = this.cctx.queries();
        MvccQueryTracker mvccTracker = null;
        if (this.cctx.mvccEnabled() && this.mvccSnapshot == null) {
            GridNearTxLocal tx = this.cctx.tm().userTx();
            if (tx != null) {
                this.mvccSnapshot = MvccUtils.requestSnapshot(tx);
            } else {
                mvccTracker = MvccUtils.mvccTracker(this.cctx, null);
                this.mvccSnapshot = mvccTracker.snapshot();
            }
            assert (this.mvccSnapshot != null);
        }
        boolean bl = loc = nodes.size() == 1 && F.first(nodes).id().equals(this.cctx.localNodeId());
        GridCloseableIterator it = loc ? qryMgr.scanQueryLocal(this, true) : (this.part != null ? new ScanQueryFallbackClosableIterator(this.part, this, qryMgr, this.cctx) : qryMgr.scanQueryDistributed(this, nodes));
        return mvccTracker != null ? new MvccTrackingIterator(it, mvccTracker) : it;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ClusterNode> nodes() throws IgniteCheckedException {
        CacheMode cacheMode = this.cctx.config().getCacheMode();
        Integer part = this.partition();
        switch (cacheMode) {
            case REPLICATED: {
                if (this.prj != null || part != null) {
                    return GridCacheQueryAdapter.nodes(this.cctx, this.prj, part);
                }
                GridDhtPartitionTopology topology = this.cctx.topology();
                if (this.cctx.affinityNode() && !topology.localPartitionMap().hasMovingPartitions()) {
                    return Collections.singletonList(this.cctx.localNode());
                }
                topology.readLock();
                try {
                    Collection<ClusterNode> affNodes = GridCacheQueryAdapter.nodes(this.cctx, null, null);
                    ArrayList<ClusterNode> nodes = new ArrayList<ClusterNode>(affNodes);
                    Collections.shuffle(nodes);
                    for (ClusterNode node : nodes) {
                        if (topology.partitions(node.id()).hasMovingPartitions()) continue;
                        List<ClusterNode> list = Collections.singletonList(node);
                        return list;
                    }
                    Collection<ClusterNode> collection = affNodes;
                    return collection;
                }
                finally {
                    topology.readUnlock();
                }
            }
            case PARTITIONED: {
                return GridCacheQueryAdapter.nodes(this.cctx, this.prj, part);
            }
        }
        throw new IllegalStateException("Unknown cache distribution mode: " + (Object)((Object)cacheMode));
    }

    private static Collection<ClusterNode> nodes(final GridCacheContext<?, ?> cctx, final @Nullable ClusterGroup prj, final @Nullable Integer part) throws IgniteCheckedException {
        assert (cctx != null);
        AffinityTopologyVersion topVer = cctx.affinity().affinityTopologyVersion();
        Collection<ClusterNode> affNodes = CU.affinityNodes(cctx, topVer);
        if (prj == null && part == null) {
            return affNodes;
        }
        if (part != null && part >= cctx.affinity().partitions()) {
            throw new IgniteCheckedException("Invalid partition number: " + part);
        }
        final HashSet<ClusterNode> owners = part == null ? Collections.emptySet() : new HashSet<ClusterNode>(cctx.topology().owners(part, topVer));
        return F.view(affNodes, new P1<ClusterNode>(){

            @Override
            public boolean apply(ClusterNode n) {
                return !(!cctx.discovery().cacheAffinityNode(n, cctx.name()) || prj != null && prj.node(n.id()) == null || part != null && !owners.contains(n));
            }
        });
    }

    public String toString() {
        return S.toString(GridCacheQueryAdapter.class, this);
    }

    private static class MvccTrackingIterator
    implements GridCloseableIterator {
        private static final long serialVersionUID = -1905248502802333832L;
        private final GridCloseableIterator it;
        private final MvccQueryTracker mvccTracker;

        MvccTrackingIterator(GridCloseableIterator it, MvccQueryTracker mvccTracker) {
            assert (it != null && mvccTracker != null);
            this.it = it;
            this.mvccTracker = mvccTracker;
        }

        @Override
        public void close() throws IgniteCheckedException {
            if (this.isClosed()) {
                return;
            }
            try {
                this.it.close();
            }
            finally {
                this.mvccTracker.onDone();
            }
        }

        @Override
        public boolean isClosed() {
            return this.it.isClosed();
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = this.it.hasNext();
            if (!hasNext) {
                try {
                    this.close();
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException(e);
                }
            }
            return hasNext;
        }

        @Override
        public boolean hasNextX() throws IgniteCheckedException {
            boolean hasNext = this.it.hasNext();
            if (!hasNext) {
                this.close();
            }
            return hasNext;
        }

        @Override
        public Object nextX() throws IgniteCheckedException {
            return this.it.nextX();
        }

        @Override
        public void removeX() throws IgniteCheckedException {
            this.it.removeX();
        }

        @Override
        @NotNull
        public Iterator iterator() {
            return this;
        }

        @Override
        public Object next() {
            return this.it.next();
        }
    }

    private static class ScanQueryFallbackClosableIterator
    extends GridCloseableIteratorAdapter {
        private static final long serialVersionUID = 0L;
        private volatile T2<GridCloseableIterator<Object>, GridCacheQueryFutureAdapter> tuple;
        private volatile Queue<ClusterNode> nodes;
        private volatile AffinityTopologyVersion unreservedTopVer;
        private volatile int unreservedNodesRetryCnt = 5;
        private final GridCacheQueryAdapter qry;
        private final GridCacheQueryManager qryMgr;
        private final GridCacheContext cctx;
        private final int part;
        private boolean firstItemReturned;
        private Object cur;

        private ScanQueryFallbackClosableIterator(int part, GridCacheQueryAdapter qry, GridCacheQueryManager qryMgr, GridCacheContext cctx) {
            this.qry = qry;
            this.qryMgr = qryMgr;
            this.cctx = cctx;
            this.part = part;
            this.nodes = this.fallbacks(cctx.shared().exchange().readyAffinityVersion());
            if (F.isEmpty(this.nodes)) {
                throw new ClusterTopologyException("Failed to execute the query (all affinity nodes left the grid) [cache=" + cctx.name() + ", qry=" + qry + ", curTopVer=" + qryMgr.queryTopologyVersion().topologyVersion() + ']');
            }
            this.init();
        }

        private Queue<ClusterNode> fallbacks(AffinityTopologyVersion topVer) {
            LinkedList<ClusterNode> fallbacks = new LinkedList<ClusterNode>();
            HashSet<ClusterNode> owners = new HashSet<ClusterNode>();
            for (ClusterNode node : this.cctx.topology().owners(this.part, topVer)) {
                if (node.isLocal()) {
                    fallbacks.addFirst(node);
                } else {
                    fallbacks.add(node);
                }
                owners.add(node);
            }
            for (ClusterNode node : this.cctx.topology().moving(this.part)) {
                if (owners.contains(node)) continue;
                fallbacks.add(node);
            }
            return fallbacks;
        }

        private void init() {
            ClusterNode node = this.nodes.poll();
            if (node.isLocal()) {
                try {
                    GridCloseableIterator it = this.qryMgr.scanQueryLocal(this.qry, true);
                    this.tuple = new T2<GridCloseableIterator, Object>(it, null);
                }
                catch (IgniteClientDisconnectedCheckedException e) {
                    throw CU.convertToCacheException(e);
                }
                catch (IgniteCheckedException e) {
                    this.retryIfPossible(e);
                }
            } else {
                GridCacheQueryBean bean = new GridCacheQueryBean(this.qry, null, this.qry.transform, null);
                GridCacheQueryFutureAdapter fut = (GridCacheQueryFutureAdapter)this.qryMgr.queryDistributed(bean, Collections.singleton(node));
                this.tuple = new T2<Object, GridCacheQueryFutureAdapter>(null, fut);
            }
        }

        protected Object onNext() throws IgniteCheckedException {
            if (!this.onHasNext()) {
                throw new NoSuchElementException();
            }
            assert (this.cur != null);
            Object e = this.cur;
            this.cur = null;
            return e;
        }

        @Override
        protected boolean onHasNext() throws IgniteCheckedException {
            while (this.cur == null) {
                T2<GridCloseableIterator<Object>, GridCacheQueryFutureAdapter> t = this.tuple;
                GridCloseableIterator iter = (GridCloseableIterator)t.get1();
                if (iter != null) {
                    boolean hasNext = iter.hasNext();
                    if (hasNext) {
                        this.cur = iter.next();
                    }
                    return hasNext;
                }
                GridCacheQueryFutureAdapter fut = (GridCacheQueryFutureAdapter)t.get2();
                assert (fut != null);
                if (this.firstItemReturned) {
                    this.cur = this.convert(fut.next());
                    return this.cur != null;
                }
                try {
                    fut.awaitFirstItemAvailable();
                    this.firstItemReturned = true;
                    this.cur = this.convert(fut.next());
                    return this.cur != null;
                }
                catch (IgniteClientDisconnectedCheckedException e) {
                    throw CU.convertToCacheException(e);
                }
                catch (IgniteCheckedException e) {
                    this.retryIfPossible(e);
                    continue;
                }
                break;
            }
            return true;
        }

        private Object convert(Object obj) {
            if (this.qry.transform() != null) {
                return obj;
            }
            Map.Entry e = (Map.Entry)obj;
            return e == null ? null : new CacheQueryEntry(e.getKey(), e.getValue());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void retryIfPossible(IgniteCheckedException e) {
            try {
                IgniteInternalFuture<AffinityTopologyVersion> retryFut;
                GridDhtUnreservedPartitionException partErr = X.cause(e, GridDhtUnreservedPartitionException.class);
                if (partErr != null) {
                    AffinityTopologyVersion waitVer = partErr.topologyVersion();
                    assert (waitVer != null);
                    retryFut = this.cctx.shared().exchange().affinityReadyFuture(waitVer);
                } else if (e.hasCause(ClusterTopologyCheckedException.class)) {
                    ClusterTopologyCheckedException topEx = X.cause(e, ClusterTopologyCheckedException.class);
                    retryFut = topEx.retryReadyFuture();
                } else {
                    if (!e.hasCause(ClusterGroupEmptyCheckedException.class)) throw CU.convertToCacheException(e);
                    ClusterGroupEmptyCheckedException ex = X.cause(e, ClusterGroupEmptyCheckedException.class);
                    retryFut = ex.retryReadyFuture();
                }
                if (F.isEmpty(this.nodes)) {
                    if (--this.unreservedNodesRetryCnt <= 0) throw CU.convertToCacheException(e);
                    if (retryFut != null) {
                        retryFut.get();
                    }
                    this.nodes = this.fallbacks(this.unreservedTopVer == null ? this.cctx.shared().exchange().readyAffinityVersion() : this.unreservedTopVer);
                    this.unreservedTopVer = null;
                    this.init();
                    return;
                } else {
                    this.init();
                }
                return;
            }
            catch (IgniteCheckedException ex) {
                throw CU.convertToCacheException(ex);
            }
        }

        @Override
        protected void onClose() throws IgniteCheckedException {
            super.onClose();
            T2<GridCloseableIterator<Object>, GridCacheQueryFutureAdapter> t = this.tuple;
            if (t != null && t.get1() != null) {
                ((GridCloseableIterator)t.get1()).close();
            }
            if (t != null && t.get2() != null) {
                ((GridCacheQueryFutureAdapter)t.get2()).cancel();
            }
        }
    }
}

