/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Map;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.processors.cache.verify.PartitionHashRecordV2;
import org.apache.ignite.internal.processors.cache.verify.PartitionKeyV2;
import org.apache.ignite.internal.processors.cache.verify.TransactionsHashRecord;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.U;

class IncrementalSnapshotVerificationTaskResult
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private Map<Object, TransactionsHashRecord> txHashRes;
    private Map<PartitionKeyV2, PartitionHashRecordV2> partHashRes;
    private Collection<GridCacheVersion> partiallyCommittedTxs;
    private Collection<Exception> exceptions;

    public IncrementalSnapshotVerificationTaskResult() {
    }

    IncrementalSnapshotVerificationTaskResult(Map<Object, TransactionsHashRecord> txHashRes, Map<PartitionKeyV2, PartitionHashRecordV2> partHashRes, Collection<GridCacheVersion> partiallyCommittedTxs, Collection<Exception> exceptions) {
        this.txHashRes = txHashRes;
        this.partHashRes = partHashRes;
        this.partiallyCommittedTxs = partiallyCommittedTxs;
        this.exceptions = exceptions;
    }

    public Map<PartitionKeyV2, PartitionHashRecordV2> partHashRes() {
        return this.partHashRes;
    }

    public Map<Object, TransactionsHashRecord> txHashRes() {
        return this.txHashRes;
    }

    public Collection<GridCacheVersion> partiallyCommittedTxs() {
        return this.partiallyCommittedTxs;
    }

    public Collection<Exception> exceptions() {
        return this.exceptions;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeMap(out, this.txHashRes);
        U.writeMap(out, this.partHashRes);
        U.writeCollection(out, this.partiallyCommittedTxs);
        U.writeCollection(out, this.exceptions);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.txHashRes = U.readMap(in);
        this.partHashRes = U.readMap(in);
        this.partiallyCommittedTxs = U.readCollection(in);
        this.exceptions = U.readCollection(in);
    }
}

