/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.checkpoint;

import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.LongJVMPauseDetector;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.store.PageStore;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointState;
import org.apache.ignite.internal.processors.cache.persistence.DataStorageMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.Checkpoint;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointPagesWriter;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointPagesWriterFactory;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointProgressImpl;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointWorkflow;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.PartitionDestroyQueue;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.PartitionDestroyRequest;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.CheckpointMetricsTracker;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteCacheSnapshotManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotOperation;
import org.apache.ignite.internal.processors.cache.persistence.wal.WALPointer;
import org.apache.ignite.internal.processors.failure.FailureProcessor;
import org.apache.ignite.internal.processors.performancestatistics.PerformanceStatisticsProcessor;
import org.apache.ignite.internal.util.GridConcurrentMultiPairQueue;
import org.apache.ignite.internal.util.StripedExecutor;
import org.apache.ignite.internal.util.future.CountDownFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.internal.util.worker.WorkProgressDispatcher;
import org.apache.ignite.internal.worker.WorkersRegistry;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.thread.IgniteThread;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentLinkedHashMap;

public class Checkpointer
extends GridWorker {
    private static final String CHECKPOINT_STARTED_LOG_FORMAT = "Checkpoint started [checkpointId=%s, startPtr=%s, checkpointBeforeLockTime=%dms, checkpointLockWait=%dms, checkpointListenersExecuteTime=%dms, checkpointLockHoldTime=%dms, walCpRecordFsyncDuration=%dms, writeCheckpointEntryDuration=%dms, splitAndSortCpPagesDuration=%dms, %spages=%d, reason='%s']";
    private final boolean skipSync = IgniteSystemProperties.getBoolean("IGNITE_PDS_CHECKPOINT_TEST_SKIP_SYNC");
    private static final long PARTITION_DESTROY_CHECKPOINT_TIMEOUT = 30000L;
    private volatile boolean skipCheckpointOnNodeStop = IgniteSystemProperties.getBoolean("IGNITE_PDS_SKIP_CHECKPOINT_ON_NODE_STOP", false);
    private final int longJvmPauseThreshold = IgniteSystemProperties.getInteger("IGNITE_JVM_PAUSE_DETECTOR_THRESHOLD", 500);
    private final LongJVMPauseDetector pauseDetector;
    private final long checkpointFreq;
    private final FailureProcessor failureProcessor;
    private final IgniteCacheSnapshotManager snapshotMgr;
    private final DataStorageMetricsImpl persStoreMetrics;
    private final GridCacheProcessor cacheProcessor;
    private final CheckpointWorkflow checkpointWorkflow;
    private final CheckpointPagesWriterFactory checkpointPagesWriterFactory;
    private final int checkpointWritePageThreads;
    private final Supplier<Integer> cpFreqDeviation;
    @Nullable
    private volatile IgniteThreadPoolExecutor checkpointWritePagesPool;
    private volatile CheckpointProgressImpl scheduledCp;
    private volatile CheckpointProgressImpl curCpProgress;
    private volatile boolean shutdownNow;
    private long lastCpTs;
    private final PerformanceStatisticsProcessor psproc;
    private GridFutureAdapter<Void> enableChangeApplied;
    private volatile boolean checkpointsEnabled = true;

    Checkpointer(@Nullable String gridName, String name, WorkersRegistry workersRegistry, Function<Class<?>, IgniteLogger> logger, LongJVMPauseDetector detector, FailureProcessor failureProcessor, IgniteCacheSnapshotManager snapshotManager, DataStorageMetricsImpl dsMetrics, GridCacheProcessor cacheProcessor, CheckpointWorkflow checkpoint, CheckpointPagesWriterFactory factory, long checkpointFrequency, int checkpointWritePageThreads, Supplier<Integer> cpFreqDeviation) {
        super(gridName, name, logger.apply(Checkpointer.class), workersRegistry);
        this.pauseDetector = detector;
        this.checkpointFreq = checkpointFrequency;
        this.failureProcessor = failureProcessor;
        this.snapshotMgr = snapshotManager;
        this.checkpointWorkflow = checkpoint;
        this.checkpointPagesWriterFactory = factory;
        this.persStoreMetrics = dsMetrics;
        this.cacheProcessor = cacheProcessor;
        this.checkpointWritePageThreads = Math.max(checkpointWritePageThreads, 1);
        this.checkpointWritePagesPool = this.initializeCheckpointPool();
        this.cpFreqDeviation = cpFreqDeviation;
        this.psproc = cacheProcessor.context().kernalContext().performanceStatistics();
        this.scheduledCp = new CheckpointProgressImpl(this.nextCheckpointInterval());
    }

    private IgniteThreadPoolExecutor initializeCheckpointPool() {
        if (this.checkpointWritePageThreads > 1) {
            return new IgniteThreadPoolExecutor("checkpoint-runner-IO", this.igniteInstanceName(), this.checkpointWritePageThreads, this.checkpointWritePageThreads, 30000L, new LinkedBlockingQueue<Runnable>());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void body() {
        Throwable err = null;
        try {
            while (!this.isCancelled()) {
                this.waitCheckpointEvent();
                if (this.skipCheckpointOnNodeStop && (this.isCancelled() || this.shutdownNow)) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Skipping last checkpoint because node is stopping.");
                    }
                    return;
                }
                GridFutureAdapter<Void> enableChangeApplied = this.enableChangeApplied;
                if (enableChangeApplied != null) {
                    enableChangeApplied.onDone();
                    this.enableChangeApplied = null;
                }
                if (this.checkpointsEnabled && !this.shutdownNow) {
                    this.doCheckpoint();
                    continue;
                }
                Checkpointer checkpointer = this;
                synchronized (checkpointer) {
                    this.scheduledCp.nextCpNanos(System.nanoTime() + U.millisToNanos(this.nextCheckpointInterval()));
                }
            }
            if (this.checkpointsEnabled && !this.shutdownNow) {
                this.doCheckpoint();
            }
        }
        catch (Throwable t) {
            err = t;
            this.scheduledCp.fail(t);
            throw t;
        }
        finally {
            if (err == null && !this.isCancelled.get()) {
                err = new IllegalStateException("Thread is terminated unexpectedly: " + this.name());
            }
            if (err instanceof OutOfMemoryError) {
                this.failureProcessor.process(new FailureContext(FailureType.CRITICAL_ERROR, err));
            } else if (err != null) {
                this.failureProcessor.process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, err));
            }
            this.scheduledCp.fail(new NodeStoppingException("Node is stopping."));
        }
    }

    public CheckpointProgress scheduleCheckpoint(long delayFromNow, String reason) {
        return this.scheduleCheckpoint(delayFromNow, reason, null);
    }

    private long nextCheckpointInterval() {
        Integer deviation = this.cpFreqDeviation.get();
        if (deviation == null || deviation == 0) {
            return this.checkpointFreq;
        }
        long startDelay = ThreadLocalRandom.current().nextLong(U.ensurePositive(U.safeAbs(this.checkpointFreq * (long)deviation.intValue()) / 100L, 1L)) - U.ensurePositive(U.safeAbs(this.checkpointFreq * (long)deviation.intValue()) / 200L, 1L);
        return U.safeAbs(this.checkpointFreq + startDelay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> CheckpointProgress scheduleCheckpoint(long delayFromNow, String reason, IgniteInClosure<? super IgniteInternalFuture<R>> lsnr) {
        CheckpointProgressImpl sched = this.curCpProgress;
        if (lsnr == null && sched != null && !sched.greaterOrEqualTo(CheckpointState.LOCK_TAKEN)) {
            return sched;
        }
        if (lsnr != null) {
            Checkpointer checkpointer = this;
            synchronized (checkpointer) {
                sched = this.scheduledCp;
                sched.futureFor(CheckpointState.FINISHED).listen(lsnr);
            }
        }
        sched = this.scheduledCp;
        long nextNanos = System.nanoTime() + U.millisToNanos(delayFromNow);
        if (sched.nextCpNanos() - nextNanos <= 0L) {
            return sched;
        }
        Checkpointer checkpointer = this;
        synchronized (checkpointer) {
            sched = this.scheduledCp;
            if (sched.nextCpNanos() - nextNanos > 0L) {
                sched.reason(reason);
                sched.nextCpNanos(nextNanos);
            }
            this.notifyAll();
        }
        return sched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteInternalFuture wakeupForSnapshotCreation(SnapshotOperation snapshotOperation) {
        GridFutureAdapter ret;
        Checkpointer checkpointer = this;
        synchronized (checkpointer) {
            this.scheduledCp.nextCpNanos(System.nanoTime());
            this.scheduledCp.reason("snapshot");
            this.scheduledCp.nextSnapshot(true);
            this.scheduledCp.snapshotOperation(snapshotOperation);
            ret = this.scheduledCp.futureFor(CheckpointState.LOCK_RELEASED);
            this.notifyAll();
        }
        return ret;
    }

    private void doCheckpoint() {
        Checkpoint chp = null;
        try {
            CheckpointMetricsTracker tracker = new CheckpointMetricsTracker();
            this.startCheckpointProgress();
            try {
                chp = this.checkpointWorkflow.markCheckpointBegin(this.lastCpTs, this.curCpProgress, tracker, this);
            }
            catch (Exception e) {
                if (this.curCpProgress != null) {
                    this.curCpProgress.fail(e);
                }
                this.failureProcessor.process(new FailureContext(FailureType.CRITICAL_ERROR, e));
                throw new IgniteException(e);
            }
            this.updateHeartbeat();
            this.currentProgress().initCounters(chp.pagesSize);
            if (chp.hasDelta()) {
                if (this.log.isInfoEnabled()) {
                    long possibleJvmPauseDur = this.possibleLongJvmPauseDuration(tracker);
                    this.log.info(String.format(CHECKPOINT_STARTED_LOG_FORMAT, chp.cpEntry == null ? "" : chp.cpEntry.checkpointId(), chp.cpEntry == null ? "" : chp.cpEntry.checkpointMark(), tracker.beforeLockDuration(), tracker.lockWaitDuration(), tracker.listenersExecuteDuration(), tracker.lockHoldDuration(), tracker.walCpRecordFsyncDuration(), tracker.writeCheckpointEntryDuration(), tracker.splitAndSortCpPagesDuration(), possibleJvmPauseDur > 0L ? "possibleJvmPauseDuration=" + possibleJvmPauseDur + "ms, " : "", chp.pagesSize, chp.progress.reason()));
                }
                if (!this.writePages(tracker, chp.cpPages, chp.progress, this, this::isShutdownNow)) {
                    return;
                }
            } else {
                if (this.log.isInfoEnabled()) {
                    LT.info(this.log, String.format("Skipping checkpoint (no pages were modified) [checkpointBeforeLockTime=%dms, checkpointLockWait=%dms, checkpointListenersExecuteTime=%dms, checkpointLockHoldTime=%dms, reason='%s']", tracker.beforeLockDuration(), tracker.lockWaitDuration(), tracker.listenersExecuteDuration(), tracker.lockHoldDuration(), chp.progress.reason()));
                }
                tracker.onPagesWriteStart();
                tracker.onFsyncStart();
            }
            this.snapshotMgr.afterCheckpointPageWritten();
            int destroyedPartitionsCnt = this.destroyEvictedPartitions();
            this.checkpointWorkflow.markCheckpointEnd(chp);
            tracker.onEnd();
            if ((chp.hasDelta() || destroyedPartitionsCnt > 0) && this.log.isInfoEnabled()) {
                this.log.info(String.format("Checkpoint finished [cpId=%s, pages=%d, markPos=%s, walSegmentsCovered=%s, markDuration=%dms, pagesWrite=%dms, fsync=%dms, total=%dms]", chp.cpEntry != null ? chp.cpEntry.checkpointId() : "", chp.pagesSize, chp.cpEntry != null ? chp.cpEntry.checkpointMark() : "", this.walRangeStr(chp.walSegsCoveredRange), tracker.markDuration(), tracker.pagesWriteDuration(), tracker.fsyncDuration(), tracker.totalDuration()));
            }
            this.updateMetrics(chp, tracker);
        }
        catch (IgniteCheckedException e) {
            chp.progress.fail(e);
            this.failureProcessor.process(new FailureContext(FailureType.CRITICAL_ERROR, e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean writePages(CheckpointMetricsTracker tracker, GridConcurrentMultiPairQueue<PageMemoryEx, FullPageId> cpPages, CheckpointProgressImpl curCpProgress, WorkProgressDispatcher workProgressDispatcher, BooleanSupplier shutdownNow) throws IgniteCheckedException {
        IgniteThreadPoolExecutor pageWritePool = this.checkpointWritePagesPool;
        int checkpointWritePageThreads = pageWritePool == null ? 1 : pageWritePool.getMaximumPoolSize();
        ConcurrentLinkedHashMap<PageStore, LongAdder> updStores = new ConcurrentLinkedHashMap<PageStore, LongAdder>();
        CountDownFuture doneWriteFut = new CountDownFuture(checkpointWritePageThreads);
        tracker.onPagesWriteStart();
        for (int i = 0; i < checkpointWritePageThreads; ++i) {
            CheckpointPagesWriter write = this.checkpointPagesWriterFactory.build(tracker, cpPages, updStores, doneWriteFut, workProgressDispatcher::updateHeartbeat, curCpProgress, shutdownNow);
            if (pageWritePool == null) {
                write.run();
                continue;
            }
            try {
                pageWritePool.execute(write);
                continue;
            }
            catch (RejectedExecutionException ignore) {
                write.run();
            }
        }
        workProgressDispatcher.updateHeartbeat();
        doneWriteFut.get();
        if (shutdownNow.getAsBoolean()) {
            curCpProgress.fail(new NodeStoppingException("Node is stopping."));
            return false;
        }
        tracker.onFsyncStart();
        if (!this.skipSync) {
            for (Map.Entry<PageStore, LongAdder> updStoreEntry : updStores.entrySet()) {
                if (shutdownNow.getAsBoolean()) {
                    curCpProgress.fail(new NodeStoppingException("Node is stopping."));
                    return false;
                }
                workProgressDispatcher.blockingSectionBegin();
                try {
                    updStoreEntry.getKey().sync();
                }
                finally {
                    workProgressDispatcher.blockingSectionEnd();
                }
                curCpProgress.updateSyncedPages(updStoreEntry.getValue().intValue());
            }
        }
        return true;
    }

    private void updateMetrics(Checkpoint chp, CheckpointMetricsTracker tracker) {
        if (this.psproc.enabled()) {
            this.psproc.checkpoint(tracker.beforeLockDuration(), tracker.lockWaitDuration(), tracker.listenersExecuteDuration(), tracker.markDuration(), tracker.lockHoldDuration(), tracker.pagesWriteDuration(), tracker.fsyncDuration(), tracker.walCpRecordFsyncDuration(), tracker.writeCheckpointEntryDuration(), tracker.splitAndSortCpPagesDuration(), tracker.totalDuration(), tracker.checkpointStartTime(), chp.pagesSize, tracker.dataPagesWritten(), tracker.cowPagesWritten());
        }
        if (this.persStoreMetrics.metricsEnabled()) {
            GridCacheDatabaseSharedManager dbMgr = (GridCacheDatabaseSharedManager)this.cacheProcessor.context().database();
            this.persStoreMetrics.onCheckpoint(tracker.beforeLockDuration(), tracker.lockWaitDuration(), tracker.listenersExecuteDuration(), tracker.markDuration(), tracker.lockHoldDuration(), tracker.pagesWriteDuration(), tracker.fsyncDuration(), tracker.walCpRecordFsyncDuration(), tracker.writeCheckpointEntryDuration(), tracker.splitAndSortCpPagesDuration(), tracker.totalDuration(), tracker.checkpointStartTime(), chp.pagesSize, tracker.dataPagesWritten(), tracker.cowPagesWritten(), dbMgr.forAllPageStores(PageStore::size), dbMgr.forAllPageStores(PageStore::getSparseSize));
        }
    }

    private String walRangeStr(@Nullable IgniteBiTuple<Long, Long> walRange) {
        if (walRange == null) {
            return "";
        }
        long startIdx = walRange.get1();
        long endIdx = walRange.get2();
        String res = endIdx < 0L || endIdx < startIdx ? "[]" : (endIdx == startIdx ? "[" + endIdx + "]" : "[" + startIdx + " - " + endIdx + "]");
        return res;
    }

    private int destroyEvictedPartitions() throws IgniteCheckedException {
        PartitionDestroyQueue destroyQueue = this.curCpProgress.getDestroyQueue();
        if (destroyQueue.pendingReqs().isEmpty()) {
            return 0;
        }
        ArrayList<PartitionDestroyRequest> reqs = null;
        for (PartitionDestroyRequest req : destroyQueue.pendingReqs().values()) {
            if (!req.beginDestroy()) continue;
            int grpId = req.groupId();
            int partId = req.partitionId();
            CacheGroupContext grp = this.cacheProcessor.cacheGroup(grpId);
            assert (grp != null) : "Cache group is not initialized [grpId=" + grpId + "]";
            assert (grp.offheap() instanceof GridCacheOffheapManager) : "Destroying partition files when persistence is off " + grp.offheap();
            GridCacheOffheapManager offheap = (GridCacheOffheapManager)grp.offheap();
            Runnable destroyPartTask = () -> {
                try {
                    offheap.destroyPartitionStore(partId);
                    req.onDone(null);
                    grp.metrics().decrementInitializedLocalPartitions();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Partition file has destroyed [grpId=" + grpId + ", partId=" + partId + "]");
                    }
                }
                catch (Exception e) {
                    req.onDone(new IgniteCheckedException("Partition file destroy has failed [grpId=" + grpId + ", partId=" + partId + "]", e));
                }
            };
            IgniteThreadPoolExecutor pool = this.checkpointWritePagesPool;
            if (pool != null) {
                try {
                    pool.execute(destroyPartTask);
                }
                catch (RejectedExecutionException ignore) {
                    destroyPartTask.run();
                }
            } else {
                destroyPartTask.run();
            }
            if (reqs == null) {
                reqs = new ArrayList<PartitionDestroyRequest>();
            }
            reqs.add(req);
        }
        if (reqs != null) {
            for (PartitionDestroyRequest req : reqs) {
                req.waitCompleted();
            }
        }
        destroyQueue.pendingReqs().clear();
        return reqs != null ? reqs.size() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedulePartitionDestroy(@Nullable CacheGroupContext grpCtx, int grpId, int partId) {
        Checkpointer checkpointer = this;
        synchronized (checkpointer) {
            this.scheduledCp.getDestroyQueue().addDestroyRequest(grpCtx, grpId, partId);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Partition file has been scheduled to destroy [grpId=" + grpId + ", partId=" + partId + "]");
        }
        if (grpCtx != null) {
            this.scheduleCheckpoint(30000L, "partition destroy");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelOrWaitPartitionDestroy(int grpId, int partId) throws IgniteCheckedException {
        PartitionDestroyRequest req;
        boolean canceled = false;
        Checkpointer checkpointer = this;
        synchronized (checkpointer) {
            CheckpointProgressImpl cur;
            req = this.scheduledCp.getDestroyQueue().removeRequest(grpId, partId);
            if (req != null) {
                canceled = req.cancel();
                assert (canceled);
            }
            if ((cur = this.curCpProgress) != null && (req = cur.getDestroyQueue().removeRequest(grpId, partId)) != null) {
                canceled = req.cancel();
            }
        }
        if (!canceled) {
            if (req != null) {
                req.waitCompleted();
            }
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Partition file destroy has cancelled [grpId=" + grpId + ", partId=" + partId + "]");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitCheckpointEvent() {
        try {
            Checkpointer checkpointer = this;
            synchronized (checkpointer) {
                long remaining = U.nanosToMillis(this.scheduledCp.nextCpNanos() - System.nanoTime());
                while (remaining > 0L && !this.isCancelled()) {
                    this.blockingSectionBegin();
                    try {
                        this.wait(remaining);
                        remaining = U.nanosToMillis(this.scheduledCp.nextCpNanos() - System.nanoTime());
                    }
                    finally {
                        this.blockingSectionEnd();
                    }
                }
            }
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            this.isCancelled.set(true);
        }
    }

    private long possibleLongJvmPauseDuration(CheckpointMetricsTracker tracker) {
        if (LongJVMPauseDetector.enabled() && tracker.lockWaitDuration() + tracker.lockHoldDuration() > (long)this.longJvmPauseThreshold) {
            long now = System.currentTimeMillis();
            long wakeUpTime = this.pauseDetector.getLastWakeUpTime();
            IgniteBiTuple<Long, Long> lastLongPause = this.pauseDetector.getLastLongPause();
            if (lastLongPause != null && tracker.checkpointStartTime() < lastLongPause.get1()) {
                return lastLongPause.get2();
            }
            if (now - wakeUpTime > (long)this.longJvmPauseThreshold) {
                return now - wakeUpTime;
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCheckpointProgress() {
        long cpTs = System.currentTimeMillis();
        if (cpTs == this.lastCpTs) {
            ++cpTs;
        }
        this.lastCpTs = cpTs;
        Checkpointer checkpointer = this;
        synchronized (checkpointer) {
            CheckpointProgressImpl curr = this.scheduledCp;
            if (curr.reason() == null) {
                curr.reason("timeout");
            }
            this.scheduledCp = new CheckpointProgressImpl(this.nextCheckpointInterval());
            this.curCpProgress = curr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Cancelling grid runnable: " + this);
        }
        this.isCancelled.set(true);
        Checkpointer checkpointer = this;
        synchronized (checkpointer) {
            this.notifyAll();
        }
    }

    public IgniteInternalFuture<Void> enableCheckpoints(boolean enable) {
        GridFutureAdapter<Void> fut = new GridFutureAdapter<Void>();
        this.enableChangeApplied = fut;
        this.checkpointsEnabled = enable;
        return fut;
    }

    public void shutdownNow() {
        this.shutdownNow = true;
        if (!this.isCancelled.get()) {
            this.cancel();
        }
    }

    public void start() {
        if (this.runner() != null) {
            return;
        }
        assert (this.runner() == null) : "Checkpointer is running.";
        new IgniteThread(this).start();
    }

    public void shutdownCheckpointer(boolean cancel) {
        if (cancel) {
            this.shutdownNow();
        } else {
            this.cancel();
        }
        try {
            U.join(this);
        }
        catch (IgniteInterruptedCheckedException ignore) {
            U.warn(this.log, "Was interrupted while waiting for checkpointer shutdown, will not wait for checkpoint to finish.");
            this.shutdownNow();
            while (true) {
                try {
                    U.join(this);
                    this.scheduledCp.fail(new NodeStoppingException("Checkpointer is stopped during node stop."));
                }
                catch (IgniteInterruptedCheckedException igniteInterruptedCheckedException) {
                    continue;
                }
                break;
            }
            Thread.currentThread().interrupt();
        }
        IgniteThreadPoolExecutor pool = this.checkpointWritePagesPool;
        if (pool != null) {
            pool.shutdownNow();
            try {
                pool.awaitTermination(2L, TimeUnit.MINUTES);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
            this.checkpointWritePagesPool = null;
        }
    }

    public void finalizeCheckpointOnRecovery(long cpTs, UUID cpId, WALPointer walPtr, StripedExecutor exec) throws IgniteCheckedException {
        this.checkpointWorkflow.finalizeCheckpointOnRecovery(cpTs, cpId, walPtr, exec, this.checkpointPagesWriterFactory);
    }

    public CheckpointProgress currentProgress() {
        return this.curCpProgress;
    }

    private boolean isShutdownNow() {
        return this.shutdownNow;
    }

    public void skipCheckpointOnNodeStop(boolean skip) {
        this.skipCheckpointOnNodeStop = skip;
    }
}

