/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.checkpoint;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointState;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.PartitionDestroyQueue;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotOperation;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;

public class CheckpointProgressImpl
implements CheckpointProgress {
    private volatile long nextCpNanos;
    private volatile AtomicReference<CheckpointState> state = new AtomicReference<CheckpointState>(CheckpointState.SCHEDULED);
    private final Map<CheckpointState, GridFutureAdapter> stateFutures = new ConcurrentHashMap<CheckpointState, GridFutureAdapter>();
    private volatile Throwable failCause;
    private volatile boolean nextSnapshot;
    private volatile SnapshotOperation snapshotOperation;
    private final PartitionDestroyQueue destroyQueue = new PartitionDestroyQueue();
    private String reason;
    private volatile AtomicInteger writtenPagesCntr;
    private volatile AtomicInteger syncedPagesCntr;
    private volatile AtomicInteger evictedPagesCntr;
    private volatile int currCheckpointPagesCnt;

    CheckpointProgressImpl(long cpFreq) {
        cpFreq = Math.min(TimeUnit.DAYS.toMillis(365L), cpFreq);
        this.nextCpNanos = System.nanoTime() + U.millisToNanos(cpFreq);
    }

    @Override
    public boolean inProgress() {
        return this.greaterOrEqualTo(CheckpointState.LOCK_RELEASED) && !this.greaterOrEqualTo(CheckpointState.FINISHED);
    }

    public boolean greaterOrEqualTo(CheckpointState expectedState) {
        return this.state.get().ordinal() >= expectedState.ordinal();
    }

    @Override
    public GridFutureAdapter futureFor(CheckpointState state) {
        GridFutureAdapter stateFut = this.stateFutures.computeIfAbsent(state, k -> new GridFutureAdapter());
        if (this.greaterOrEqualTo(state) && !stateFut.isDone()) {
            stateFut.onDone(this.failCause);
        }
        return stateFut;
    }

    @Override
    public void fail(Throwable error) {
        this.failCause = error;
        this.transitTo(CheckpointState.FINISHED);
    }

    @Override
    public void transitTo(@NotNull CheckpointState newState) {
        CheckpointState state = this.state.get();
        if (state.ordinal() < newState.ordinal()) {
            this.state.compareAndSet(state, newState);
            this.doFinishFuturesWhichLessOrEqualTo(newState);
        }
    }

    private void doFinishFuturesWhichLessOrEqualTo(@NotNull CheckpointState lastState) {
        for (CheckpointState old : CheckpointState.values()) {
            GridFutureAdapter fut = this.stateFutures.get((Object)old);
            if (fut != null && !fut.isDone()) {
                fut.onDone(this.failCause);
            }
            if (old != lastState) continue;
            return;
        }
    }

    @Override
    public PartitionDestroyQueue getDestroyQueue() {
        return this.destroyQueue;
    }

    public boolean nextSnapshot() {
        return this.nextSnapshot;
    }

    public long nextCpNanos() {
        return this.nextCpNanos;
    }

    public void nextCpNanos(long nextCpNanos) {
        this.nextCpNanos = nextCpNanos;
    }

    @Override
    public String reason() {
        return this.reason;
    }

    public void reason(String reason) {
        this.reason = reason;
    }

    public SnapshotOperation snapshotOperation() {
        return this.snapshotOperation;
    }

    public void snapshotOperation(SnapshotOperation snapshotOperation) {
        this.snapshotOperation = snapshotOperation;
    }

    public void nextSnapshot(boolean nextSnapshot) {
        this.nextSnapshot = nextSnapshot;
    }

    @Override
    public AtomicInteger writtenPagesCounter() {
        return this.writtenPagesCntr;
    }

    @Override
    public void updateWrittenPages(int deltha) {
        A.ensure(deltha > 0, "param must be positive");
        this.writtenPagesCntr.addAndGet(deltha);
    }

    @Override
    public AtomicInteger syncedPagesCounter() {
        return this.syncedPagesCntr;
    }

    @Override
    public void updateSyncedPages(int deltha) {
        A.ensure(deltha > 0, "param must be positive");
        this.syncedPagesCntr.addAndGet(deltha);
    }

    @Override
    public AtomicInteger evictedPagesCounter() {
        return this.evictedPagesCntr;
    }

    @Override
    public void updateEvictedPages(int delta) {
        A.ensure(delta > 0, "param must be positive");
        if (this.evictedPagesCounter() != null) {
            this.evictedPagesCounter().addAndGet(delta);
        }
    }

    @Override
    public int currentCheckpointPagesCount() {
        return this.currCheckpointPagesCnt;
    }

    @Override
    public void currentCheckpointPagesCount(int num) {
        this.currCheckpointPagesCnt = num;
    }

    @Override
    public void initCounters(int pagesSize) {
        this.currCheckpointPagesCnt = pagesSize;
        this.writtenPagesCntr = new AtomicInteger();
        this.syncedPagesCntr = new AtomicInteger();
        this.evictedPagesCntr = new AtomicInteger();
    }

    @Override
    public void clearCounters() {
        this.currCheckpointPagesCnt = 0;
        this.writtenPagesCntr = null;
        this.syncedPagesCntr = null;
        this.evictedPagesCntr = null;
    }

    @Override
    public void onStateChanged(CheckpointState state, Runnable clo) {
        GridFutureAdapter fut0 = this.futureFor(state);
        fut0.listen(fut -> {
            if (fut.error() == null) {
                clo.run();
            }
        });
    }
}

