/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtForceKeysRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtForceKeysResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUpdateVersionAware;
import org.apache.ignite.internal.processors.cache.mvcc.MvccVersionAware;
import org.apache.ignite.internal.processors.dr.GridDrType;
import org.apache.ignite.internal.util.F0;
import org.apache.ignite.internal.util.GridLeanSet;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public final class GridDhtForceKeysFuture<K, V>
extends GridCompoundFuture<Object, Collection<K>>
implements GridDhtFuture<Collection<K>> {
    private static final long serialVersionUID = 0L;
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private static IgniteLogger log;
    private static final long REMAP_PAUSE = 1000L;
    private GridCacheContext<K, V> cctx;
    private GridDhtPartitionTopology top;
    private Collection<KeyCacheObject> keys;
    private Collection<Integer> invalidParts = new GridLeanSet<Integer>();
    private AtomicInteger topCntr = new AtomicInteger(1);
    private AffinityTopologyVersion topVer;
    private IgniteUuid futId = IgniteUuid.randomUuid();
    private boolean trackable;

    public GridDhtForceKeysFuture(GridCacheContext<K, V> cctx, AffinityTopologyVersion topVer, Collection<KeyCacheObject> keys) {
        assert (topVer.topologyVersion() != 0L) : topVer;
        assert (!F.isEmpty(keys)) : keys;
        assert (!cctx.isNear());
        this.cctx = cctx;
        this.keys = keys;
        this.topVer = topVer;
        this.top = cctx.dht().topology();
        if (log == null) {
            log = U.logger(cctx.kernalContext(), logRef, GridDhtForceKeysFuture.class);
        }
    }

    public IgniteUuid futureId() {
        return this.futId;
    }

    @Override
    public Collection<Integer> invalidPartitions() {
        return this.invalidParts;
    }

    private boolean isMini(IgniteInternalFuture<?> f) {
        return f.getClass().equals(MiniFuture.class);
    }

    @Override
    public boolean onDone(@Nullable Collection<K> res, @Nullable Throwable err) {
        if (super.onDone(res, err)) {
            if (this.trackable) {
                this.cctx.dht().removeFuture(this);
            }
            return true;
        }
        return false;
    }

    public void onDiscoveryEvent(DiscoveryEvent evt) {
        this.topCntr.incrementAndGet();
        int type = evt.type();
        for (IgniteInternalFuture f : this.futures()) {
            if (!this.isMini(f)) continue;
            MiniFuture mini = (MiniFuture)f;
            mini.onDiscoveryEvent();
            if (type != 11 && type != 12 || !mini.node().id().equals(evt.eventNode().id())) continue;
            mini.onResult();
            break;
        }
    }

    public void onResult(GridDhtForceKeysResponse res) {
        for (IgniteInternalFuture f : this.futures()) {
            MiniFuture mini;
            if (!this.isMini(f) || !(mini = (MiniFuture)f).miniId().equals(res.miniId())) continue;
            mini.onResult(res);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Failed to find mini future for response [cacheName=" + this.cctx.name() + ", res=" + res + ']');
        }
    }

    public void init() {
        assert (this.cctx.preloader().startFuture().isDone());
        this.map(this.keys, Collections.emptyList());
        this.markInitialized();
    }

    private boolean map(Iterable<KeyCacheObject> keys, Collection<ClusterNode> exc) {
        Map<ClusterNode, Set<KeyCacheObject>> mappings = null;
        for (KeyCacheObject key : keys) {
            mappings = this.map(key, mappings, exc);
        }
        if (this.isDone()) {
            return false;
        }
        boolean ret = false;
        if (mappings != null) {
            assert (!this.cctx.mvccEnabled());
            ClusterNode loc = this.cctx.localNode();
            int curTopVer = this.topCntr.get();
            if (!this.cctx.dht().addFuture(this)) {
                assert (this.isDone()) : this;
                return false;
            }
            this.trackable = true;
            for (Map.Entry<ClusterNode, Set<KeyCacheObject>> mapped : mappings.entrySet()) {
                ClusterNode n = mapped.getKey();
                Set<KeyCacheObject> mappedKeys = mapped.getValue();
                int cnt = F.size(mappedKeys, new IgnitePredicate[0]);
                if (cnt <= 0) continue;
                ret = true;
                MiniFuture fut = new MiniFuture(n, mappedKeys, curTopVer, exc);
                GridDhtForceKeysRequest req = new GridDhtForceKeysRequest(this.cctx.cacheId(), this.futId, fut.miniId(), mappedKeys, this.topVer, this.cctx.deploymentEnabled());
                try {
                    this.add(fut);
                    assert (!n.id().equals(loc.id()));
                    if (log.isTraceEnabled()) {
                        log.trace("Sending force key request [cacheName=" + this.cctx.name() + "node=" + n.id() + ", req=" + req + ']');
                    }
                    this.cctx.io().send(n, (GridCacheMessage)req, this.cctx.ioPolicy());
                }
                catch (IgniteCheckedException e) {
                    if (e instanceof ClusterTopologyCheckedException) {
                        fut.onResult();
                        continue;
                    }
                    if (this.cctx.kernalContext().isStopping()) continue;
                    fut.onResult(e);
                }
            }
        }
        return ret;
    }

    private Map<ClusterNode, Set<KeyCacheObject>> map(KeyCacheObject key, @Nullable Map<ClusterNode, Set<KeyCacheObject>> mappings, Collection<ClusterNode> exc) {
        List<Object> owners;
        ClusterNode loc;
        block21: {
            loc = this.cctx.localNode();
            GridCacheEntryEx e = this.cctx.dht().peekEx(key);
            try {
                if (e != null && !e.isNewLocked()) {
                    if (log.isTraceEnabled()) {
                        int part = this.cctx.affinity().partition(key);
                        log.trace("Will not rebalance key (entry is not new) [cacheName=" + this.cctx.name() + ", key=" + key + ", part=" + part + ", locId=" + this.cctx.nodeId() + ']');
                    }
                    return mappings;
                }
            }
            catch (GridCacheEntryRemovedException ignore) {
                if (!log.isTraceEnabled()) break block21;
                log.trace("Received removed DHT entry for force keys request [entry=" + e + ", locId=" + this.cctx.nodeId() + ']');
            }
        }
        int part = this.cctx.affinity().partition(key);
        List<Object> list = owners = F.isEmpty(exc) ? this.top.owners(part, this.topVer) : new ArrayList<ClusterNode>(F.view(this.top.owners(part, this.topVer), F.notIn(exc)));
        if (owners.isEmpty() || owners.contains(loc) && this.cctx.rebalanceEnabled()) {
            if (log.isTraceEnabled()) {
                log.trace("Will not rebalance key (local node is owner) [key=" + key + ", part=" + part + "topVer=" + this.topVer + ", locId=" + this.cctx.nodeId() + ']');
            }
            return mappings;
        }
        GridDhtLocalPartition locPart = this.top.localPartition(part, this.topVer, false);
        if (log.isTraceEnabled()) {
            log.trace("Mapping local partition [loc=" + this.cctx.localNodeId() + ", topVer" + this.topVer + ", part=" + locPart + ", owners=" + owners + ", allOwners=" + U.toShortString(this.top.owners(part)) + ']');
        }
        if (locPart == null) {
            this.invalidParts.add(part);
        } else if (!this.cctx.rebalanceEnabled() || locPart.state() == GridDhtPartitionState.MOVING) {
            Collections.sort(owners, CU.nodeComparator(false));
            ClusterNode pick = (ClusterNode)F.first(owners);
            assert (pick != null);
            if (!this.cctx.rebalanceEnabled() && loc.id().equals(pick.id())) {
                pick = (ClusterNode)F.first(F.view(owners, F.remoteNodes(loc.id())));
            }
            if (pick == null) {
                if (log.isTraceEnabled()) {
                    log.trace("Will not rebalance key (no nodes to request from with rebalancing disabled) [key=" + key + ", part=" + part + ", locId=" + this.cctx.nodeId() + ']');
                }
                return mappings;
            }
            if (mappings == null) {
                mappings = U.newHashMap(this.keys.size());
            }
            Collection mappedKeys = (Collection)((Object)F.addIfAbsent(mappings, pick, F.newSet()));
            assert (mappedKeys != null);
            mappedKeys.add(key);
            if (log.isTraceEnabled()) {
                log.trace("Will rebalance key from node [cacheName=" + this.cctx.name() + ", key=" + key + ", part=" + part + ", node=" + pick.id() + ", locId=" + this.cctx.nodeId() + ']');
            }
        } else if (locPart.state() != GridDhtPartitionState.OWNING) {
            this.invalidParts.add(part);
        } else if (log.isTraceEnabled()) {
            log.trace("Will not rebalance key (local partition is not MOVING) [cacheName=" + this.cctx.name() + ", key=" + key + ", part=" + locPart + ", locId=" + this.cctx.nodeId() + ']');
        }
        return mappings;
    }

    @Override
    public String toString() {
        Collection futs = F.viewReadOnly(this.futures(), new C1<IgniteInternalFuture<?>, String>(){

            @Override
            public String apply(IgniteInternalFuture<?> f) {
                return f.toString();
            }
        }, new IgnitePredicate[0]);
        return S.toString(GridDhtForceKeysFuture.class, this, "innerFuts", futs, "super", (Object)super.toString());
    }

    private class MiniFuture
    extends GridFutureAdapter<Object> {
        private IgniteUuid miniId = IgniteUuid.randomUuid();
        private ClusterNode node;
        private Collection<KeyCacheObject> keys;
        private int curTopVer;
        private CountDownLatch pauseLatch = new CountDownLatch(1);
        private Collection<ClusterNode> exc;

        MiniFuture(ClusterNode node, Collection<KeyCacheObject> keys, int curTopVer, Collection<ClusterNode> exc) {
            assert (node != null);
            assert (curTopVer > 0);
            assert (exc != null);
            this.node = node;
            this.keys = keys;
            this.curTopVer = curTopVer;
            this.exc = exc;
        }

        IgniteUuid miniId() {
            return this.miniId;
        }

        ClusterNode node() {
            return this.node;
        }

        void onDiscoveryEvent() {
            this.pauseLatch.countDown();
        }

        void onResult(Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to get future result [fut=" + this + ", err=" + e + ']');
            }
            this.onDone(e);
        }

        void onResult() {
            if (log.isDebugEnabled()) {
                log.debug("Remote node left grid while sending or waiting for reply (will retry): " + this);
            }
            GridDhtForceKeysFuture.this.map(this.keys, F.asList(this.node));
            this.onDone(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onResult(GridDhtForceKeysResponse res) {
            Collection<KeyCacheObject> retryKeys;
            if (res.error() != null) {
                this.onDone(res.error());
                return;
            }
            Collection<KeyCacheObject> missedKeys = res.missedKeys();
            boolean remapMissed = false;
            if (!F.isEmpty(missedKeys)) {
                if (this.curTopVer != GridDhtForceKeysFuture.this.topCntr.get() || this.pauseLatch.getCount() == 0L) {
                    GridDhtForceKeysFuture.this.map(missedKeys, Collections.emptyList());
                } else {
                    remapMissed = true;
                }
            }
            if (!GridDhtForceKeysFuture.this.cctx.rebalanceEnabled() && !(retryKeys = F.view(this.keys, F0.notIn(missedKeys), F0.notIn(F.viewReadOnly(res.forcedInfos(), CU.info2Key(), new IgnitePredicate[0])))).isEmpty()) {
                GridDhtForceKeysFuture.this.map(retryKeys, F.concat(false, this.node, this.exc));
            }
            boolean rec = GridDhtForceKeysFuture.this.cctx.events().isRecordable(84);
            boolean replicate = GridDhtForceKeysFuture.this.cctx.isDrEnabled();
            for (GridCacheEntryInfo info : res.forcedInfos()) {
                int p = GridDhtForceKeysFuture.this.cctx.affinity().partition(info.key());
                GridDhtLocalPartition locPart = GridDhtForceKeysFuture.this.top.localPartition(p, AffinityTopologyVersion.NONE, false);
                if (locPart == null || GridDhtForceKeysFuture.this.cctx.rebalanceEnabled() && locPart.state() != GridDhtPartitionState.MOVING || !locPart.reserve()) continue;
                GridCacheEntryEx entry = GridDhtForceKeysFuture.this.cctx.dht().entryEx(info.key());
                GridDhtForceKeysFuture.this.cctx.shared().database().checkpointReadLock();
                try {
                    if (!entry.initialValue(info.value(), info.version(), GridDhtForceKeysFuture.this.cctx.mvccEnabled() ? ((MvccVersionAware)((Object)info)).mvccVersion() : null, GridDhtForceKeysFuture.this.cctx.mvccEnabled() ? ((MvccUpdateVersionAware)((Object)info)).newMvccVersion() : null, GridDhtForceKeysFuture.this.cctx.mvccEnabled() ? ((MvccVersionAware)((Object)entry)).mvccTxState() : (byte)0, GridDhtForceKeysFuture.this.cctx.mvccEnabled() ? ((MvccUpdateVersionAware)((Object)entry)).newMvccTxState() : (byte)0, info.ttl(), info.expireTime(), true, GridDhtForceKeysFuture.this.topVer, replicate ? GridDrType.DR_PRELOAD : GridDrType.DR_NONE, false, false) || !rec || entry.isInternal()) continue;
                    GridDhtForceKeysFuture.this.cctx.events().addEvent(entry.partition(), entry.key(), GridDhtForceKeysFuture.this.cctx.localNodeId(), null, null, null, 84, info.value(), true, null, false, null, null, false);
                }
                catch (IgniteCheckedException e) {
                    this.onDone(e);
                    return;
                }
                catch (GridCacheEntryRemovedException ignore) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace("Trying to rebalance removed entry (will ignore) [cacheName=" + GridDhtForceKeysFuture.this.cctx.name() + ", entry=" + entry + ']');
                }
                finally {
                    GridDhtForceKeysFuture.this.cctx.shared().database().checkpointReadUnlock();
                    locPart.release();
                }
            }
            if (remapMissed && this.pause()) {
                GridDhtForceKeysFuture.this.map(missedKeys, Collections.emptyList());
            }
            this.onDone(true);
        }

        private boolean pause() {
            try {
                U.await(this.pauseLatch, 1000L, TimeUnit.MILLISECONDS);
                return true;
            }
            catch (IgniteInterruptedCheckedException e) {
                this.onDone(e);
                return false;
            }
        }

        @Override
        public String toString() {
            return S.toString(MiniFuture.class, this, super.toString());
        }
    }
}

