/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.nio.ByteBuffer;
import org.apache.ignite.events.CacheObjectTransformedEvent;
import org.apache.ignite.internal.cache.transform.CacheObjectTransformerManager;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.util.typedef.internal.U;

public class CacheObjectTransformerUtils {
    private static CacheObjectTransformerManager transformer(CacheObjectValueContext ctx) {
        return ctx.kernalContext().cache().context().transformer();
    }

    public static byte[] transformIfNecessary(byte[] bytes, CacheObjectValueContext ctx) {
        return CacheObjectTransformerUtils.transformIfNecessary(bytes, 0, bytes.length, ctx);
    }

    public static byte[] transformIfNecessary(byte[] bytes, int offset, int length, CacheObjectValueContext ctx) {
        assert (bytes[offset] != -3);
        CacheObjectTransformerManager transformer = CacheObjectTransformerUtils.transformer(ctx);
        if (transformer == null) {
            return bytes;
        }
        ByteBuffer src = ByteBuffer.wrap(bytes, offset, length);
        ByteBuffer transformed = transformer.transform(src);
        if (transformed != null) {
            assert (transformed.remaining() > 0) : transformed.remaining();
            byte[] res = CacheObjectTransformerUtils.toArray(transformed);
            if (ctx.kernalContext().event().isRecordable(68)) {
                ctx.kernalContext().event().record(new CacheObjectTransformedEvent(ctx.kernalContext().discovery().localNode(), "Object transformed", 68, CacheObjectTransformerUtils.detachIfNecessary(bytes, offset, length), res, false));
            }
            return res;
        }
        byte[] res = CacheObjectTransformerUtils.detachIfNecessary(bytes, offset, length);
        if (ctx.kernalContext().event().isRecordable(68)) {
            ctx.kernalContext().event().record(new CacheObjectTransformedEvent(ctx.kernalContext().discovery().localNode(), "Object transformation was cancelled.", 68, res, res, false));
        }
        return res;
    }

    private static byte[] detachIfNecessary(byte[] bytes, int offset, int length) {
        if (offset == 0 && length == bytes.length) {
            return bytes;
        }
        byte[] res = new byte[length];
        U.arrayCopy(bytes, offset, res, 0, length);
        return res;
    }

    public static byte[] restoreIfNecessary(byte[] bytes, CacheObjectValueContext ctx) {
        if (bytes[0] != -3) {
            return bytes;
        }
        CacheObjectTransformerManager transformer = CacheObjectTransformerUtils.transformer(ctx);
        ByteBuffer src = ByteBuffer.wrap(bytes, 1, bytes.length - 1);
        ByteBuffer restored = transformer.restore(src);
        byte[] res = CacheObjectTransformerUtils.toArray(restored);
        if (ctx.kernalContext().event().isRecordable(68)) {
            ctx.kernalContext().event().record(new CacheObjectTransformedEvent(ctx.kernalContext().discovery().localNode(), "Object restored", 68, res, bytes, true));
        }
        return res;
    }

    private static byte[] toArray(ByteBuffer buf) {
        if (buf.isDirect()) {
            byte[] res = new byte[buf.remaining()];
            buf.get(res);
            return res;
        }
        if (buf.remaining() != buf.capacity()) {
            throw new IllegalStateException("Unexpected Heap Byte Buffer state. Wrapped array must contain the data without any offsets to avoid unnecessary copying. Position must be 0, limit must be equal to the capacity. [buf=" + buf + "]");
        }
        return buf.array();
    }
}

