/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record;

import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.pagemem.wal.record.UnwrappedDataEntry;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;

public class UnwrapDataEntry
extends DataEntry
implements UnwrappedDataEntry {
    private final CacheObjectValueContext cacheObjValCtx;
    private boolean keepBinary;

    public UnwrapDataEntry(int cacheId, KeyCacheObject key, CacheObject val, GridCacheOperation op, GridCacheVersion nearXidVer, GridCacheVersion writeVer, long expireTime, int partId, long partCnt, CacheObjectValueContext cacheObjValCtx, boolean keepBinary, byte flags) {
        super(cacheId, key, val, op, nearXidVer, writeVer, expireTime, partId, partCnt, flags);
        this.cacheObjValCtx = cacheObjValCtx;
        this.keepBinary = keepBinary;
    }

    @Override
    public Object unwrappedKey() {
        try {
            if (this.keepBinary && this.key instanceof BinaryObject) {
                return this.key;
            }
            Object unwrapped = this.key.value(this.cacheObjValCtx, false);
            if (unwrapped instanceof BinaryObject) {
                if (this.keepBinary) {
                    return unwrapped;
                }
                unwrapped = ((BinaryObject)unwrapped).deserialize();
            }
            return unwrapped;
        }
        catch (Exception e) {
            this.cacheObjValCtx.kernalContext().log(UnwrapDataEntry.class).error("Unable to convert key [" + this.key + "]", e);
            return null;
        }
    }

    @Override
    public Object unwrappedValue() {
        try {
            if (this.val == null) {
                return null;
            }
            if (this.keepBinary && this.val instanceof BinaryObject) {
                return this.val;
            }
            return this.val.value(this.cacheObjValCtx, false);
        }
        catch (Exception e) {
            this.cacheObjValCtx.kernalContext().log(UnwrapDataEntry.class).error("Unable to convert value [" + this.value() + "]", e);
            return null;
        }
    }

    @Override
    public String toString() {
        SB sb = new SB();
        sb.a(this.getClass().getSimpleName()).a('[');
        if (S.includeSensitive()) {
            sb.a("k = ").a(this.unwrappedKey()).a(", v = [ ").a(this.unwrappedValue()).a("], ");
        }
        return sb.a("super = [").a(super.toString()).a("]]").toString();
    }
}

