/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.direct;

import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.direct.state.DirectMessageState;
import org.apache.ignite.internal.direct.state.DirectMessageStateItem;
import org.apache.ignite.internal.direct.stream.DirectByteBufferStream;
import org.apache.ignite.internal.direct.stream.v1.DirectByteBufferStreamImplV1;
import org.apache.ignite.internal.direct.stream.v2.DirectByteBufferStreamImplV2;
import org.apache.ignite.internal.direct.stream.v3.DirectByteBufferStreamImplV3;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteOutClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class DirectMessageWriter
implements MessageWriter {
    @GridToStringInclude
    private final DirectMessageState<StateItem> state;
    @GridToStringInclude
    private final byte protoVer;

    public DirectMessageWriter(final byte protoVer) {
        this.state = new DirectMessageState<StateItem>(StateItem.class, new IgniteOutClosure<StateItem>(){

            @Override
            public StateItem apply() {
                return new StateItem(protoVer);
            }
        });
        this.protoVer = protoVer;
    }

    @Override
    public void setBuffer(ByteBuffer buf) {
        this.state.item().stream.setBuffer(buf);
    }

    @Override
    public void setCurrentWriteClass(Class<? extends Message> msgCls) {
    }

    @Override
    public boolean writeHeader(short type, byte fieldCnt) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeShort(type);
        return stream.lastFinished();
    }

    @Override
    public boolean writeByte(String name, byte val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeByte(val);
        return stream.lastFinished();
    }

    @Override
    public boolean writeShort(String name, short val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeShort(val);
        return stream.lastFinished();
    }

    @Override
    public boolean writeInt(String name, int val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeInt(val);
        return stream.lastFinished();
    }

    @Override
    public boolean writeLong(String name, long val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeLong(val);
        return stream.lastFinished();
    }

    @Override
    public boolean writeFloat(String name, float val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeFloat(val);
        return stream.lastFinished();
    }

    @Override
    public boolean writeDouble(String name, double val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeDouble(val);
        return stream.lastFinished();
    }

    @Override
    public boolean writeChar(String name, char val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeChar(val);
        return stream.lastFinished();
    }

    @Override
    public boolean writeBoolean(String name, boolean val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeBoolean(val);
        return stream.lastFinished();
    }

    @Override
    public boolean writeByteArray(String name, @Nullable byte[] val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeByteArray(val);
        return stream.lastFinished();
    }

    @Override
    public boolean writeByteArray(String name, byte[] val, long off, int len) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeByteArray(val, off, len);
        return stream.lastFinished();
    }

    @Override
    public boolean writeShortArray(String name, @Nullable short[] val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeShortArray(val);
        return stream.lastFinished();
    }

    @Override
    public boolean writeIntArray(String name, @Nullable int[] val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeIntArray(val);
        return stream.lastFinished();
    }

    @Override
    public boolean writeLongArray(String name, @Nullable long[] val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeLongArray(val);
        return stream.lastFinished();
    }

    @Override
    public boolean writeLongArray(String name, long[] val, int len) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeLongArray(val, len);
        return stream.lastFinished();
    }

    @Override
    public boolean writeFloatArray(String name, @Nullable float[] val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeFloatArray(val);
        return stream.lastFinished();
    }

    @Override
    public boolean writeDoubleArray(String name, @Nullable double[] val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeDoubleArray(val);
        return stream.lastFinished();
    }

    @Override
    public boolean writeCharArray(String name, @Nullable char[] val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeCharArray(val);
        return stream.lastFinished();
    }

    @Override
    public boolean writeBooleanArray(String name, @Nullable boolean[] val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeBooleanArray(val);
        return stream.lastFinished();
    }

    @Override
    public boolean writeString(String name, String val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeString(val);
        return stream.lastFinished();
    }

    @Override
    public boolean writeBitSet(String name, BitSet val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeBitSet(val);
        return stream.lastFinished();
    }

    @Override
    public boolean writeUuid(String name, UUID val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeUuid(val);
        return stream.lastFinished();
    }

    @Override
    public boolean writeIgniteUuid(String name, IgniteUuid val) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeIgniteUuid(val);
        return stream.lastFinished();
    }

    @Override
    public boolean writeAffinityTopologyVersion(String name, AffinityTopologyVersion val) {
        if (this.protoVer >= 3) {
            DirectByteBufferStream stream = this.state.item().stream;
            stream.writeAffinityTopologyVersion(val);
            return stream.lastFinished();
        }
        return this.writeMessage(name, val);
    }

    @Override
    public boolean writeMessage(String name, @Nullable Message msg) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeMessage(msg, this);
        return stream.lastFinished();
    }

    @Override
    public <T> boolean writeObjectArray(String name, T[] arr, MessageCollectionItemType itemType) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeObjectArray(arr, itemType, this);
        return stream.lastFinished();
    }

    @Override
    public <T> boolean writeCollection(String name, Collection<T> col, MessageCollectionItemType itemType) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeCollection(col, itemType, this);
        return stream.lastFinished();
    }

    @Override
    public <K, V> boolean writeMap(String name, Map<K, V> map, MessageCollectionItemType keyType, MessageCollectionItemType valType) {
        DirectByteBufferStream stream = this.state.item().stream;
        stream.writeMap(map, keyType, valType, this);
        return stream.lastFinished();
    }

    @Override
    public boolean isHeaderWritten() {
        return this.state.item().hdrWritten;
    }

    @Override
    public void onHeaderWritten() {
        this.state.item().hdrWritten = true;
    }

    @Override
    public int state() {
        return this.state.item().state;
    }

    @Override
    public void incrementState() {
        this.state.item().state++;
    }

    @Override
    public void beforeInnerMessageWrite() {
        this.state.forward();
    }

    @Override
    public void afterInnerMessageWrite(boolean finished) {
        this.state.backward(finished);
    }

    @Override
    public void reset() {
        this.state.reset();
    }

    public String toString() {
        return S.toString(DirectMessageWriter.class, this);
    }

    private static class StateItem
    implements DirectMessageStateItem {
        private final DirectByteBufferStream stream;
        private int state;
        private boolean hdrWritten;

        public StateItem(byte protoVer) {
            switch (protoVer) {
                case 1: {
                    this.stream = new DirectByteBufferStreamImplV1(null);
                    break;
                }
                case 2: {
                    this.stream = new DirectByteBufferStreamImplV2(null);
                    break;
                }
                case 3: {
                    this.stream = new DirectByteBufferStreamImplV3(null);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid protocol version: " + protoVer);
                }
            }
        }

        @Override
        public void reset() {
            this.state = 0;
            this.hdrWritten = false;
        }

        public String toString() {
            return S.toString(StateItem.class, this);
        }
    }
}

