/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.property.tasks;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.commandline.meta.subcommands.VoidDto;
import org.apache.ignite.internal.commandline.property.tasks.PropertiesListResult;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.plugin.security.SecurityPermissionSet;
import org.apache.ignite.plugin.security.SecurityPermissionSetBuilder;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class PropertiesListTask
extends VisorMultiNodeTask<VoidDto, PropertiesListResult, PropertiesListResult> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<VoidDto, PropertiesListResult> job(VoidDto arg) {
        return new PropertiesListJob(this.debug);
    }

    @Override
    @Nullable
    protected PropertiesListResult reduce0(List<ComputeJobResult> results) {
        if (results.isEmpty()) {
            throw new IgniteException("Empty job results");
        }
        if (results.size() > 1) {
            throw new IgniteException("Invalid job results: " + results);
        }
        if (results.get(0).getException() != null) {
            throw results.get(0).getException();
        }
        return (PropertiesListResult)results.get(0).getData();
    }

    private static class PropertiesListJob
    extends VisorJob<VoidDto, PropertiesListResult> {
        private static final long serialVersionUID = 0L;

        protected PropertiesListJob(boolean debug) {
            super(null, debug);
        }

        @Override
        public SecurityPermissionSet requiredPermissions() {
            return SecurityPermissionSetBuilder.systemPermissions(SecurityPermission.ADMIN_READ_DISTRIBUTED_PROPERTY);
        }

        @Override
        protected PropertiesListResult run(@Nullable VoidDto arg) {
            return new PropertiesListResult(this.ignite.context().distributedConfiguration().properties().stream().map(pd -> pd.getName()).collect(Collectors.toList()));
        }
    }
}

