/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.meta.tasks;

import java.util.List;
import java.util.Objects;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobContext;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.GridClosureCallMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.commandline.meta.tasks.MetadataMarshalled;
import org.apache.ignite.internal.commandline.meta.tasks.MetadataTypeArgs;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.task.TaskExecutionOptions;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.plugin.security.SecurityPermissionSet;
import org.apache.ignite.plugin.security.SecurityPermissionSetBuilder;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.JobContextResource;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class MetadataRemoveTask
extends VisorMultiNodeTask<MetadataTypeArgs, MetadataMarshalled, MetadataMarshalled> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<MetadataTypeArgs, MetadataMarshalled> job(MetadataTypeArgs arg) {
        return new MetadataRemoveJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected MetadataMarshalled reduce0(List<ComputeJobResult> results) {
        if (results.size() != 1) {
            throw new IgniteException("Invalid job results. Expected exactly 1 result, but was: " + results);
        }
        if (results.get(0).getException() != null) {
            throw results.get(0).getException();
        }
        return (MetadataMarshalled)results.get(0).getData();
    }

    @GridInternal
    private static class DropAllThinSessionsJob
    implements IgniteRunnable {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        private IgniteEx ignite;

        private DropAllThinSessionsJob() {
        }

        @Override
        public void run() throws IgniteException {
            this.ignite.context().clientListener().closeAllSessions();
        }
    }

    private static class MetadataRemoveJob
    extends VisorJob<MetadataTypeArgs, MetadataMarshalled> {
        private static final long serialVersionUID = 0L;
        @JobContextResource
        private transient ComputeJobContext jobCtx;
        private transient IgniteInternalFuture<?> future;
        private transient MetadataMarshalled res;

        protected MetadataRemoveJob(@Nullable MetadataTypeArgs arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        public SecurityPermissionSet requiredPermissions() {
            return SecurityPermissionSetBuilder.systemPermissions(SecurityPermission.ADMIN_METADATA_OPS);
        }

        @Override
        protected MetadataMarshalled run(@Nullable MetadataTypeArgs arg) throws IgniteException {
            try {
                if (this.future == null) {
                    assert (Objects.nonNull(arg));
                    int typeId = arg.typeId(this.ignite.context());
                    BinaryMetadata meta = ((CacheObjectBinaryProcessorImpl)this.ignite.context().cacheObjects()).binaryMetadata(typeId);
                    if (meta == null) {
                        return new MetadataMarshalled(null, null);
                    }
                    byte[] marshalled = U.marshal(this.ignite.context(), (Object)meta);
                    this.res = new MetadataMarshalled(marshalled, meta);
                    this.ignite.context().cacheObjects().removeType(typeId);
                    this.future = this.ignite.context().closure().runAsync(GridClosureCallMode.BROADCAST, new DropAllThinSessionsJob(), TaskExecutionOptions.options(this.ignite.cluster().forServers().nodes()));
                    this.jobCtx.holdcc();
                    this.future.listen(f -> {
                        if (f.isDone()) {
                            this.jobCtx.callcc();
                        }
                    });
                    return null;
                }
                return this.res;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }
    }
}

