/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin.io.gridnioserver;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.SSLContext;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.client.ClientConnectionException;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.internal.client.thin.ClientSslUtils;
import org.apache.ignite.internal.client.thin.io.ClientConnection;
import org.apache.ignite.internal.client.thin.io.ClientConnectionMultiplexer;
import org.apache.ignite.internal.client.thin.io.ClientConnectionStateHandler;
import org.apache.ignite.internal.client.thin.io.ClientMessageHandler;
import org.apache.ignite.internal.client.thin.io.gridnioserver.GridNioClientConnection;
import org.apache.ignite.internal.client.thin.io.gridnioserver.GridNioClientListener;
import org.apache.ignite.internal.client.thin.io.gridnioserver.GridNioClientParser;
import org.apache.ignite.internal.util.nio.GridNioCodecFilter;
import org.apache.ignite.internal.util.nio.GridNioFilter;
import org.apache.ignite.internal.util.nio.GridNioFuture;
import org.apache.ignite.internal.util.nio.GridNioFutureImpl;
import org.apache.ignite.internal.util.nio.GridNioServer;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.nio.ssl.GridNioSslFilter;
import org.apache.ignite.logger.NullLogger;

public class GridNioClientConnectionMultiplexer
implements ClientConnectionMultiplexer {
    private static final String THREAD_PREFIX = "thin-client-channel";
    private static final int CLIENT_MODE_PORT = -1;
    private final GridNioServer<ByteBuffer> srv;
    private final SSLContext sslCtx;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();

    public GridNioClientConnectionMultiplexer(ClientConfiguration cfg) {
        GridNioFilter[] filters;
        NullLogger gridLog = new NullLogger();
        GridNioCodecFilter codecFilter = new GridNioCodecFilter(new GridNioClientParser(), gridLog, false);
        this.sslCtx = ClientSslUtils.getSslContext(cfg);
        if (this.sslCtx != null) {
            GridNioSslFilter sslFilter = new GridNioSslFilter(this.sslCtx, true, ByteOrder.nativeOrder(), gridLog, null);
            sslFilter.directMode(false);
            filters = new GridNioFilter[]{codecFilter, sslFilter};
        } else {
            filters = new GridNioFilter[]{codecFilter};
        }
        try {
            this.srv = GridNioServer.builder().port(-1).listener(new GridNioClientListener()).filters(filters).logger(gridLog).selectorCount(1).byteOrder(ByteOrder.nativeOrder()).directBuffer(true).directMode(false).igniteInstanceName("thinClient").serverName(THREAD_PREFIX).idleTimeout(Long.MAX_VALUE).socketReceiveBufferSize(cfg.getReceiveBufferSize()).socketSendBufferSize(cfg.getSendBufferSize()).tcpNoDelay(true).build();
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    public void start() {
        this.rwLock.writeLock().lock();
        try {
            this.srv.start();
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public synchronized void stop() {
        this.rwLock.writeLock().lock();
        try {
            this.srv.stop();
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public ClientConnection open(InetSocketAddress addr, ClientMessageHandler msgHnd, ClientConnectionStateHandler stateHnd) throws ClientConnectionException {
        this.rwLock.readLock().lock();
        try {
            GridNioFuture<GridNioSession> sesFut;
            SocketChannel ch = SocketChannel.open();
            ch.socket().connect(new InetSocketAddress(addr.getHostName(), addr.getPort()), Integer.MAX_VALUE);
            HashMap<Integer, Object> meta = new HashMap<Integer, Object>();
            GridNioFutureImpl sslHandshakeFut = null;
            if (this.sslCtx != null) {
                sslHandshakeFut = new GridNioFutureImpl(null);
                meta.put(GridNioSslFilter.HANDSHAKE_FUT_META_KEY, sslHandshakeFut);
            }
            if ((sesFut = this.srv.createSession(ch, meta, false, null)).error() != null) {
                sesFut.get();
            }
            if (sslHandshakeFut != null) {
                sslHandshakeFut.get();
            }
            GridNioSession ses = (GridNioSession)sesFut.get();
            GridNioClientConnection gridNioClientConnection = new GridNioClientConnection(ses, msgHnd, stateHnd);
            return gridNioClientConnection;
        }
        catch (Exception e) {
            throw new ClientConnectionException(e.getMessage(), e);
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }
}

