/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.util;

import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.SourceStringReader;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryContext;
import org.apache.ignite.internal.processors.query.calcite.exec.RowHandler;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.ExpressionFactoryImpl;
import org.apache.ignite.internal.processors.query.calcite.prepare.BaseQueryContext;
import org.apache.ignite.internal.processors.query.calcite.prepare.MappingQueryContext;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.codehaus.commons.compiler.CompilerFactoryFactory;
import org.codehaus.commons.compiler.IClassBodyEvaluator;
import org.codehaus.commons.compiler.ICompilerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Commons {
    private Commons() {
    }

    public static Context convert(QueryContext ctx) {
        return ctx == null ? Contexts.empty() : Contexts.of((Object[])((Object[])ctx.unwrap(Object[].class)));
    }

    public static <Row> Object getFieldFromBiRows(RowHandler<Row> hnd, int offset, Row row1, Row row2) {
        return offset < hnd.columnCount(row1) ? hnd.get(offset, row1) : hnd.get(offset - hnd.columnCount(row1), row2);
    }

    public static <T> List<T> combine(List<T> left, List<T> right) {
        HashSet<T> set = new HashSet<T>(left.size() + right.size());
        set.addAll(left);
        set.addAll(right);
        return new ArrayList(set);
    }

    public static <T> List<T> intersect(List<T> left, List<T> right) {
        if (F.isEmpty(left) || F.isEmpty(right)) {
            return Collections.emptyList();
        }
        return left.size() > right.size() ? Commons.intersect(new HashSet<T>(right), left) : Commons.intersect(new HashSet<T>(left), right);
    }

    public static <T> List<T> intersect(Set<T> set, List<T> list) {
        if (F.isEmpty(set) || F.isEmpty(list)) {
            return Collections.emptyList();
        }
        return list.stream().filter(set::contains).collect(Collectors.toList());
    }

    public static <T> List<T> cast(List<?> src) {
        return src;
    }

    public static <T, R> List<R> transform(@NotNull List<T> src, @NotNull Function<T, R> mapFun) {
        if (F.isEmpty(src)) {
            return Collections.emptyList();
        }
        ArrayList<R> list = new ArrayList<R>(src.size());
        for (T t : src) {
            list.add(mapFun.apply(t));
        }
        return list;
    }

    public static IgniteTypeFactory typeFactory(RelNode rel) {
        return Commons.typeFactory(rel.getCluster());
    }

    public static IgniteTypeFactory typeFactory(RelOptCluster cluster) {
        return (IgniteTypeFactory)cluster.getTypeFactory();
    }

    public static BaseQueryContext context(RelNode rel) {
        return Commons.context(rel.getCluster());
    }

    public static BaseQueryContext context(RelOptCluster cluster) {
        return (BaseQueryContext)Objects.requireNonNull(cluster.getPlanner().getContext().unwrap(BaseQueryContext.class));
    }

    public static SqlNodeList parse(String qry, SqlParser.Config parserCfg) {
        try {
            return Commons.parse((Reader)new SourceStringReader(qry), parserCfg);
        }
        catch (SqlParseException e) {
            throw new IgniteSQLException("Failed to parse query. " + e.getMessage(), 1001, (Throwable)e);
        }
    }

    public static SqlNodeList parse(Reader reader, SqlParser.Config parserCfg) throws SqlParseException {
        SqlParser parser = SqlParser.create((Reader)reader, (SqlParser.Config)parserCfg);
        return parser.parseStmtList();
    }

    public static Map<String, Object> parametersMap(@Nullable Object[] params) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        return params != null ? Commons.populateParameters(res, params) : res;
    }

    public static Map<String, Object> populateParameters(@NotNull Map<String, Object> dst, @Nullable Object[] params) {
        if (!F.isEmpty((Object[])params)) {
            for (int i = 0; i < params.length; ++i) {
                dst.put("?" + i, params[i]);
            }
        }
        return dst;
    }

    public static <T extends GridComponent> T lookupComponent(GridKernalContext ctx, Class<T> componentType) {
        return (T)((GridComponent)ctx.components().stream().filter(componentType::isInstance).map(componentType::cast).findFirst().orElse(null));
    }

    public static void close(Object o) throws Exception {
        if (o instanceof AutoCloseable) {
            ((AutoCloseable)o).close();
        }
    }

    public static void close(Object o, IgniteLogger log) {
        if (o instanceof AutoCloseable) {
            U.close((AutoCloseable)((AutoCloseable)o), (IgniteLogger)log);
        }
    }

    public static void closeQuiet(Object o) {
        if (o instanceof AutoCloseable) {
            U.closeQuiet((AutoCloseable)((AutoCloseable)o));
        }
    }

    public static <T> List<T> flat(List<List<? extends T>> src) {
        return src.stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static int max(ImmutableIntList list) {
        if (list.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        int res = list.getInt(0);
        for (int i = 1; i < list.size(); ++i) {
            res = Math.max(res, list.getInt(i));
        }
        return res;
    }

    public static int min(ImmutableIntList list) {
        if (list.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        int res = list.getInt(0);
        for (int i = 1; i < list.size(); ++i) {
            res = Math.min(res, list.getInt(i));
        }
        return res;
    }

    public static <T> T compile(Class<T> interfaceType, String body) {
        boolean debug = (Boolean)CalciteSystemProperty.DEBUG.value();
        if (debug) {
            Util.debugCode((PrintStream)System.out, (String)body);
        }
        try {
            ICompilerFactory compilerFactory;
            try {
                compilerFactory = CompilerFactoryFactory.getDefaultCompilerFactory();
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to instantiate java compiler", e);
            }
            IClassBodyEvaluator cbe = compilerFactory.newClassBodyEvaluator();
            cbe.setImplementedInterfaces(new Class[]{interfaceType});
            cbe.setParentClassLoader(ExpressionFactoryImpl.class.getClassLoader());
            if (debug) {
                cbe.setDebuggingInformation(true, true, true);
            }
            return (T)cbe.createInstance((Reader)new StringReader(body));
        }
        catch (Exception e) {
            throw new IgniteException((Throwable)e);
        }
    }

    public static void checkRange(@NotNull Object[] array, int idx) {
        if (idx < 0 || idx >= array.length) {
            throw new ArrayIndexOutOfBoundsException(idx);
        }
    }

    public static <T> T[] ensureCapacity(T[] array, int required) {
        A.ensure((required >= 0 ? 1 : 0) != 0, (String)"capacity must not be negative");
        return array.length <= required ? Arrays.copyOf(array, U.nextPowerOf2((int)required)) : array;
    }

    public static <T> Predicate<T> negate(Predicate<T> p) {
        return p.negate();
    }

    public static Mappings.TargetMapping mapping(ImmutableBitSet bitSet, int sourceSize) {
        Mapping mapping = Mappings.create((MappingType)MappingType.PARTIAL_FUNCTION, (int)sourceSize, (int)bitSet.cardinality());
        for (Ord ord : Ord.zip((Iterable)bitSet)) {
            mapping.set(((Integer)ord.e).intValue(), ord.i);
        }
        return mapping;
    }

    public static Mappings.TargetMapping inverseMapping(ImmutableBitSet bitSet, int sourceSize) {
        Mapping mapping = Mappings.create((MappingType)MappingType.INVERSE_FUNCTION, (int)sourceSize, (int)bitSet.cardinality());
        for (Ord ord : Ord.zip((Iterable)bitSet)) {
            mapping.set(((Integer)ord.e).intValue(), ord.i);
        }
        return mapping;
    }

    public static <T> boolean isPrefix(List<T> seq, Collection<T> elems) {
        HashSet<T> elems0 = new HashSet<T>(elems);
        if (seq.size() < elems0.size()) {
            return false;
        }
        for (T e : seq) {
            if (!elems0.remove(e)) {
                return false;
            }
            if (!elems0.isEmpty()) continue;
            break;
        }
        return true;
    }

    public static <T> List<T> maxPrefix(List<T> seq, Collection<T> elems) {
        ArrayList<T> res = new ArrayList<T>();
        HashSet<T> elems0 = new HashSet<T>(elems);
        for (T e : seq) {
            if (!elems0.remove(e)) break;
            res.add(e);
        }
        return res;
    }

    public static RelOptCluster emptyCluster() {
        return BaseQueryContext.CLUSTER;
    }

    public static IgniteTypeFactory typeFactory() {
        return BaseQueryContext.TYPE_FACTORY;
    }

    public static MappingQueryContext mapContext(UUID locNodeId, AffinityTopologyVersion topVer) {
        return new MappingQueryContext(locNodeId, topVer);
    }
}

