/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rel;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.ignite.internal.processors.query.calcite.metadata.cost.IgniteCostFactory;
import org.apache.ignite.internal.processors.query.calcite.rel.AbstractIgniteJoin;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteConvention;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRel;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRelVisitor;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;

public class IgniteNestedLoopJoin
extends AbstractIgniteJoin {
    public IgniteNestedLoopJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType) {
        super(cluster, traitSet, left, right, condition, variablesSet, joinType);
    }

    public IgniteNestedLoopJoin(RelInput input) {
        this(input.getCluster(), input.getTraitSet().replace((RelTrait)IgniteConvention.INSTANCE), (RelNode)input.getInputs().get(0), (RelNode)input.getInputs().get(1), input.getExpression("condition"), (Set<CorrelationId>)ImmutableSet.copyOf(Commons.transform(input.getIntegerList("variablesSet"), CorrelationId::new)), (JoinRelType)input.getEnum("joinType", JoinRelType.class));
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        IgniteCostFactory costFactory = (IgniteCostFactory)planner.getCostFactory();
        double leftCount = mq.getRowCount(this.getLeft());
        if (Double.isInfinite(leftCount)) {
            return costFactory.makeInfiniteCost();
        }
        double rightCount = mq.getRowCount(this.getRight());
        if (Double.isInfinite(rightCount)) {
            return costFactory.makeInfiniteCost();
        }
        double rows = leftCount * rightCount;
        double rightSize = rightCount * (double)this.getRight().getRowType().getFieldCount() * 4.0;
        return costFactory.makeCost(rows, rows * 4.0, 0.0, rightSize, 0.0);
    }

    public Join copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new IgniteNestedLoopJoin(this.getCluster(), traitSet, left, right, condition, (Set<CorrelationId>)this.variablesSet, joinType);
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteNestedLoopJoin(cluster, this.getTraitSet(), (RelNode)inputs.get(0), (RelNode)inputs.get(1), this.getCondition(), this.getVariablesSet(), this.getJoinType());
    }
}

