/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.message;

import java.util.function.Supplier;
import org.apache.ignite.internal.processors.query.calcite.message.CalciteMessage;
import org.apache.ignite.internal.processors.query.calcite.message.ErrorMessage;
import org.apache.ignite.internal.processors.query.calcite.message.GenericValueMessage;
import org.apache.ignite.internal.processors.query.calcite.message.InboxCloseMessage;
import org.apache.ignite.internal.processors.query.calcite.message.QueryBatchAcknowledgeMessage;
import org.apache.ignite.internal.processors.query.calcite.message.QueryBatchMessage;
import org.apache.ignite.internal.processors.query.calcite.message.QueryCloseMessage;
import org.apache.ignite.internal.processors.query.calcite.message.QueryStartRequest;
import org.apache.ignite.internal.processors.query.calcite.message.QueryStartResponse;
import org.apache.ignite.internal.processors.query.calcite.metadata.ColocationGroup;
import org.apache.ignite.internal.processors.query.calcite.metadata.FragmentDescription;
import org.apache.ignite.internal.processors.query.calcite.metadata.FragmentMapping;

public enum MessageType {
    QUERY_START_REQUEST(300, QueryStartRequest::new),
    QUERY_START_RESPONSE(301, QueryStartResponse::new),
    QUERY_ERROR_MESSAGE(302, ErrorMessage::new),
    QUERY_BATCH_MESSAGE(303, QueryBatchMessage::new),
    QUERY_ACKNOWLEDGE_MESSAGE(304, QueryBatchAcknowledgeMessage::new),
    QUERY_INBOX_CANCEL_MESSAGE(305, InboxCloseMessage::new),
    QUERY_CLOSE_MESSAGE(306, QueryCloseMessage::new),
    GENERIC_VALUE_MESSAGE(307, GenericValueMessage::new),
    FRAGMENT_MAPPING(350, FragmentMapping::new),
    COLOCATION_GROUP(351, ColocationGroup::new),
    FRAGMENT_DESCRIPTION(352, FragmentDescription::new);

    private final int directType;
    private final Supplier<CalciteMessage> factory;

    private MessageType(int directType, Supplier<CalciteMessage> factory) {
        this.directType = directType;
        this.factory = factory;
    }

    public short directType() {
        return (short)this.directType;
    }

    public Supplier<CalciteMessage> factory() {
        return this.factory;
    }
}

