/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.rel;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.RowHandler;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.agg.AggregateType;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.agg.GroupKey;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.AbstractSetOpNode;

public class MinusNode<Row>
extends AbstractSetOpNode<Row> {
    public MinusNode(ExecutionContext<Row> ctx, RelDataType rowType, AggregateType type, boolean all, RowHandler.RowFactory<Row> rowFactory) {
        super(ctx, rowType, type, all, rowFactory, new MinusGrouping(ctx, rowFactory, type, all));
    }

    private static class MinusGrouping<Row>
    extends AbstractSetOpNode.Grouping<Row> {
        private MinusGrouping(ExecutionContext<Row> ctx, RowHandler.RowFactory<Row> rowFactory, AggregateType type, boolean all) {
            super(ctx, rowFactory, type, all);
        }

        @Override
        protected void addOnSingle(Row row, int setIdx) {
            GroupKey key = this.key(row);
            if (setIdx == 0) {
                int[] cntrs = this.groups.computeIfAbsent(key, k -> new int[2]);
                cntrs[0] = cntrs[0] + 1;
            } else if (this.all) {
                int[] cntrs = (int[])this.groups.get(key);
                if (cntrs != null) {
                    cntrs[1] = cntrs[1] + 1;
                    if (cntrs[1] >= cntrs[0]) {
                        this.groups.remove(key);
                    }
                }
            } else {
                this.groups.remove(key);
            }
        }

        @Override
        protected void addOnMapper(Row row, int setIdx) {
            int[] cntrs = this.groups.computeIfAbsent(this.key(row), k -> new int[2]);
            int n = setIdx == 0 ? 0 : 1;
            cntrs[n] = cntrs[n] + 1;
        }

        @Override
        protected boolean affectResult(int[] cntrs) {
            return cntrs[0] != cntrs[1];
        }

        @Override
        protected int availableRows(int[] cntrs) {
            assert (cntrs.length == 2);
            if (this.all) {
                return Math.max(cntrs[0] - cntrs[1], 0);
            }
            return cntrs[1] == 0 ? 1 : 0;
        }

        @Override
        protected void decrementAvailableRows(int[] cntrs, int amount) {
            assert (amount > 0);
            assert (this.all);
            cntrs[0] = cntrs[0] - amount;
        }

        @Override
        protected int countersSize() {
            return 2;
        }
    }
}

