/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.rel;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.RowHandler;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Downstream;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.MemoryTrackingNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.SingleNode;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.util.typedef.F;

public class CollectNode<Row>
extends MemoryTrackingNode<Row>
implements SingleNode<Row>,
Downstream<Row> {
    private final Collector<Row> collector;
    private int requested;
    private int waiting;

    public CollectNode(ExecutionContext<Row> ctx, RelDataType rowType) {
        this(ctx, rowType, CollectNode.createCollector(ctx, rowType));
    }

    private CollectNode(ExecutionContext<Row> ctx, RelDataType rowType, Collector<Row> collector) {
        super(ctx, rowType);
        this.collector = collector;
    }

    public static <Row> CollectNode<Row> createCountCollector(ExecutionContext<Row> ctx) {
        RelDataType rowType = ctx.getTypeFactory().createSqlType(SqlTypeName.BIGINT);
        Counter collector = new Counter(ctx.rowHandler(), ctx.rowHandler().factory(ctx.getTypeFactory(), rowType), 1);
        return new CollectNode<Row>(ctx, rowType, collector);
    }

    @Override
    protected void rewindInternal() {
        this.requested = 0;
        this.waiting = 0;
        this.collector.clear();
        this.nodeMemoryTracker.reset();
    }

    @Override
    protected Downstream<Row> requestDownstream(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (!F.isEmpty(this.sources()) && this.sources().size() == 1);
        assert (rowsCnt > 0 && this.requested == 0);
        this.checkState();
        this.requested = rowsCnt;
        if (this.waiting == 0) {
            this.waiting = IN_BUFFER_SIZE;
            this.source().request(this.waiting);
        }
    }

    @Override
    public void push(Row row) throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        this.checkState();
        --this.waiting;
        this.collector.push(row);
        if (this.collector.keepRows()) {
            this.nodeMemoryTracker.onRowAdded(row);
        }
        if (this.waiting == 0) {
            this.waiting = IN_BUFFER_SIZE;
            this.source().request(this.waiting);
        }
    }

    @Override
    public void end() throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        this.checkState();
        this.waiting = -1;
        if (this.isClosed()) {
            return;
        }
        if (this.requested > 0) {
            this.requested = 0;
            this.downstream().push(this.collector.get());
            this.downstream().end();
        }
    }

    private static <Row> Collector<Row> createCollector(ExecutionContext<Row> ctx, RelDataType rowType) {
        IgniteTypeFactory typeFactory = ctx.getTypeFactory();
        RelDataType collectionType = ((RelDataTypeField)Iterables.getOnlyElement((Iterable)rowType.getFieldList())).getType();
        RowHandler.RowFactory<Row> rowFactory = ctx.rowHandler().factory(typeFactory, rowType);
        switch (collectionType.getSqlTypeName()) {
            case ARRAY: {
                return new ArrayCollector(ctx.rowHandler(), rowFactory, IN_BUFFER_SIZE);
            }
            case MAP: {
                return new MapCollector(ctx.rowHandler(), rowFactory, IN_BUFFER_SIZE);
            }
        }
        throw new RuntimeException("Unsupported collectionType: " + collectionType.getSqlTypeName());
    }

    private static class Counter<Row>
    extends Collector<Row> {
        private long cnt;

        private Counter(RowHandler<Row> hnd, RowHandler.RowFactory<Row> rowFactory, int cap) {
            super(hnd, rowFactory, cap);
        }

        @Override
        protected Object outData() {
            return this.cnt;
        }

        @Override
        public void push(Row row) {
            ++this.cnt;
        }

        @Override
        public void clear() {
            this.cnt = 0L;
        }
    }

    private static class ArrayCollector<Row>
    extends Collector<Row> {
        private List<Object> outBuf;

        private ArrayCollector(RowHandler<Row> handler, RowHandler.RowFactory<Row> rowFactory, int cap) {
            super(handler, rowFactory, cap);
            this.outBuf = new ArrayList<Object>(cap);
        }

        @Override
        protected Object outData() {
            return Collections.unmodifiableList(this.outBuf);
        }

        @Override
        public void push(Row row) {
            if (this.rowHandler.columnCount(row) > 1) {
                this.outBuf.add(row);
            } else {
                this.outBuf.add(this.rowHandler.get(0, row));
            }
        }

        @Override
        public void clear() {
            this.outBuf = new ArrayList<Object>(this.cap);
        }

        @Override
        public boolean keepRows() {
            return true;
        }
    }

    private static class MapCollector<Row>
    extends Collector<Row> {
        private Map<Object, Object> outBuf;

        private MapCollector(RowHandler<Row> handler, RowHandler.RowFactory<Row> rowFactory, int cap) {
            super(handler, rowFactory, cap);
            this.outBuf = new LinkedHashMap<Object, Object>(cap);
        }

        @Override
        protected Object outData() {
            return Collections.unmodifiableMap(this.outBuf);
        }

        @Override
        public void push(Row row) {
            this.outBuf.put(this.rowHandler.get(0, row), this.rowHandler.get(1, row));
        }

        @Override
        public void clear() {
            this.outBuf = new LinkedHashMap<Object, Object>(this.cap);
        }

        @Override
        public boolean keepRows() {
            return true;
        }
    }

    private static abstract class Collector<Row>
    implements Supplier<Row> {
        protected final RowHandler<Row> rowHandler;
        protected final RowHandler.RowFactory<Row> rowFactory;
        protected final int cap;

        Collector(RowHandler<Row> handler, RowHandler.RowFactory<Row> factory, int cap) {
            this.rowHandler = handler;
            this.rowFactory = factory;
            this.cap = cap;
        }

        public abstract void push(Row var1);

        public abstract void clear();

        protected abstract Object outData();

        @Override
        public Row get() {
            Row out = this.rowFactory.create();
            this.rowHandler.set(0, out, this.outData());
            return out;
        }

        public boolean keepRows() {
            return false;
        }
    }
}

