/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.RunningQuery;
import org.apache.ignite.internal.processors.query.calcite.CalciteQueryProcessor;
import org.apache.ignite.internal.processors.query.calcite.Query;
import org.apache.ignite.internal.processors.query.calcite.QueryRegistry;
import org.apache.ignite.internal.processors.query.calcite.exec.ExchangeService;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.MailboxRegistry;
import org.apache.ignite.internal.processors.query.calcite.exec.QueryTaskExecutor;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Inbox;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Outbox;
import org.apache.ignite.internal.processors.query.calcite.exec.tracker.NoOpMemoryTracker;
import org.apache.ignite.internal.processors.query.calcite.message.ErrorMessage;
import org.apache.ignite.internal.processors.query.calcite.message.InboxCloseMessage;
import org.apache.ignite.internal.processors.query.calcite.message.MessageService;
import org.apache.ignite.internal.processors.query.calcite.message.MessageType;
import org.apache.ignite.internal.processors.query.calcite.message.QueryBatchAcknowledgeMessage;
import org.apache.ignite.internal.processors.query.calcite.message.QueryBatchMessage;
import org.apache.ignite.internal.processors.query.calcite.message.QueryCloseMessage;
import org.apache.ignite.internal.processors.query.calcite.metadata.FragmentDescription;
import org.apache.ignite.internal.processors.query.calcite.prepare.BaseQueryContext;
import org.apache.ignite.internal.processors.query.calcite.util.AbstractService;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.util.typedef.F;

public class ExchangeServiceImpl
extends AbstractService
implements ExchangeService {
    private final UUID locaNodeId;
    private QueryTaskExecutor taskExecutor;
    private MailboxRegistry mailboxRegistry;
    private MessageService msgSvc;
    private QueryRegistry qryRegistry;

    public ExchangeServiceImpl(GridKernalContext ctx) {
        super(ctx);
        this.locaNodeId = ctx.localNodeId();
    }

    public void taskExecutor(QueryTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public QueryTaskExecutor taskExecutor() {
        return this.taskExecutor;
    }

    public void mailboxRegistry(MailboxRegistry mailboxRegistry) {
        this.mailboxRegistry = mailboxRegistry;
    }

    public MailboxRegistry mailboxRegistry() {
        return this.mailboxRegistry;
    }

    public void messageService(MessageService msgSvc) {
        this.msgSvc = msgSvc;
    }

    public MessageService messageService() {
        return this.msgSvc;
    }

    public void queryRegistry(QueryRegistry qryRegistry) {
        this.qryRegistry = qryRegistry;
    }

    @Override
    public <Row> void sendBatch(UUID nodeId, UUID qryId, long fragmentId, long exchangeId, int batchId, boolean last, List<Row> rows) throws IgniteCheckedException {
        Query qry;
        this.messageService().send(nodeId, new QueryBatchMessage(qryId, fragmentId, exchangeId, batchId, last, Commons.cast(rows)));
        if (batchId == 0 && (qry = (Query)this.qryRegistry.query(qryId)) != null) {
            qry.onOutboundExchangeStarted(nodeId, exchangeId);
        }
    }

    @Override
    public void acknowledge(UUID nodeId, UUID qryId, long fragmentId, long exchangeId, int batchId) throws IgniteCheckedException {
        this.messageService().send(nodeId, new QueryBatchAcknowledgeMessage(qryId, fragmentId, exchangeId, batchId));
    }

    @Override
    public void closeQuery(UUID nodeId, UUID qryId) throws IgniteCheckedException {
        this.messageService().send(nodeId, new QueryCloseMessage(qryId));
    }

    @Override
    public void closeInbox(UUID nodeId, UUID qryId, long fragmentId, long exchangeId) throws IgniteCheckedException {
        this.messageService().send(nodeId, new InboxCloseMessage(qryId, fragmentId, exchangeId));
    }

    @Override
    public void sendError(UUID nodeId, UUID qryId, long fragmentId, Throwable err) throws IgniteCheckedException {
        this.messageService().send(nodeId, new ErrorMessage(qryId, fragmentId, err));
    }

    @Override
    public void onStart(GridKernalContext ctx) {
        CalciteQueryProcessor proc = Objects.requireNonNull(Commons.lookupComponent(ctx, CalciteQueryProcessor.class));
        this.taskExecutor(proc.taskExecutor());
        this.mailboxRegistry(proc.mailboxRegistry());
        this.messageService(proc.messageService());
        this.queryRegistry(proc.queryRegistry());
        this.init();
    }

    @Override
    public void init() {
        this.messageService().register((n, m) -> this.onMessage(n, (InboxCloseMessage)m), MessageType.QUERY_INBOX_CANCEL_MESSAGE);
        this.messageService().register((n, m) -> this.onMessage(n, (QueryBatchAcknowledgeMessage)m), MessageType.QUERY_ACKNOWLEDGE_MESSAGE);
        this.messageService().register((n, m) -> this.onMessage(n, (QueryBatchMessage)m), MessageType.QUERY_BATCH_MESSAGE);
        this.messageService().register((n, m) -> this.onMessage(n, (QueryCloseMessage)m), MessageType.QUERY_CLOSE_MESSAGE);
    }

    @Override
    public boolean alive(UUID nodeId) {
        return this.messageService().alive(nodeId);
    }

    @Override
    public void onOutboundExchangeFinished(UUID qryId, long exchangeId) {
        Query qry = (Query)this.qryRegistry.query(qryId);
        if (qry != null) {
            qry.onOutboundExchangeFinished(exchangeId);
        }
    }

    @Override
    public void onInboundExchangeFinished(UUID nodeId, UUID qryId, long exchangeId) {
        Query qry = (Query)this.qryRegistry.query(qryId);
        if (qry != null) {
            qry.onInboundExchangeFinished(nodeId, exchangeId);
        }
    }

    protected void onMessage(UUID nodeId, InboxCloseMessage msg) {
        Collection<Inbox<?>> inboxes = this.mailboxRegistry().inboxes(msg.queryId(), msg.fragmentId(), msg.exchangeId());
        if (!F.isEmpty(inboxes)) {
            for (Inbox<?> inbox : inboxes) {
                inbox.context().execute(inbox::close, inbox::onError);
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Stale inbox cancel message received: [nodeId=" + nodeId + ", queryId=" + msg.queryId() + ", fragmentId=" + msg.fragmentId() + ", exchangeId=" + msg.exchangeId() + "]");
        }
    }

    protected void onMessage(UUID nodeId, QueryCloseMessage msg) {
        RunningQuery qry = this.qryRegistry.query(msg.queryId());
        if (qry != null) {
            qry.cancel();
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Stale query close message received: [nodeId=" + nodeId + ", queryId=" + msg.queryId() + "]");
        }
    }

    protected void onMessage(UUID nodeId, QueryBatchAcknowledgeMessage msg) {
        Outbox<?> outbox = this.mailboxRegistry().outbox(msg.queryId(), msg.exchangeId());
        if (outbox != null) {
            try {
                outbox.onAcknowledge(nodeId, msg.batchId());
            }
            catch (Throwable e) {
                outbox.onError(e);
                throw new IgniteException("Unexpected exception", e);
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Stale acknowledge message received: [nodeId=" + nodeId + ", queryId=" + msg.queryId() + ", fragmentId=" + msg.fragmentId() + ", exchangeId=" + msg.exchangeId() + ", batchId=" + msg.batchId() + "]");
        }
    }

    protected void onMessage(UUID nodeId, QueryBatchMessage msg) {
        Inbox<?> inbox = this.mailboxRegistry().inbox(msg.queryId(), msg.exchangeId());
        if (inbox == null && msg.batchId() == 0) {
            Inbox newInbox = new Inbox(this.baseInboxContext(nodeId, msg.queryId(), msg.fragmentId()), this, this.mailboxRegistry(), msg.exchangeId(), msg.exchangeId());
            inbox = this.mailboxRegistry().register(newInbox);
        }
        if (inbox != null) {
            try {
                Query qry;
                if (msg.batchId() == 0 && (qry = (Query)this.qryRegistry.query(msg.queryId())) != null) {
                    qry.onInboundExchangeStarted(nodeId, msg.exchangeId());
                }
                inbox.onBatchReceived(nodeId, msg.batchId(), msg.last(), Commons.cast(msg.rows()));
            }
            catch (Throwable e) {
                inbox.onError(e);
                throw new IgniteException("Unexpected exception", e);
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Stale batch message received: [nodeId=" + nodeId + ", queryId=" + msg.queryId() + ", fragmentId=" + msg.fragmentId() + ", exchangeId=" + msg.exchangeId() + ", batchId=" + msg.batchId() + "]");
        }
    }

    private ExecutionContext<?> baseInboxContext(UUID nodeId, UUID qryId, long fragmentId) {
        return new ExecutionContext(BaseQueryContext.builder().logger(this.log).build(), this.taskExecutor(), qryId, this.locaNodeId, nodeId, null, new FragmentDescription(fragmentId, null, null, null), null, NoOpMemoryTracker.INSTANCE, (Map<String, Object>)ImmutableMap.of());
    }
}

