/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.h2.table.Table;
import org.h2.value.Value;

public class H2ValueIndexKey
implements IndexKey {
    private final CacheObjectValueContext coCtx;
    private final Table table;
    private final Value val;

    public H2ValueIndexKey(CacheObjectValueContext coCtx, Table table, Value val) {
        this.coCtx = coCtx;
        this.table = table;
        this.val = val;
    }

    public Object key() {
        return this.val.getObject();
    }

    public IndexKeyType type() {
        return IndexKeyType.forCode((int)this.val.getType());
    }

    public int compare(IndexKey o) throws IgniteCheckedException {
        return this.compareValues(this.val, H2Utils.wrap(this.coCtx, o.key(), o.type().code()));
    }

    private int compareValues(Value v1, Value v2) {
        return Integer.signum(this.table.compareTypeSafe(v1, v2));
    }

    public boolean isComparableTo(IndexKey k) {
        return true;
    }
}

