/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.query.h2.H2QueryInfo;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;

public class H2QueryFetchSizeInterceptor {
    private final IgniteLogger log;
    private final H2QueryInfo qryInfo;
    private long threshold;
    private final int thresholdMult;
    private long fetchedSize;
    private boolean bigResults;

    public H2QueryFetchSizeInterceptor(IgniteH2Indexing h2, H2QueryInfo qryInfo, IgniteLogger log) {
        assert (log != null);
        assert (qryInfo != null);
        this.log = log;
        this.qryInfo = qryInfo;
        this.threshold = h2.longRunningQueries().getResultSetSizeThreshold();
        this.thresholdMult = h2.longRunningQueries().getResultSetSizeThresholdMultiplier();
    }

    public void checkOnFetchNext() {
        ++this.fetchedSize;
        if (this.threshold > 0L && this.fetchedSize >= this.threshold) {
            this.qryInfo.printLogMessage(this.log, "Query produced big result set.", "fetched=" + this.fetchedSize);
            this.threshold = this.thresholdMult > 1 ? (this.threshold *= (long)this.thresholdMult) : 0L;
            this.bigResults = true;
        }
    }

    public void checkOnClose() {
        if (this.bigResults) {
            this.qryInfo.printLogMessage(this.log, "Query produced big result set.", "fetched=" + this.fetchedSize);
        }
    }
}

