/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.systemview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.commandline.systemview.SystemViewCommandArg;
import org.apache.ignite.internal.visor.systemview.VisorSystemViewTask;
import org.apache.ignite.internal.visor.systemview.VisorSystemViewTaskArg;
import org.apache.ignite.internal.visor.systemview.VisorSystemViewTaskResult;

public class SystemViewCommand
extends AbstractCommand<VisorSystemViewTaskArg> {
    public static final String COLUMN_SEPARATOR = "    ";
    private VisorSystemViewTaskArg taskArg;
    private UUID nodeId;

    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger log) throws Exception {
        try {
            VisorSystemViewTaskResult res;
            try (GridClient client = Command.startClient(clientCfg);){
                res = (VisorSystemViewTaskResult)TaskExecutor.executeTaskByNameOnNode(client, VisorSystemViewTask.class.getName(), this.taskArg, this.nodeId, clientCfg);
            }
            if (res != null) {
                SystemViewCommand.printTable(res.attributes(), res.types(), res.rows(), log);
            } else {
                log.info("No system view with specified name was found [name=" + this.taskArg.systemViewName() + "]");
            }
            return res;
        }
        catch (Throwable e) {
            log.severe("Failed to perform operation.");
            log.severe(CommandLogger.errorMessage(e));
            throw e;
        }
    }

    public static void printTable(List<String> titles, List<VisorSystemViewTask.SimpleType> types, List<List<?>> data, Logger log) {
        List<Integer> colSzs = titles != null ? titles.stream().map(String::length).collect(Collectors.toList()) : types.stream().map(x -> 0).collect(Collectors.toList());
        ArrayList rows = new ArrayList(data.size());
        data.forEach(row -> {
            ListIterator colSzIter = colSzs.listIterator();
            rows.add(row.stream().map(val -> {
                String res = String.valueOf(val);
                colSzIter.set(Math.max((Integer)colSzIter.next(), res.length()));
                return res;
            }).collect(Collectors.toList()));
        });
        if (titles != null) {
            SystemViewCommand.printRow(titles, Collections.nCopies(titles.size(), VisorSystemViewTask.SimpleType.STRING), colSzs, log);
        }
        rows.forEach(row -> SystemViewCommand.printRow(row, types, colSzs, log));
    }

    private static void printRow(Collection<String> row, Collection<VisorSystemViewTask.SimpleType> types, Collection<Integer> colSzs, Logger log) {
        Iterator<VisorSystemViewTask.SimpleType> typeIter = types.iterator();
        Iterator<Integer> colSzsIter = colSzs.iterator();
        log.info(row.stream().map(colVal -> {
            VisorSystemViewTask.SimpleType colType = (VisorSystemViewTask.SimpleType)typeIter.next();
            int colSz = (Integer)colSzsIter.next();
            String format = colType == VisorSystemViewTask.SimpleType.DATE || colType == VisorSystemViewTask.SimpleType.NUMBER ? "%" + colSz + "s" : "%-" + colSz + "s";
            return String.format(format, colVal);
        }).collect(Collectors.joining(COLUMN_SEPARATOR)));
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        this.nodeId = null;
        String sysViewName = null;
        while (argIter.hasNextSubArg()) {
            String arg = argIter.nextArg("Failed to read command argument.");
            SystemViewCommandArg cmdArg = CommandArgUtils.of(arg, SystemViewCommandArg.class);
            if (cmdArg == SystemViewCommandArg.NODE_ID) {
                String nodeIdArg = argIter.nextArg("ID of the node from which system view content should be obtained is expected.");
                try {
                    this.nodeId = UUID.fromString(nodeIdArg);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Failed to parse " + SystemViewCommandArg.NODE_ID + " command argument. String representation of \"java.util.UUID\" is exepected. For example: 123e4567-e89b-42d3-a456-556642440000", e);
                }
            }
            if (sysViewName != null) {
                throw new IllegalArgumentException("Multiple system view names are not supported.");
            }
            sysViewName = arg;
        }
        if (sysViewName == null) {
            throw new IllegalArgumentException("The name of the system view for which its content should be printed is expected.");
        }
        this.taskArg = new VisorSystemViewTaskArg(sysViewName);
    }

    @Override
    public VisorSystemViewTaskArg arg() {
        return this.taskArg;
    }

    @Override
    public void printUsage(Logger log) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("node_id", "ID of the node to get the system view from. If not set, random node will be chosen.");
        params.put("system_view_name", "Name of the system view which content should be printed. Both \"SQL\" and \"Java\" styles of system view name are supported (e.g. SQL_TABLES and sql.tables will be handled similarly).");
        this.usage(log, "Print system view content:", CommandList.SYSTEM_VIEW, params, CommandLogger.optional(SystemViewCommandArg.NODE_ID, "node_id"), "system_view_name");
    }

    @Override
    public String name() {
        return CommandList.SYSTEM_VIEW.toCommandName();
    }
}

