/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.encryption;

import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.encryption.CacheGroupEncryptionCommand;
import org.apache.ignite.internal.commandline.encryption.ChangeCacheGroupKeyCommand;
import org.apache.ignite.internal.commandline.encryption.ChangeMasterKeyCommand;
import org.apache.ignite.internal.commandline.encryption.GetMasterKeyNameCommand;
import org.apache.ignite.internal.commandline.encryption.ReencryptionRateCommand;
import org.jetbrains.annotations.Nullable;

public enum EncryptionSubcommands {
    GET_MASTER_KEY_NAME("get_master_key_name", new GetMasterKeyNameCommand()),
    CHANGE_MASTER_KEY("change_master_key", new ChangeMasterKeyCommand()),
    CHANGE_CACHE_GROUP_KEY("change_cache_key", new ChangeCacheGroupKeyCommand()),
    CACHE_GROUP_KEY_IDS("cache_key_ids", new CacheGroupEncryptionCommand.CacheKeyIds()),
    REENCRYPTION_STATUS("reencryption_status", new CacheGroupEncryptionCommand.ReencryptionStatus()),
    REENCRYPTION_SUSPEND("suspend_reencryption", new CacheGroupEncryptionCommand.SuspendReencryption()),
    REENCRYPTION_RESUME("resume_reencryption", new CacheGroupEncryptionCommand.ResumeReencryption()),
    REENCRYPTION_RATE("reencryption_rate_limit", new ReencryptionRateCommand());

    private final String name;
    private final Command<?> cmd;

    private EncryptionSubcommands(String name, Command<?> cmd) {
        this.name = name;
        this.cmd = cmd;
    }

    public String text() {
        return this.name;
    }

    public Command<?> subcommand() {
        return this.cmd;
    }

    @Nullable
    public static EncryptionSubcommands of(String text) {
        for (EncryptionSubcommands cmd : EncryptionSubcommands.values()) {
            if (!cmd.name.equalsIgnoreCase(text)) continue;
            return cmd;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }
}

