/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cache;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.commandline.cache.CacheSubcommands;
import org.apache.ignite.internal.commandline.cache.argument.IndexRebuildCommandArg;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.cache.index.ScheduleIndexRebuildTask;
import org.apache.ignite.internal.visor.cache.index.ScheduleIndexRebuildTaskArg;
import org.apache.ignite.internal.visor.cache.index.ScheduleIndexRebuildTaskRes;
import org.jetbrains.annotations.Nullable;

public class CacheScheduleIndexesRebuild
extends AbstractCommand<Arguments> {
    private static final String CACHE_NAMES_FORMAT = "cacheName[index1,...indexN],cacheName2,cacheName3[index1]";
    private static final String CACHE_GROUPS_FORMAT = "groupName1,groupName2,...groupNameN";
    private Arguments args;

    @Override
    public void printUsage(Logger logger) {
        String desc = "Schedules rebuild of the indexes for specified caches via the Maintenance Mode. Schedules rebuild of specified caches and cache-groups";
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(2);
        map.put(IndexRebuildCommandArg.NODE_ID.argName(), "(Optional) Specify node for indexes rebuild. If not specified, schedules rebuild on all nodes.");
        map.put(IndexRebuildCommandArg.CACHE_NAMES_TARGET.argName(), "Comma-separated list of cache names with optionally specified indexes. If indexes are not specified then all indexes of the cache will be scheduled for the rebuild operation. Can be used simultaneously with cache group names.");
        map.put(IndexRebuildCommandArg.CACHE_GROUPS_TARGET.argName(), "Comma-separated list of cache group names for which indexes should be scheduled for the rebuild. Can be used simultaneously with cache names.");
        this.usageCache(logger, CacheSubcommands.INDEX_REBUILD, desc, map, IndexRebuildCommandArg.NODE_ID.argName() + " nodeId", IndexRebuildCommandArg.CACHE_NAMES_TARGET + " " + CACHE_NAMES_FORMAT, IndexRebuildCommandArg.CACHE_GROUPS_TARGET + " " + CACHE_GROUPS_FORMAT);
    }

    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger logger) throws Exception {
        ScheduleIndexRebuildTaskRes taskRes;
        try (GridClient client = Command.startClient(clientCfg);){
            UUID nodeId = this.args.nodeId;
            if (nodeId == null) {
                nodeId = TaskExecutor.BROADCAST_UUID;
            }
            taskRes = (ScheduleIndexRebuildTaskRes)TaskExecutor.executeTaskByNameOnNode(client, ScheduleIndexRebuildTask.class.getName(), new ScheduleIndexRebuildTaskArg(this.args.cacheToIndexes, this.args.cacheGroups), nodeId, clientCfg);
        }
        this.printResult(taskRes, logger);
        return taskRes;
    }

    private void printResult(ScheduleIndexRebuildTaskRes taskRes, Logger logger) {
        taskRes.results().forEach((nodeId, res) -> {
            this.printMissed(logger, "WARNING: These caches were not found:", res.notFoundCacheNames());
            this.printMissed(logger, "WARNING: These cache groups were not found:", res.notFoundGroupNames());
            if (!F.isEmpty((Map)res.notFoundIndexes()) && CacheScheduleIndexesRebuild.hasAtLeastOneIndex(res.notFoundIndexes())) {
                String warning = "WARNING: These indexes were not found:";
                logger.info(warning);
                CacheScheduleIndexesRebuild.printCachesAndIndexes(res.notFoundIndexes(), logger);
            }
            if (!F.isEmpty((Map)res.cacheToIndexes()) && CacheScheduleIndexesRebuild.hasAtLeastOneIndex(res.cacheToIndexes())) {
                logger.info("Indexes rebuild was scheduled for these caches:");
                CacheScheduleIndexesRebuild.printCachesAndIndexes(res.cacheToIndexes(), logger);
            } else {
                logger.info("WARNING: Indexes rebuild was not scheduled for any cache. Check command input.");
            }
            logger.info("");
        });
    }

    private void printMissed(Logger logger, String message, Set<String> missed) {
        if (!F.isEmpty(missed)) {
            logger.info(message);
            missed.stream().sorted().forEach(name -> logger.info("  " + name));
            logger.info("");
        }
    }

    private static void printCachesAndIndexes(Map<String, Set<String>> cachesToIndexes, Logger logger) {
        cachesToIndexes.forEach((cacheName, indexes) -> {
            logger.info("  " + cacheName + ":");
            indexes.forEach(index -> logger.info("    " + index));
        });
    }

    private static boolean hasAtLeastOneIndex(Map<String, Set<String>> cacheToIndexes) {
        return cacheToIndexes.values().stream().anyMatch(indexes -> !indexes.isEmpty());
    }

    @Override
    public Arguments arg() {
        return this.args;
    }

    @Override
    public String name() {
        return CacheSubcommands.INDEX_REBUILD.text().toUpperCase();
    }

    @Override
    public void parseArguments(CommandArgIterator argIterator) {
        UUID nodeId = null;
        HashMap cacheToIndexes = null;
        Set cacheGroups = null;
        block5: while (argIterator.hasNextSubArg()) {
            String nextArg = argIterator.nextArg("");
            IndexRebuildCommandArg arg = CommandArgUtils.of(nextArg, IndexRebuildCommandArg.class);
            if (arg == null) {
                throw new IllegalArgumentException("Unknown argument: " + nextArg);
            }
            switch (arg) {
                case NODE_ID: {
                    if (nodeId != null) {
                        throw new IllegalArgumentException(arg.argName() + " arg specified twice.");
                    }
                    nodeId = UUID.fromString(argIterator.nextArg("Failed to read node id."));
                    continue block5;
                }
                case CACHE_NAMES_TARGET: {
                    if (cacheToIndexes != null) {
                        throw new IllegalArgumentException(arg.argName() + " arg specified twice.");
                    }
                    cacheToIndexes = new HashMap();
                    String cacheNamesArg = argIterator.nextArg("Expected a comma-separated cache names (and optionally a comma-separated list of index names in square brackets).");
                    Pattern cacheNamesPattern = Pattern.compile("([^,\\[\\]]+)(\\[(.*?)])?");
                    Matcher matcher = cacheNamesPattern.matcher(cacheNamesArg);
                    boolean found = false;
                    while (matcher.find()) {
                        found = true;
                        String cacheName = matcher.group(1);
                        boolean specifiedIndexes = matcher.group(2) != null;
                        String commaSeparatedIndexes = matcher.group(3);
                        if (!specifiedIndexes) {
                            cacheToIndexes.put(cacheName, Collections.emptySet());
                            continue;
                        }
                        if (F.isEmpty((String)commaSeparatedIndexes)) {
                            throw new IllegalArgumentException("Square brackets must contain comma-separated indexes or not be used at all.");
                        }
                        Set indexes = Arrays.stream(commaSeparatedIndexes.split(",")).collect(Collectors.toSet());
                        cacheToIndexes.put(cacheName, indexes);
                    }
                    if (found) continue block5;
                    throw new IllegalArgumentException("Wrong format for --cache-names, should be: cacheName[index1,...indexN],cacheName2,cacheName3[index1]");
                }
                case CACHE_GROUPS_TARGET: {
                    if (cacheGroups != null) {
                        throw new IllegalArgumentException(arg.argName() + " arg specified twice.");
                    }
                    String cacheGroupsArg = argIterator.nextArg("Expected comma-separated cache group names");
                    cacheGroups = Arrays.stream(cacheGroupsArg.split(",")).collect(Collectors.toSet());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Unknown argument: " + arg.argName());
        }
        this.args = new Arguments(nodeId, cacheToIndexes, cacheGroups);
        this.validateArguments();
    }

    private void validateArguments() {
        Set cacheGroups = this.args.cacheGroups;
        Map cacheToIndexes = this.args.cacheToIndexes;
        if ((cacheGroups == null || cacheGroups.isEmpty()) && (cacheToIndexes == null || cacheToIndexes.isEmpty())) {
            throw new IllegalArgumentException(IndexRebuildCommandArg.CACHE_NAMES_TARGET + " or " + IndexRebuildCommandArg.CACHE_GROUPS_TARGET + " must be specified.");
        }
    }

    public static class Arguments {
        @Nullable
        private final UUID nodeId;
        @Nullable
        private final Map<String, Set<String>> cacheToIndexes;
        @Nullable
        private final Set<String> cacheGroups;

        private Arguments(@Nullable UUID nodeId, @Nullable Map<String, Set<String>> cacheToIndexes, @Nullable Set<String> cacheGroups) {
            this.nodeId = nodeId;
            this.cacheToIndexes = cacheToIndexes;
            this.cacheGroups = cacheGroups;
        }

        @Nullable
        public Map<String, Set<String>> cacheToIndexes() {
            return this.cacheToIndexes;
        }

        @Nullable
        public Set<String> cacheGroups() {
            return this.cacheGroups;
        }

        public String toString() {
            return S.toString(Arguments.class, (Object)this);
        }
    }
}

