/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview.view;

import java.util.Date;
import org.apache.ignite.internal.managers.systemview.walker.Order;
import org.apache.ignite.internal.processors.query.QueryHistory;

public class SqlQueryHistoryView {
    private final QueryHistory qry;

    public SqlQueryHistoryView(QueryHistory qry) {
        this.qry = qry;
    }

    @Order
    public String schemaName() {
        return this.qry.schema();
    }

    @Order(value=1)
    public String sql() {
        return this.qry.query();
    }

    @Order(value=2)
    public boolean local() {
        return this.qry.local();
    }

    @Order(value=3)
    public long executions() {
        return this.qry.executions();
    }

    @Order(value=4)
    public long failures() {
        return this.qry.failures();
    }

    @Order(value=5)
    public long durationMin() {
        return this.qry.minimumTime();
    }

    @Order(value=6)
    public long durationMax() {
        return this.qry.maximumTime();
    }

    @Order(value=7)
    public Date lastStartTime() {
        return new Date(this.qry.lastStartTime());
    }
}

