/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.verify;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.cache.verify.ContentionClosure;
import org.apache.ignite.internal.processors.cache.verify.ContentionInfo;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.verify.VisorContentionJobResult;
import org.apache.ignite.internal.visor.verify.VisorContentionTaskArg;
import org.apache.ignite.internal.visor.verify.VisorContentionTaskResult;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorContentionTask
extends VisorMultiNodeTask<VisorContentionTaskArg, VisorContentionTaskResult, VisorContentionJobResult> {
    private static final long serialVersionUID = 0L;

    @Override
    @Nullable
    protected VisorContentionTaskResult reduce0(List<ComputeJobResult> list) throws IgniteException {
        HashMap<UUID, Exception> exceptions = new HashMap<UUID, Exception>();
        ArrayList<VisorContentionJobResult> infos = new ArrayList<VisorContentionJobResult>();
        for (ComputeJobResult res : list) {
            if (res.getException() != null) {
                exceptions.put(res.getNode().id(), res.getException());
                continue;
            }
            infos.add((VisorContentionJobResult)res.getData());
        }
        return new VisorContentionTaskResult(infos, exceptions);
    }

    @Override
    protected VisorJob<VisorContentionTaskArg, VisorContentionJobResult> job(VisorContentionTaskArg arg) {
        return new VisorContentionJob(arg, this.debug);
    }

    private static class VisorContentionJob
    extends VisorJob<VisorContentionTaskArg, VisorContentionJobResult> {
        private static final long serialVersionUID = 0L;

        protected VisorContentionJob(@Nullable VisorContentionTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected VisorContentionJobResult run(@Nullable VisorContentionTaskArg arg) throws IgniteException {
            try {
                ContentionClosure clo = new ContentionClosure(arg.minQueueSize(), arg.maxPrint());
                this.ignite.context().resource().injectGeneric(clo);
                ContentionInfo info = clo.call();
                return new VisorContentionJobResult(info);
            }
            catch (Exception e) {
                throw new IgniteException(e);
            }
        }

        public String toString() {
            return S.toString(VisorContentionJob.class, this);
        }
    }
}

