/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.configuration.TransactionConfiguration;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;

public class VisorTransactionConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private TransactionConcurrency dfltConcurrency;
    private TransactionIsolation dfltIsolation;
    private long dfltTimeout;
    private int pessimisticTxLogLinger;
    private int pessimisticTxLogSize;
    private String txMgrFactory;
    private boolean useJtaSync;

    public VisorTransactionConfiguration() {
    }

    public VisorTransactionConfiguration(TransactionConfiguration cfg) {
        this.dfltConcurrency = cfg.getDefaultTxConcurrency();
        this.dfltIsolation = cfg.getDefaultTxIsolation();
        this.dfltTimeout = cfg.getDefaultTxTimeout();
        this.pessimisticTxLogLinger = cfg.getPessimisticTxLogLinger();
        this.pessimisticTxLogSize = cfg.getPessimisticTxLogSize();
        this.txMgrFactory = VisorTaskUtils.compactClass(cfg.getTxManagerFactory());
        this.useJtaSync = cfg.isUseJtaSynchronization();
    }

    public TransactionConcurrency getDefaultTxConcurrency() {
        return this.dfltConcurrency;
    }

    public TransactionIsolation getDefaultTxIsolation() {
        return this.dfltIsolation;
    }

    public long getDefaultTxTimeout() {
        return this.dfltTimeout;
    }

    public int getPessimisticTxLogLinger() {
        return this.pessimisticTxLogLinger;
    }

    public int getPessimisticTxLogSize() {
        return this.pessimisticTxLogSize;
    }

    public String getTxManagerFactory() {
        return this.txMgrFactory;
    }

    public boolean isUseJtaSync() {
        return this.useJtaSync;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeEnum(out, this.dfltConcurrency);
        U.writeEnum(out, this.dfltIsolation);
        out.writeLong(this.dfltTimeout);
        out.writeInt(this.pessimisticTxLogLinger);
        out.writeInt(this.pessimisticTxLogSize);
        U.writeString(out, this.txMgrFactory);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.dfltConcurrency = TransactionConcurrency.fromOrdinal(in.readByte());
        this.dfltIsolation = TransactionIsolation.fromOrdinal(in.readByte());
        this.dfltTimeout = in.readLong();
        this.pessimisticTxLogLinger = in.readInt();
        this.pessimisticTxLogSize = in.readInt();
        this.txMgrFactory = U.readString(in);
    }

    public String toString() {
        return S.toString(VisorTransactionConfiguration.class, this);
    }
}

