/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.log;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.task.GridVisorManagementTask;
import org.apache.ignite.internal.util.io.GridReversedLinesFileReader;
import org.apache.ignite.internal.util.lang.GridTuple3;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.log.VisorLogFile;
import org.apache.ignite.internal.visor.log.VisorLogSearchResult;
import org.apache.ignite.internal.visor.log.VisorLogSearchTaskArg;
import org.apache.ignite.internal.visor.log.VisorLogSearchTaskResult;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.jetbrains.annotations.Nullable;

@GridInternal
@GridVisorManagementTask
public class VisorLogSearchTask
extends VisorMultiNodeTask<VisorLogSearchTaskArg, VisorLogSearchTaskResult, Collection<VisorLogSearchResult>> {
    private static final long serialVersionUID = 0L;
    public static final int LINE_CNT = 21;
    public static final int HALF = 10;

    protected VisorLogSearchJob job(VisorLogSearchTaskArg arg) {
        return new VisorLogSearchJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected VisorLogSearchTaskResult reduce0(List<ComputeJobResult> results) {
        ArrayList<VisorLogSearchResult> searchRes = new ArrayList<VisorLogSearchResult>();
        HashMap<Exception, UUID> exRes = U.newHashMap(0);
        for (ComputeJobResult result : results) {
            if (result.getException() != null) {
                exRes.put(result.getException(), result.getNode().id());
                continue;
            }
            if (result.getData() == null) continue;
            Collection data = (Collection)result.getData();
            searchRes.addAll(data);
        }
        return new VisorLogSearchTaskResult(exRes.isEmpty() ? null : exRes, searchRes.isEmpty() ? null : searchRes);
    }

    private static class VisorLogSearchJob
    extends VisorJob<VisorLogSearchTaskArg, Collection<VisorLogSearchResult>> {
        private static final long serialVersionUID = 0L;

        private VisorLogSearchJob(VisorLogSearchTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        private List<GridTuple3<String[], Integer, Integer>> searchInFile(File f, Charset charset, String searchStr, int limit) throws IOException {
            ArrayList<GridTuple3<String[], Integer, Integer>> searched = new ArrayList<GridTuple3<String[], Integer, Integer>>();
            int line = 0;
            Throwable throwable = null;
            try (GridReversedLinesFileReader reader = new GridReversedLinesFileReader(f, 4096, charset);){
                String s;
                LinkedList<String> lastLines = new LinkedList<String>();
                int lastFoundLine = 0;
                int foundCnt = 0;
                while ((s = reader.readLine()) != null) {
                    if (lastFoundLine > 0 && ++line - lastFoundLine <= 10) {
                        GridTuple3 tup;
                        int delta;
                        for (int i = searched.size() - 1; i >= 0 && (delta = line - (Integer)(tup = (GridTuple3)searched.get(i)).get2()) <= 10 && delta != 0; --i) {
                            ((String[])tup.get1())[10 - delta] = s;
                        }
                    }
                    if (foundCnt < limit && s.toLowerCase().contains(searchStr)) {
                        String[] buf = new String[21];
                        buf[10] = s;
                        int i = 1;
                        Iterator iterator = lastLines.iterator();
                        while (iterator.hasNext()) {
                            String l;
                            buf[10 + i] = l = (String)iterator.next();
                            ++i;
                        }
                        lastFoundLine = line;
                        searched.add(new GridTuple3<String[], Integer, Integer>(buf, line, 0));
                        ++foundCnt;
                    }
                    if (lastLines.size() >= 10) {
                        lastLines.removeFirst();
                    }
                    lastLines.add(s);
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            for (GridTuple3 gridTuple3 : searched) {
                gridTuple3.set2(line - (Integer)gridTuple3.get2() + 1);
                gridTuple3.set3(line);
            }
            return searched;
        }

        @Override
        protected Collection<VisorLogSearchResult> run(VisorLogSearchTaskArg arg) {
            try {
                File folder = VisorTaskUtils.resolveIgnitePath(arg.getFolder());
                if (folder == null) {
                    return null;
                }
                folder = VisorTaskUtils.resolveSymbolicLink(folder);
                UUID uuid = this.ignite.localNode().id();
                String nid = uuid.toString().toLowerCase();
                String filePtrn = arg.getFilePattern().replace("@nid8", nid.substring(0, 8)).replace("@nid", nid);
                int pathIdx = (folder.isDirectory() ? folder : folder.getParentFile()).getAbsolutePath().length() + 1;
                List<VisorLogFile> matchingFiles = VisorTaskUtils.matchedFiles(folder, filePtrn);
                ArrayList<VisorLogSearchResult> results = new ArrayList<VisorLogSearchResult>(arg.getLimit());
                int resCnt = 0;
                for (VisorLogFile logFile : matchingFiles) {
                    try {
                        File f = new File(logFile.getPath());
                        if (!VisorTaskUtils.textFile(f, false)) continue;
                        Charset charset = VisorTaskUtils.decode(f);
                        if (resCnt == arg.getLimit()) break;
                        List<GridTuple3<String[], Integer, Integer>> searched = this.searchInFile(f, charset, arg.getSearchString(), arg.getLimit() - resCnt);
                        resCnt += searched.size();
                        String path = f.getAbsolutePath().substring(pathIdx);
                        long sz = f.length();
                        long lastModified = f.lastModified();
                        for (GridTuple3<String[], Integer, Integer> e : searched) {
                            results.add(new VisorLogSearchResult(uuid, path, sz, lastModified, e.get1(), e.get2(), e.get3(), charset.name()));
                        }
                    }
                    catch (IOException iOException) {
                    }
                }
                return results.isEmpty() ? null : results;
            }
            catch (Exception e) {
                throw new IgniteException(e);
            }
        }

        public String toString() {
            return S.toString(VisorLogSearchJob.class, this);
        }
    }
}

