/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.log;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class VisorLogSearchResult
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private UUID nid;
    private String filePath;
    private long fileSize;
    private long lastModified;
    private List<String> lines;
    private int lineNum;
    private int lineCnt;
    private String encoding;

    public VisorLogSearchResult() {
    }

    public VisorLogSearchResult(UUID nid, String filePath, long fileSize, long lastModified, String[] lines, int lineNum, int lineCnt, String encoding) {
        this.nid = nid;
        this.filePath = filePath;
        this.fileSize = fileSize;
        this.lastModified = lastModified;
        this.lines = Arrays.asList(lines);
        this.lineNum = lineNum;
        this.lineCnt = lineCnt;
        this.encoding = encoding;
    }

    public UUID getNid() {
        return this.nid;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public List<String> getLines() {
        return this.lines;
    }

    public int getLineNumber() {
        return this.lineNum;
    }

    public int getLineCount() {
        return this.lineCnt;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getLine() {
        return this.lines.get(this.lines.size() / 2);
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeUuid(out, this.nid);
        U.writeString(out, this.filePath);
        out.writeLong(this.fileSize);
        out.writeLong(this.lastModified);
        U.writeCollection(out, this.lines);
        out.writeInt(this.lineNum);
        out.writeInt(this.lineCnt);
        U.writeString(out, this.encoding);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.nid = U.readUuid(in);
        this.filePath = U.readString(in);
        this.fileSize = in.readLong();
        this.lastModified = in.readLong();
        this.lines = U.readList(in);
        this.lineNum = in.readInt();
        this.lineCnt = in.readInt();
        this.encoding = U.readString(in);
    }

    public String toString() {
        return S.toString(VisorLogSearchResult.class, this);
    }
}

