/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.log;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class VisorLogFile
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String path;
    private long size;
    private long lastModified;

    public VisorLogFile() {
    }

    public VisorLogFile(File file) {
        this(file.getAbsolutePath(), file.length(), file.lastModified());
    }

    public VisorLogFile(String path, long size, long lastModified) {
        this.path = path;
        this.size = size;
        this.lastModified = lastModified;
    }

    public String getPath() {
        return this.path;
    }

    public long getSize() {
        return this.size;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.path);
        out.writeLong(this.size);
        out.writeLong(this.lastModified);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.path = U.readString(in);
        this.size = in.readLong();
        this.lastModified = in.readLong();
    }

    public String toString() {
        return S.toString(VisorLogFile.class, this);
    }
}

