/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.diagnostic.availability;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.diagnostic.availability.VisorConnectivityArgs;
import org.apache.ignite.internal.visor.diagnostic.availability.VisorConnectivityResult;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorConnectivityTask
extends VisorMultiNodeTask<VisorConnectivityArgs, Map<ClusterNode, VisorConnectivityResult>, VisorConnectivityResult> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<VisorConnectivityArgs, VisorConnectivityResult> job(VisorConnectivityArgs arg) {
        return new VisorConnectivityJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected Map<ClusterNode, VisorConnectivityResult> reduce0(List<ComputeJobResult> results) throws IgniteException {
        HashMap<ClusterNode, VisorConnectivityResult> map = new HashMap<ClusterNode, VisorConnectivityResult>();
        results.forEach(result -> {
            if (result.getException() != null) {
                return;
            }
            ClusterNode node = result.getNode();
            VisorConnectivityResult data = (VisorConnectivityResult)result.getData();
            map.put(node, data);
        });
        return map;
    }

    @Override
    protected Collection<UUID> jobNodes(VisorTaskArgument<VisorConnectivityArgs> arg) {
        return arg.getArgument().getNodeIds();
    }

    private static class VisorConnectivityJob
    extends VisorJob<VisorConnectivityArgs, VisorConnectivityResult> {
        private static final long serialVersionUID = 0L;

        private VisorConnectivityJob(VisorConnectivityArgs arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected VisorConnectivityResult run(VisorConnectivityArgs arg) {
            List<UUID> ids = arg.getNodeIds().stream().filter(uuid -> !Objects.equals(this.ignite.configuration().getNodeId().toString(), uuid.toString())).collect(Collectors.toList());
            ArrayList<ClusterNode> nodes = new ArrayList<ClusterNode>(this.ignite.cluster().forNodeIds(ids).nodes());
            CommunicationSpi spi = this.ignite.configuration().getCommunicationSpi();
            HashMap<ClusterNode, Boolean> statuses = new HashMap<ClusterNode, Boolean>();
            if (spi instanceof TcpCommunicationSpi) {
                BitSet set = ((TcpCommunicationSpi)spi).checkConnection(nodes).get();
                for (int i = 0; i < nodes.size(); ++i) {
                    ClusterNode node = (ClusterNode)nodes.get(i);
                    boolean success = set.get(i);
                    statuses.put(node, success);
                }
            }
            return new VisorConnectivityResult(statuses);
        }

        public String toString() {
            return S.toString(VisorConnectivityJob.class, this);
        }
    }
}

