/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache.metrics;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.cache.metrics.CacheMetricsOperation;

public class VisorCacheMetricsTaskArg
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private CacheMetricsOperation op;
    private Set<String> cacheNames;

    public VisorCacheMetricsTaskArg() {
    }

    public VisorCacheMetricsTaskArg(CacheMetricsOperation op, Set<String> cacheNames) {
        this.op = op;
        this.cacheNames = cacheNames == null ? null : Collections.unmodifiableSet(cacheNames);
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeEnum(out, this.op);
        U.writeCollection(out, this.cacheNames);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.op = U.readEnum(in, CacheMetricsOperation.class);
        this.cacheNames = U.readSet(in);
    }

    public CacheMetricsOperation operation() {
        return this.op;
    }

    public Set<String> cacheNames() {
        return Collections.unmodifiableSet(this.cacheNames);
    }
}

