/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import javax.cache.configuration.Factory;
import org.apache.ignite.cache.store.jdbc.CacheJdbcPojoStoreFactory;
import org.apache.ignite.cache.store.jdbc.JdbcType;
import org.apache.ignite.cache.store.jdbc.JdbcTypeField;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.cache.VisorCacheJdbcTypeField;

public class VisorCacheJdbcType
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String dbSchema;
    private String dbTbl;
    private String keyType;
    private String valType;
    private List<VisorCacheJdbcTypeField> keyFields;
    private List<VisorCacheJdbcTypeField> valFields;

    public static List<VisorCacheJdbcType> list(Factory factory) {
        CacheJdbcPojoStoreFactory jdbcFactory;
        JdbcType[] jdbcTypes;
        ArrayList<VisorCacheJdbcType> res = new ArrayList<VisorCacheJdbcType>();
        if (factory instanceof CacheJdbcPojoStoreFactory && !F.isEmpty(jdbcTypes = (jdbcFactory = (CacheJdbcPojoStoreFactory)factory).getTypes())) {
            for (JdbcType jdbcType : jdbcTypes) {
                res.add(new VisorCacheJdbcType(jdbcType));
            }
        }
        return res;
    }

    public VisorCacheJdbcType() {
    }

    public VisorCacheJdbcType(JdbcType jdbcType) {
        JdbcTypeField[] vFields;
        this.keyType = jdbcType.getKeyType();
        this.valType = jdbcType.getValueType();
        this.dbSchema = jdbcType.getDatabaseSchema();
        this.dbTbl = jdbcType.getDatabaseTable();
        JdbcTypeField[] kFields = jdbcType.getKeyFields();
        if (kFields != null) {
            this.keyFields = new ArrayList<VisorCacheJdbcTypeField>(kFields.length);
            for (JdbcTypeField fld : kFields) {
                this.keyFields.add(new VisorCacheJdbcTypeField(fld.getDatabaseFieldName(), fld.getDatabaseFieldType(), fld.getDatabaseFieldName(), U.compact(fld.getJavaFieldType().getName())));
            }
        }
        if ((vFields = jdbcType.getValueFields()) != null) {
            this.valFields = new ArrayList<VisorCacheJdbcTypeField>(vFields.length);
            for (JdbcTypeField fld : vFields) {
                this.valFields.add(new VisorCacheJdbcTypeField(fld.getDatabaseFieldName(), fld.getDatabaseFieldType(), fld.getDatabaseFieldName(), U.compact(fld.getJavaFieldType().getName())));
            }
        }
    }

    public String getDatabaseSchema() {
        return this.dbSchema;
    }

    public String getDatabaseTable() {
        return this.dbTbl;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public String getValueType() {
        return this.valType;
    }

    public List<VisorCacheJdbcTypeField> getKeyFields() {
        return this.keyFields;
    }

    public List<VisorCacheJdbcTypeField> getValueFields() {
        return this.valFields;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.dbSchema);
        U.writeString(out, this.dbTbl);
        U.writeString(out, this.keyType);
        U.writeString(out, this.valType);
        U.writeCollection(out, this.keyFields);
        U.writeCollection(out, this.valFields);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.dbSchema = U.readString(in);
        this.dbTbl = U.readString(in);
        this.keyType = U.readString(in);
        this.valType = U.readString(in);
        this.keyFields = U.readList(in);
        this.valFields = U.readList(in);
    }

    public String toString() {
        return S.toString(VisorCacheJdbcType.class, this);
    }
}

