/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.time.Instant;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridTimer {
    private final String name;
    private final long start = U.currentTimeMillis();
    private long end;
    private long threshold;

    public GridTimer(String name) {
        this.name = name;
        this.threshold = -1L;
    }

    public GridTimer(String name, long threshold) {
        this.name = name;
        this.threshold = threshold;
    }

    public long stop() {
        this.end = U.currentTimeMillis();
        if (this.maxedOut()) {
            this.debug("Timer maxed out [name=" + this.name + ", duration=" + this.duration() + ']');
        }
        return this.end - this.start;
    }

    public boolean stopx() {
        this.end = U.currentTimeMillis();
        if (this.maxedOut()) {
            this.debug("Timer maxed out [name=" + this.name + ", duration=" + this.duration() + ']');
            return false;
        }
        return true;
    }

    public boolean maxedOut() {
        return this.threshold > 0L && this.duration() >= this.threshold;
    }

    boolean stopped() {
        return this.end > 0L;
    }

    public long duration() {
        return this.end > 0L ? this.end - this.start : U.currentTimeMillis() - this.start;
    }

    public long endTime() {
        return this.end;
    }

    public long startTime() {
        return this.start;
    }

    public long threshold() {
        return this.threshold;
    }

    public String name() {
        return this.name;
    }

    private void debug(String msg) {
        System.out.println('<' + IgniteUtils.DEBUG_DATE_FMT.format(Instant.ofEpochMilli(U.currentTimeMillis())) + "><DEBUG><" + Thread.currentThread().getName() + "> " + msg);
    }

    public String toString() {
        return S.toString(GridTimer.class, this, "duration", (Object)this.duration());
    }
}

