/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.security;

import java.util.Collection;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.security.IgniteSecurity;
import org.apache.ignite.internal.processors.security.OperationSecurityContext;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.processors.security.sandbox.IgniteSandbox;
import org.apache.ignite.internal.processors.security.sandbox.NoOpSandbox;
import org.apache.ignite.plugin.security.AuthenticationContext;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecurityException;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.plugin.security.SecuritySubject;
import org.apache.ignite.spi.IgniteNodeValidationResult;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;
import org.jetbrains.annotations.Nullable;

public class NoOpIgniteSecurityProcessor
extends GridProcessorAdapter
implements IgniteSecurity {
    public static final String SECURITY_DISABLED_ERROR_MSG = "Operation cannot be performed: Ignite security disabled.";
    private final OperationSecurityContext opSecCtx = new OperationSecurityContext(this, null){

        @Override
        public void close() {
        }
    };
    private final IgniteSandbox sandbox = new NoOpSandbox();

    public NoOpIgniteSecurityProcessor(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    public OperationSecurityContext withContext(SecurityContext secCtx) {
        return this.opSecCtx;
    }

    @Override
    public OperationSecurityContext withContext(UUID nodeId) {
        return this.opSecCtx;
    }

    @Override
    public boolean isDefaultContext() {
        return true;
    }

    @Override
    public SecurityContext securityContext() {
        return null;
    }

    @Override
    public SecurityContext authenticateNode(ClusterNode node, SecurityCredentials cred) {
        return null;
    }

    @Override
    public boolean isGlobalNodeAuthentication() {
        return false;
    }

    @Override
    public SecurityContext authenticate(AuthenticationContext ctx) {
        throw new IgniteException(SECURITY_DISABLED_ERROR_MSG);
    }

    @Override
    public Collection<SecuritySubject> authenticatedSubjects() {
        return null;
    }

    @Override
    public SecuritySubject authenticatedSubject(UUID subjId) {
        return null;
    }

    @Override
    public void onSessionExpired(UUID subjId) {
    }

    @Override
    public void authorize(String name, SecurityPermission perm) throws SecurityException {
    }

    @Override
    public IgniteSandbox sandbox() {
        return this.sandbox;
    }

    @Override
    public boolean enabled() {
        return false;
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode node) {
        return this.validateSecProcClass(node);
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode node, DiscoveryDataBag.JoiningNodeDiscoveryData discoData) {
        return this.validateSecProcClass(node);
    }

    private IgniteNodeValidationResult validateSecProcClass(ClusterNode node) {
        String rmtCls = (String)node.attribute("grid.security.processor.class");
        if (rmtCls != null) {
            ClusterNode locNode = this.ctx.discovery().localNode();
            return new IgniteNodeValidationResult(node.id(), String.format("Local node's grid security processor class is not equal to remote node's grid security processor class [locNodeId=%s, rmtNodeId=%s, locCls=%s, rmtCls=%s]", locNode.id(), node.id(), "undefined", rmtCls), String.format("Local node's grid security processor class is not equal to remote node's grid security processor class [locNodeId=%s, rmtNodeId=%s, locCls=%s, rmtCls=%s]", node.id(), locNode.id(), rmtCls, "undefined"));
        }
        return null;
    }

    @Override
    public void createUser(String login, char[] pwd) throws IgniteCheckedException {
        throw new IgniteException(SECURITY_DISABLED_ERROR_MSG);
    }

    @Override
    public void alterUser(String login, char[] pwd) throws IgniteCheckedException {
        throw new IgniteException(SECURITY_DISABLED_ERROR_MSG);
    }

    @Override
    public void dropUser(String login) throws IgniteCheckedException {
        throw new IgniteException(SECURITY_DISABLED_ERROR_MSG);
    }

    @Override
    public void onLocalJoin() {
    }
}

