/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.schema.management;

import java.util.LinkedHashMap;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.cache.query.index.Index;
import org.apache.ignite.internal.cache.query.index.IndexName;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.QueryIndexDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.client.ClientIndexDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.client.ClientIndexFactory;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndex;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexFactory;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.query.GridQueryIndexDescriptor;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitor;
import org.apache.ignite.internal.processors.query.schema.management.AbstractIndexDescriptorFactory;
import org.apache.ignite.internal.processors.query.schema.management.IndexDescriptor;
import org.apache.ignite.internal.processors.query.schema.management.TableDescriptor;
import org.apache.ignite.internal.util.typedef.F;
import org.jetbrains.annotations.Nullable;

public class SortedIndexDescriptorFactory
extends AbstractIndexDescriptorFactory {
    private static final InlineIndexFactory SORTED_IDX_FACTORY = InlineIndexFactory.INSTANCE;
    private final IgniteLogger log;

    public SortedIndexDescriptorFactory(IgniteLogger log) {
        this.log = log;
    }

    @Override
    public IndexDescriptor create(GridKernalContext ctx, GridQueryIndexDescriptor idxDesc, TableDescriptor tbl, @Nullable SchemaIndexCacheVisitor cacheVisitor) {
        Index idx;
        GridCacheContextInfo<?, ?> cacheInfo = tbl.cacheInfo();
        GridQueryTypeDescriptor typeDesc = tbl.type();
        String idxName = idxDesc.name();
        boolean isPk = "_key_PK".equals(idxName);
        boolean isAff = "AFFINITY_KEY".equals(idxName);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating cache index [cacheId=" + cacheInfo.cacheId() + ", idxName=" + idxName + ']');
        }
        LinkedHashMap<String, IndexKeyDefinition> originalIdxCols = SortedIndexDescriptorFactory.indexDescriptorToKeysDefinition(idxDesc, typeDesc);
        LinkedHashMap<String, IndexKeyDefinition> wrappedCols = new LinkedHashMap<String, IndexKeyDefinition>(originalIdxCols);
        if (isAff || F.isEmpty(tbl.type().keyFieldName()) || !wrappedCols.containsKey(tbl.type().keyFieldAlias())) {
            SortedIndexDescriptorFactory.addKeyColumn(wrappedCols, tbl);
        }
        if (!isPk || !"_KEY".equals(tbl.affinityKey())) {
            SortedIndexDescriptorFactory.addAffinityColumn(wrappedCols, tbl);
        }
        LinkedHashMap<String, IndexKeyDefinition> unwrappedCols = new LinkedHashMap<String, IndexKeyDefinition>(originalIdxCols);
        SortedIndexDescriptorFactory.addUnwrappedKeyColumns(unwrappedCols, tbl);
        if (!isPk || !"_KEY".equals(tbl.affinityKey())) {
            SortedIndexDescriptorFactory.addAffinityColumn(unwrappedCols, tbl);
        }
        LinkedHashMap<String, IndexKeyDefinition> idxCols = unwrappedCols;
        if (cacheInfo.affinityNode()) {
            GridCacheContext<?, ?> cctx = cacheInfo.cacheContext();
            int typeId = cctx.binaryMarshaller() ? typeDesc.typeId() : typeDesc.valueClass().hashCode();
            String treeName = BPlusTree.treeName(typeId + "_" + idxName, "H2Tree");
            if (!ctx.indexProcessor().useUnwrappedPk(cctx, treeName)) {
                idxCols = wrappedCols;
            }
            QueryIndexDefinition idxDef = new QueryIndexDefinition(typeDesc, cacheInfo, new IndexName(cacheInfo.name(), typeDesc.schemaName(), typeDesc.tableName(), idxName), treeName, ctx.indexProcessor().rowCacheCleaner(cacheInfo.groupId()), isPk, isAff, idxCols, idxDesc.inlineSize(), ctx.indexProcessor().keyTypeSettings());
            idx = cacheVisitor != null ? ctx.indexProcessor().createIndexDynamically(cctx, SORTED_IDX_FACTORY, idxDef, cacheVisitor) : ctx.indexProcessor().createIndex(cctx, SORTED_IDX_FACTORY, idxDef);
        } else {
            ClientIndexDefinition d = new ClientIndexDefinition(new IndexName(tbl.cacheInfo().name(), tbl.type().schemaName(), tbl.type().tableName(), idxName), idxCols, idxDesc.inlineSize(), tbl.cacheInfo().config().getSqlIndexMaxInlineSize());
            idx = ctx.indexProcessor().createIndex(tbl.cacheInfo().cacheContext(), new ClientIndexFactory(this.log), d);
        }
        assert (idx instanceof InlineIndex) : idx;
        return new IndexDescriptor(tbl, idxName, idxDesc.type(), idxCols, isPk, isAff, ((InlineIndex)idx).inlineSize(), idx);
    }

    private static void addUnwrappedKeyColumns(LinkedHashMap<String, IndexKeyDefinition> cols, TableDescriptor tbl) {
        if (!tbl.isSql() || QueryUtils.isSqlType(tbl.type().keyClass())) {
            SortedIndexDescriptorFactory.addKeyColumn(cols, tbl);
            return;
        }
        if (!tbl.type().primaryKeyFields().isEmpty()) {
            for (String keyName : tbl.type().primaryKeyFields()) {
                cols.putIfAbsent(keyName, SortedIndexDescriptorFactory.keyDefinition(tbl.type(), keyName, true));
            }
        } else {
            boolean haveKeyFields = false;
            for (String propName : tbl.type().fields().keySet()) {
                GridQueryProperty prop = tbl.type().property(propName);
                if (!prop.key()) continue;
                cols.putIfAbsent(propName, SortedIndexDescriptorFactory.keyDefinition(tbl.type(), propName, true));
                haveKeyFields = true;
            }
            if (!haveKeyFields) {
                SortedIndexDescriptorFactory.addKeyColumn(cols, tbl);
            }
        }
    }

    private static void addKeyColumn(LinkedHashMap<String, IndexKeyDefinition> cols, TableDescriptor tbl) {
        cols.putIfAbsent("_KEY", SortedIndexDescriptorFactory.keyDefinition(tbl.type(), "_KEY", true));
    }

    private static void addAffinityColumn(LinkedHashMap<String, IndexKeyDefinition> cols, TableDescriptor tbl) {
        if (tbl.affinityKey() != null) {
            cols.putIfAbsent(tbl.affinityKey(), SortedIndexDescriptorFactory.keyDefinition(tbl.type(), tbl.affinityKey(), true));
        }
    }
}

