/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.metastorage.persistence;

import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.function.Consumer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadWriteMetastorage;
import org.apache.ignite.internal.processors.metastorage.persistence.DistributedMetaStorageClusterNodeData;
import org.apache.ignite.internal.processors.metastorage.persistence.DistributedMetaStorageHistoryItem;
import org.apache.ignite.internal.processors.metastorage.persistence.DistributedMetaStorageKeyValuePair;
import org.apache.ignite.internal.processors.metastorage.persistence.DistributedMetaStorageUtil;
import org.apache.ignite.internal.processors.metastorage.persistence.DistributedMetaStorageVersion;
import org.apache.ignite.internal.processors.metastorage.persistence.DmsLocalMetaStorageLock;
import org.apache.ignite.internal.util.lang.IgniteThrowableRunner;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.Nullable;

public class DmsDataWriterWorker
extends GridWorker {
    public static final byte[] DUMMY_VALUE = new byte[0];
    private static final Object STOP = new Object();
    private static final Object AWAIT = new Object();
    private final LinkedBlockingQueue<RunnableFuture<?>> updateQueue = new LinkedBlockingQueue();
    private final DmsLocalMetaStorageLock lock;
    private final Consumer<Throwable> errorHnd;
    private DistributedMetaStorageVersion workerDmsVer;
    private volatile ReadWriteMetastorage metastorage;
    private volatile CountDownLatch latch = new CountDownLatch(0);
    private volatile Future<?> suspendFut = CompletableFuture.completedFuture(AWAIT);

    public DmsDataWriterWorker(@Nullable String igniteInstanceName, IgniteLogger log, DmsLocalMetaStorageLock lock, Consumer<Throwable> errorHnd) {
        super(igniteInstanceName, "dms-writer", log);
        this.lock = lock;
        this.errorHnd = errorHnd;
        this.updateQueue.offer(this.newDmsTask(this::restore));
    }

    public void setMetaStorage(ReadWriteMetastorage metastorage) {
        this.metastorage = metastorage;
    }

    public void start() {
        this.isCancelled.set(false);
        new IgniteThread(this.igniteInstanceName(), "dms-writer-thread", this).start();
    }

    public Future<?> flush() {
        return this.suspendFut;
    }

    public void suspend(IgniteInternalFuture<?> compFut) {
        if (this.isCancelled()) {
            this.suspendFut = CompletableFuture.completedFuture(AWAIT);
        } else {
            this.latch = new CountDownLatch(1);
            this.suspendFut = new FutureTask<Object>(() -> AWAIT);
            this.updateQueue.offer((RunnableFuture)this.suspendFut);
            compFut.listen(f -> this.latch.countDown());
        }
    }

    public void update(DistributedMetaStorageHistoryItem histItem) {
        this.updateQueue.offer(this.newDmsTask(() -> {
            this.metastorage.write(DistributedMetaStorageUtil.historyItemKey(this.workerDmsVer.id() + 1L), histItem);
            this.workerDmsVer = this.workerDmsVer.nextVersion(histItem);
            this.metastorage.write(DistributedMetaStorageUtil.versionKey(), this.workerDmsVer);
            int len = histItem.keys().length;
            for (int i = 0; i < len; ++i) {
                this.write(histItem.keys()[i], histItem.valuesBytesArray()[i]);
            }
        }));
    }

    public void update(DistributedMetaStorageClusterNodeData fullNodeData) {
        assert (fullNodeData.fullData != null);
        assert (fullNodeData.hist != null);
        this.updateQueue.offer(this.newDmsTask(() -> {
            this.metastorage.writeRaw(DistributedMetaStorageUtil.cleanupGuardKey(), DUMMY_VALUE);
            this.doCleanup();
            for (DistributedMetaStorageKeyValuePair item : fullNodeData.fullData) {
                this.metastorage.writeRaw(DistributedMetaStorageUtil.localKey(item.key), item.valBytes);
            }
            int len = fullNodeData.hist.length;
            for (int i = 0; i < len; ++i) {
                DistributedMetaStorageHistoryItem histItem = fullNodeData.hist[i];
                long histItemVer = fullNodeData.ver.id() + (long)i - (long)(len - 1);
                this.metastorage.write(DistributedMetaStorageUtil.historyItemKey(histItemVer), histItem);
            }
            this.metastorage.write(DistributedMetaStorageUtil.versionKey(), fullNodeData.ver);
            this.workerDmsVer = fullNodeData.ver;
            this.metastorage.remove(DistributedMetaStorageUtil.cleanupGuardKey());
        }));
    }

    public void removeHistItem(long ver) {
        this.updateQueue.offer(this.newDmsTask(() -> this.metastorage.remove(DistributedMetaStorageUtil.historyItemKey(ver))));
    }

    public void cancel(boolean halt) throws InterruptedException {
        if (halt) {
            this.updateQueue.clear();
            if (this.suspendFut instanceof RunnableFuture) {
                ((Runnable)((Object)this.suspendFut)).run();
            }
        }
        this.updateQueue.offer(new FutureTask<Object>(() -> STOP));
        this.latch.countDown();
        this.isCancelled.set(true);
        Thread runner = this.runner();
        if (runner != null) {
            runner.join();
        }
    }

    @Override
    protected void body() {
        block3: while (true) {
            try {
                while (true) {
                    RunnableFuture<?> curTask = this.updateQueue.take();
                    curTask.run();
                    Object res = U.get(curTask);
                    if (res == STOP) break block3;
                    if (res != AWAIT) continue;
                    this.latch.await();
                }
            }
            catch (InterruptedException curTask) {
                continue;
            }
            catch (Throwable t) {
                this.errorHnd.accept(t);
            }
            break;
        }
    }

    private void restore() throws IgniteCheckedException {
        block3: {
            DistributedMetaStorageHistoryItem histItem;
            DistributedMetaStorageVersion storedVer;
            block5: {
                block4: {
                    block2: {
                        if (this.metastorage.readRaw(DistributedMetaStorageUtil.cleanupGuardKey()) == null) break block2;
                        this.doCleanup();
                        this.metastorage.remove(DistributedMetaStorageUtil.cleanupGuardKey());
                        break block3;
                    }
                    storedVer = (DistributedMetaStorageVersion)this.metastorage.read(DistributedMetaStorageUtil.versionKey());
                    if (storedVer != null) break block4;
                    this.workerDmsVer = DistributedMetaStorageVersion.INITIAL_VERSION;
                    this.metastorage.write(DistributedMetaStorageUtil.versionKey(), DistributedMetaStorageVersion.INITIAL_VERSION);
                    break block3;
                }
                histItem = (DistributedMetaStorageHistoryItem)this.metastorage.read(DistributedMetaStorageUtil.historyItemKey(storedVer.id() + 1L));
                if (histItem == null) break block5;
                this.workerDmsVer = storedVer.nextVersion(histItem);
                this.metastorage.write(DistributedMetaStorageUtil.versionKey(), this.workerDmsVer);
                int len = histItem.keys().length;
                for (int i = 0; i < len; ++i) {
                    this.write(histItem.keys()[i], histItem.valuesBytesArray()[i]);
                }
                break block3;
            }
            this.workerDmsVer = storedVer;
            histItem = (DistributedMetaStorageHistoryItem)this.metastorage.read(DistributedMetaStorageUtil.historyItemKey(storedVer.id()));
            if (histItem == null) break block3;
            boolean equal = true;
            int len = histItem.keys().length;
            for (int i = 0; i < len; ++i) {
                byte[] valBytes = this.metastorage.readRaw(DistributedMetaStorageUtil.localKey(histItem.keys()[i]));
                if (equal && Arrays.equals(valBytes, histItem.valuesBytesArray()[i])) continue;
                equal = false;
                this.write(histItem.keys()[i], histItem.valuesBytesArray()[i]);
            }
        }
    }

    private void doCleanup() throws IgniteCheckedException {
        HashSet allKeys = new HashSet();
        this.metastorage.iterate("\u0000", (key, val) -> allKeys.add(key), false);
        allKeys.remove(DistributedMetaStorageUtil.cleanupGuardKey());
        for (String key2 : allKeys) {
            this.metastorage.remove(key2);
        }
        this.workerDmsVer = DistributedMetaStorageVersion.INITIAL_VERSION;
        this.metastorage.write(DistributedMetaStorageUtil.versionKey(), DistributedMetaStorageVersion.INITIAL_VERSION);
    }

    private void write(String key, byte[] valBytes) throws IgniteCheckedException {
        if (valBytes == null) {
            this.metastorage.remove(DistributedMetaStorageUtil.localKey(key));
        } else {
            this.metastorage.writeRaw(DistributedMetaStorageUtil.localKey(key), valBytes);
        }
    }

    private RunnableFuture<Void> newDmsTask(IgniteThrowableRunner task) {
        return new FutureTask<Object>(() -> {
            this.lock.lock();
            try {
                task.run();
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
            finally {
                this.lock.unlock();
            }
        }, null);
    }
}

