/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cluster;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.BaselineNode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.BaselineConfigurationChangedEvent;
import org.apache.ignite.events.ClusterStateChangeStartedEvent;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.cluster.ClusterGroupAdapter;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.DistributedBaselineConfiguration;
import org.apache.ignite.internal.cluster.IgniteClusterImpl;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.IgniteDiscoverySpi;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.managers.systemview.walker.BaselineNodeAttributeViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.BaselineNodeViewWalker;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.ExchangeActions;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.GridChangeGlobalStateMessageResponse;
import org.apache.ignite.internal.processors.cache.StateChangeRequest;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadOnlyMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadWriteMetastorage;
import org.apache.ignite.internal.processors.cluster.BaselineAdjustForbiddenException;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.processors.cluster.BaselineTopologyHistory;
import org.apache.ignite.internal.processors.cluster.BaselineTopologyHistoryItem;
import org.apache.ignite.internal.processors.cluster.ChangeGlobalStateFinishMessage;
import org.apache.ignite.internal.processors.cluster.ChangeGlobalStateMessage;
import org.apache.ignite.internal.processors.cluster.ClientGetClusterStateComputeRequest;
import org.apache.ignite.internal.processors.cluster.ClientSetClusterStateComputeRequest;
import org.apache.ignite.internal.processors.cluster.DiscoveryDataClusterState;
import org.apache.ignite.internal.processors.cluster.IGridClusterStateProcessor;
import org.apache.ignite.internal.processors.cluster.baseline.autoadjust.BaselineAutoAdjustStatus;
import org.apache.ignite.internal.processors.cluster.baseline.autoadjust.BaselineTopologyUpdater;
import org.apache.ignite.internal.processors.configuration.distributed.DistributePropertyListener;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.future.IgniteFinishedFutureImpl;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.spi.IgniteNodeValidationResult;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;
import org.apache.ignite.spi.systemview.view.BaselineNodeAttributeView;
import org.apache.ignite.spi.systemview.view.BaselineNodeView;
import org.jetbrains.annotations.Nullable;

public class GridClusterStateProcessor
extends GridProcessorAdapter
implements IGridClusterStateProcessor,
MetastorageLifecycleListener {
    private static final String METASTORE_CURR_BLT_KEY = "metastoreBltKey";
    public static final String DATA_LOST_ON_DEACTIVATION_WARNING = "Deactivation stopped. Deactivation clears in-memory caches (without persistence) including the system caches.";
    public static final String BASELINE_NODES_SYS_VIEW = MetricUtils.metricName("baseline", "nodes");
    public static final String BASELINE_NODES_SYS_VIEW_DESC = "Baseline topology nodes";
    public static final String BASELINE_NODE_ATTRIBUTES_SYS_VIEW = MetricUtils.metricName("baseline", "node", "attributes");
    public static final String BASELINE_NODE_ATTRIBUTES_SYS_VIEW_DESC = "Baseline node attributes";
    private boolean inMemoryMode;
    private volatile boolean compatibilityMode;
    private volatile DiscoveryDataClusterState globalState;
    private final BaselineTopologyHistory bltHist = new BaselineTopologyHistory();
    private final AtomicReference<GridChangeGlobalStateFuture> stateChangeFut = new AtomicReference();
    private final ConcurrentMap<UUID, GridFutureAdapter<Void>> transitionFuts = new ConcurrentHashMap<UUID, GridFutureAdapter<Void>>();
    private TransitionOnJoinWaitFuture joinFut;
    @GridToStringExclude
    private GridCacheProcessor cacheProc;
    @GridToStringExclude
    private GridCacheSharedContext<?, ?> sharedCtx;
    @GridToStringExclude
    private ReadWriteMetastorage metastorage;
    private final JdkMarshaller marsh = new JdkMarshaller();
    private BaselineTopologyUpdater baselineTopologyUpdater;
    private DistributedBaselineConfiguration distributedBaselineConfiguration;
    private static final IgniteProductVersion MIN_BLT_SUPPORTING_VER = IgniteProductVersion.fromString("2.4.0");
    private final GridLocalEventListener lsr = new GridLocalEventListener(){

        @Override
        public void onEvent(Event evt) {
            assert (evt != null);
            final DiscoveryEvent e = (DiscoveryEvent)evt;
            assert (e.type() == 11 || e.type() == 12) : this;
            final GridChangeGlobalStateFuture f = (GridChangeGlobalStateFuture)GridClusterStateProcessor.this.stateChangeFut.get();
            if (f != null) {
                f.initFut.listen(new CI1<IgniteInternalFuture<?>>(){

                    @Override
                    public void apply(IgniteInternalFuture<?> fut) {
                        f.onNodeLeft(e);
                    }
                });
            }
        }
    };

    public GridClusterStateProcessor(GridKernalContext ctx) {
        super(ctx);
        ctx.internalSubscriptionProcessor().registerMetastorageListener(this);
        this.distributedBaselineConfiguration = new DistributedBaselineConfiguration(ctx.internalSubscriptionProcessor(), ctx, ctx.log(DistributedBaselineConfiguration.class));
        this.distributedBaselineConfiguration.listenAutoAdjustEnabled(this.makeEventListener(147));
        this.distributedBaselineConfiguration.listenAutoAdjustTimeout(this.makeEventListener(148));
        ctx.systemView().registerView(BASELINE_NODES_SYS_VIEW, BASELINE_NODES_SYS_VIEW_DESC, new BaselineNodeViewWalker(), this::nodeViewSupplier, Function.identity());
        ctx.systemView().registerFiltrableView(BASELINE_NODE_ATTRIBUTES_SYS_VIEW, BASELINE_NODE_ATTRIBUTES_SYS_VIEW_DESC, new BaselineNodeAttributeViewWalker(), this::nodeAttributeViewSupplier, Function.identity());
    }

    private DistributePropertyListener<Object> makeEventListener(int evtType) {
        return (name, oldVal, newVal) -> this.ctx.pools().getStripedExecutorService().execute(() -> {
            if (this.ctx.event().isRecordable(evtType)) {
                this.ctx.event().record(new BaselineConfigurationChangedEvent(this.ctx.discovery().localNode(), evtType == 147 ? "Baseline auto-adjust \"enabled\" flag has been changed" : "Baseline auto-adjust timeout has been changed", evtType, this.distributedBaselineConfiguration.isBaselineAutoAdjustEnabled(), this.distributedBaselineConfiguration.getBaselineAutoAdjustTimeout()));
            }
        });
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode node) {
        if (!this.isBaselineAutoAdjustEnabled() || this.baselineAutoAdjustTimeout() != 0L) {
            return null;
        }
        Collection<ClusterNode> nodes = this.ctx.discovery().aliveServerNodes();
        if (nodes.stream().anyMatch(serNode -> CU.isPersistenceEnabled(GridCacheUtils.extractDataStorage(serNode, this.ctx.marshallerContext().jdkMarshaller(), U.resolveClassLoader(this.ctx.config()))))) {
            return null;
        }
        DataStorageConfiguration crdDsCfg = GridCacheUtils.extractDataStorage(node, this.ctx.marshallerContext().jdkMarshaller(), U.resolveClassLoader(this.ctx.config()));
        if (!CU.isPersistenceEnabled(crdDsCfg)) {
            return null;
        }
        return new IgniteNodeValidationResult(node.id(), "Joining persistence node to in-memory cluster couldn't be allowed due to baseline auto-adjust is enabled and timeout equal to 0");
    }

    public boolean compatibilityMode() {
        return this.compatibilityMode;
    }

    @Override
    public ClusterState publicApiState(boolean waitForTransition) {
        return this.publicApiStateAsync(waitForTransition).get();
    }

    @Override
    public IgniteFuture<ClusterState> publicApiStateAsync(boolean asyncWaitForTransition) {
        if (this.ctx.isDaemon()) {
            return this.sendComputeCheckGlobalState();
        }
        DiscoveryDataClusterState globalState = this.globalState;
        assert (globalState != null);
        if (globalState.transition() && globalState.state().active()) {
            ClusterState transitionRes = globalState.transitionResult();
            if (transitionRes != null) {
                return new IgniteFinishedFutureImpl<ClusterState>(transitionRes);
            }
            GridFutureAdapter fut = (GridFutureAdapter)this.transitionFuts.get(globalState.transitionRequestId());
            if (fut != null) {
                if (asyncWaitForTransition) {
                    return new IgniteFutureImpl<ClusterState>(fut.chain(f -> {
                        ClusterState res = globalState.transitionResult();
                        assert (res != null);
                        return res;
                    }));
                }
                return new IgniteFinishedFutureImpl<ClusterState>(GridClusterStateProcessor.stateWithMinimalFeatures(globalState.lastState(), globalState.state()));
            }
            transitionRes = globalState.transitionResult();
            assert (transitionRes != null);
            return new IgniteFinishedFutureImpl<ClusterState>(transitionRes);
        }
        return new IgniteFinishedFutureImpl<ClusterState>(globalState.state());
    }

    @Override
    public boolean publicApiActiveState(boolean waitForTransition) {
        return this.publicApiActiveStateAsync(waitForTransition).get();
    }

    @Override
    public IgniteFuture<Boolean> publicApiActiveStateAsync(boolean asyncWaitForTransition) {
        return this.publicApiStateAsync(asyncWaitForTransition).chain(f -> ((ClusterState)((Object)((Object)((Object)f.get())))).active());
    }

    @Override
    public long lastStateChangeTime() {
        return this.globalState.lastStateChangeTime();
    }

    @Override
    public void onReadyForRead(ReadOnlyMetastorage metastorage) throws IgniteCheckedException {
        BaselineTopology blt = (BaselineTopology)metastorage.read(METASTORE_CURR_BLT_KEY);
        if (blt != null) {
            if (this.log.isInfoEnabled()) {
                U.log(this.log, "Restoring history for BaselineTopology[id=" + blt.id() + "]");
            }
            this.bltHist.restoreHistory(metastorage, blt.id());
        }
        this.onStateRestored(blt);
    }

    @Override
    public void onReadyForReadWrite(ReadWriteMetastorage metastorage) throws IgniteCheckedException {
        this.metastorage = metastorage;
        if (this.compatibilityMode) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BaselineTopology won't be stored as this node is running in compatibility mode");
            }
            return;
        }
        this.writeBaselineTopology(this.globalState.baselineTopology(), null);
        this.bltHist.flushHistoryItems(metastorage);
    }

    public void resetBranchingHistory(long newBranchingHash) throws IgniteCheckedException {
        if (!this.compatibilityMode()) {
            this.globalState.baselineTopology().resetBranchingHistory(newBranchingHash);
            this.writeBaselineTopology(this.globalState.baselineTopology(), null);
            U.log(this.log, String.format("Branching history of current BaselineTopology is reset to the value %d", newBranchingHash));
        }
    }

    private void writeBaselineTopology(BaselineTopology blt, BaselineTopologyHistoryItem prevBltHistItem) throws IgniteCheckedException {
        assert (this.metastorage != null);
        if (this.inMemoryMode) {
            return;
        }
        this.sharedCtx.database().checkpointReadLock();
        try {
            if (blt != null) {
                if (this.log.isInfoEnabled()) {
                    U.log(this.log, "Writing BaselineTopology[id=" + blt.id() + "]");
                    if (prevBltHistItem != null) {
                        U.log(this.log, "Writing BaselineTopologyHistoryItem[id=" + prevBltHistItem.id() + "]");
                    }
                }
                this.bltHist.writeHistoryItem(this.metastorage, prevBltHistItem);
                this.metastorage.write(METASTORE_CURR_BLT_KEY, blt);
            } else {
                if (this.log.isInfoEnabled()) {
                    U.log(this.log, "Removing BaselineTopology and history");
                }
                this.metastorage.remove(METASTORE_CURR_BLT_KEY);
                this.bltHist.removeHistory(this.metastorage);
            }
        }
        finally {
            this.sharedCtx.database().checkpointReadUnlock();
        }
    }

    @Override
    public void start() throws IgniteCheckedException {
        ClusterState stateOnStart;
        IgniteConfiguration cfg = this.ctx.config();
        boolean bl = this.inMemoryMode = !CU.isPersistenceEnabled(cfg);
        if (this.inMemoryMode) {
            stateOnStart = cfg.getClusterStateOnStart();
            boolean activeOnStartSet = this.getBooleanFieldFromConfig(cfg, "activeOnStartPropSetFlag", false);
            if (activeOnStartSet) {
                if (stateOnStart != null) {
                    this.log.warning("Property `activeOnStart` will be ignored due to the property `clusterStateOnStart` is presented.");
                } else {
                    stateOnStart = cfg.isActiveOnStart() ? ClusterState.ACTIVE : ClusterState.INACTIVE;
                }
            } else if (stateOnStart == null) {
                stateOnStart = IgniteConfiguration.DFLT_STATE_ON_START;
            }
        } else {
            stateOnStart = ClusterState.INACTIVE;
            if (cfg.getClusterStateOnStart() != null && this.getBooleanFieldFromConfig(cfg, "autoActivationPropSetFlag", false)) {
                this.log.warning("Property `autoActivation` will be ignored due to the property `clusterStateOnStart` is presented.");
            }
        }
        this.globalState = DiscoveryDataClusterState.createState(stateOnStart, null);
        this.ctx.event().addLocalEventListener(this.lsr, 11, 12);
    }

    @Override
    public void onKernalStart(boolean active) throws IgniteCheckedException {
        this.baselineTopologyUpdater = new BaselineTopologyUpdater(this.ctx);
        this.ctx.event().addLocalEventListener(event -> {
            DiscoveryEvent discoEvt = (DiscoveryEvent)event;
            if (discoEvt.eventNode().isClient() || discoEvt.eventNode().isDaemon()) {
                return;
            }
            this.baselineTopologyUpdater.triggerBaselineUpdate(discoEvt.topologyVersion());
        }, 12, 11, 10);
        this.distributedBaselineConfiguration.listenAutoAdjustEnabled((name, oldVal, newVal) -> {
            if (newVal != null && newVal.booleanValue()) {
                long topVer = this.ctx.discovery().topologyVersion();
                this.baselineTopologyUpdater.triggerBaselineUpdate(topVer);
            }
        });
    }

    @Override
    public void onKernalStop(boolean cancel) {
        GridChangeGlobalStateFuture fut = this.stateChangeFut.get();
        if (fut != null) {
            fut.onDone(new NodeStoppingException("Failed to wait for cluster state change, node is stopping."));
        }
        super.onKernalStop(cancel);
    }

    @Override
    @Nullable
    public IgniteInternalFuture<Boolean> onLocalJoin(DiscoCache discoCache) {
        boolean activation;
        DiscoveryDataClusterState state = this.globalState;
        if (state.state().active()) {
            this.checkLocalNodeInBaseline(state.baselineTopology());
        }
        if (state.transition()) {
            this.joinFut = new TransitionOnJoinWaitFuture(state, discoCache);
            return this.joinFut;
        }
        ClusterState targetState = this.ctx.config().getClusterStateOnStart();
        if (targetState == null) {
            targetState = this.ctx.config().isAutoActivationEnabled() ? ClusterState.ACTIVE : ClusterState.INACTIVE;
        }
        boolean serverNode = !this.ctx.clientNode() && !this.ctx.isDaemon();
        boolean bl = activation = !state.state().active() && targetState.active();
        if (serverNode && activation && !this.inMemoryMode && this.isBaselineSatisfied(state.baselineTopology(), discoCache.serverNodes())) {
            this.changeGlobalState(targetState, true, state.baselineTopology().currentBaseline(), false);
        }
        return null;
    }

    private void checkLocalNodeInBaseline(BaselineTopology blt) {
        if (blt == null || blt.consistentIds() == null || this.ctx.clientNode() || this.ctx.isDaemon()) {
            return;
        }
        if (!blt.consistentIds().contains(this.ctx.discovery().localNode().consistentId())) {
            U.quietAndInfo(this.log, "Local node is not included in Baseline Topology and will not be used for data storage. Use control.(sh|bat) script or IgniteCluster interface to include the node to Baseline Topology.");
        }
    }

    private boolean isBaselineSatisfied(BaselineTopology blt, List<ClusterNode> serverNodes) {
        if (blt == null) {
            return false;
        }
        if (blt.consistentIds() == null) {
            return false;
        }
        return blt.consistentIds().contains(this.ctx.discovery().localNode().consistentId()) && blt.isSatisfied(serverNodes);
    }

    @Override
    @Nullable
    public ChangeGlobalStateFinishMessage onNodeLeft(ClusterNode node) {
        Set<UUID> nodes;
        if (this.globalState.transition() && (nodes = this.globalState.transitionNodes()).remove(node.id()) && nodes.isEmpty()) {
            U.warn(this.log, "Failed to change cluster state, all participating nodes failed. Switching to inactive state.");
            ChangeGlobalStateFinishMessage msg = new ChangeGlobalStateFinishMessage(this.globalState.transitionRequestId(), ClusterState.INACTIVE, false);
            this.onStateFinishMessage(msg);
            return msg;
        }
        return null;
    }

    @Override
    public void onStateFinishMessage(ChangeGlobalStateFinishMessage msg) {
        DiscoveryDataClusterState discoClusterState = this.globalState;
        if (msg.requestId().equals(discoClusterState.transitionRequestId())) {
            GridFutureAdapter transitionFut;
            TransitionOnJoinWaitFuture joinFut;
            if (this.log.isInfoEnabled()) {
                this.log.info("Received state change finish message: " + (Object)((Object)msg.state()));
            }
            this.globalState = discoClusterState.finish(msg.success());
            this.afterStateChangeFinished(msg.id(), msg.success());
            this.ctx.cache().onStateChangeFinish(msg);
            this.ctx.durableBackgroundTask().onStateChangeFinish(msg);
            if (discoClusterState.lastState() == ClusterState.ACTIVE_READ_ONLY || this.globalState.state() == ClusterState.ACTIVE_READ_ONLY) {
                this.ctx.cache().context().readOnlyMode(this.globalState.state() == ClusterState.ACTIVE_READ_ONLY);
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Cluster state was changed from " + (Object)((Object)discoClusterState.lastState()) + " to " + (Object)((Object)this.globalState.state()));
            }
            if (!this.globalState.state().active()) {
                this.ctx.cache().context().readOnlyMode(false);
            }
            if ((joinFut = this.joinFut) != null) {
                joinFut.onDone(false);
            }
            if ((transitionFut = (GridFutureAdapter)this.transitionFuts.get(discoClusterState.transitionRequestId())) != null) {
                discoClusterState.setTransitionResult(msg.requestId(), msg.state());
                this.transitionFuts.remove(discoClusterState.transitionRequestId());
                transitionFut.onDone();
            }
        } else {
            U.warn(this.log, "Received state finish message with unexpected ID: " + msg);
        }
    }

    protected void afterStateChangeFinished(IgniteUuid msgId, boolean success) {
    }

    @Override
    public boolean onStateChangeMessage(AffinityTopologyVersion topVer, ChangeGlobalStateMessage msg, DiscoCache discoCache) {
        GridChangeGlobalStateFuture stateFut;
        DiscoveryDataClusterState state = this.globalState;
        if (this.log.isInfoEnabled()) {
            String baseline = msg.baselineTopology() == null ? ": null" : "[id=" + msg.baselineTopology().id() + ']';
            U.log(this.log, "Received " + GridClusterStateProcessor.prettyStr(msg.state()) + " request with BaselineTopology" + baseline + " initiator node ID: " + msg.initiatorNodeId());
        }
        if (msg.baselineTopology() != null) {
            this.compatibilityMode = false;
        }
        if (state.transition()) {
            if (this.isApplicable(msg, state)) {
                GridChangeGlobalStateFuture fut = this.changeStateFuture(msg);
                if (fut != null) {
                    fut.onDone(this.concurrentStateChangeError(msg.state(), state.state()));
                }
            } else {
                stateFut = this.changeStateFuture(msg);
                GridFutureAdapter transitionFut = (GridFutureAdapter)this.transitionFuts.get(state.transitionRequestId());
                if (stateFut != null && transitionFut != null) {
                    transitionFut.listen(new IgniteInClosure<IgniteInternalFuture<Void>>(){

                        @Override
                        public void apply(IgniteInternalFuture<Void> fut) {
                            try {
                                fut.get();
                                stateFut.onDone();
                            }
                            catch (Exception ex) {
                                stateFut.onDone(ex);
                            }
                        }
                    });
                }
            }
        } else {
            if (this.isApplicable(msg, state)) {
                ExchangeActions exchangeActions;
                List<String> inMemCaches;
                if (msg.state() == ClusterState.INACTIVE && !msg.forceDeactivation() && IgniteFeatures.allNodesSupports(this.ctx.discovery().serverNodes(topVer), IgniteFeatures.SAFE_CLUSTER_DEACTIVATION) && !(inMemCaches = this.listInMemoryUserCaches()).isEmpty()) {
                    GridChangeGlobalStateFuture stateFut2 = this.changeStateFuture(msg);
                    if (stateFut2 != null) {
                        stateFut2.onDone(new IgniteException("Deactivation stopped. Deactivation clears in-memory caches (without persistence) including the system caches. In memory caches: " + inMemCaches + " .To deactivate cluster pass '--force' flag."));
                    }
                    return false;
                }
                try {
                    exchangeActions = this.ctx.cache().onStateChangeRequest(msg, topVer, state);
                }
                catch (IgniteCheckedException e) {
                    GridChangeGlobalStateFuture fut = this.changeStateFuture(msg);
                    if (fut != null) {
                        fut.onDone(e);
                    }
                    return false;
                }
                HashSet<UUID> nodeIds = U.newHashSet(discoCache.allNodes().size());
                for (ClusterNode node : discoCache.allNodes()) {
                    nodeIds.add(node.id());
                }
                GridChangeGlobalStateFuture fut = this.changeStateFuture(msg);
                if (fut != null) {
                    fut.setRemaining(nodeIds, topVer.nextMinorVersion());
                }
                if (this.log.isInfoEnabled()) {
                    this.log.info("Started state transition: " + GridClusterStateProcessor.prettyStr(msg.state()));
                }
                BaselineTopologyHistoryItem bltHistItem = BaselineTopologyHistoryItem.fromBaseline(state.baselineTopology());
                this.transitionFuts.put(msg.requestId(), new GridFutureAdapter());
                DiscoveryDataClusterState newState = this.globalState = DiscoveryDataClusterState.createTransitionState(msg.state(), state, this.activate(state.state(), msg.state()) || msg.forceChangeBaselineTopology() ? msg.baselineTopology() : state.baselineTopology(), msg.requestId(), topVer, nodeIds);
                this.ctx.durableBackgroundTask().onStateChangeStarted(msg);
                if (msg.forceChangeBaselineTopology()) {
                    newState.setTransitionResult(msg.requestId(), msg.state());
                }
                AffinityTopologyVersion stateChangeTopVer = topVer.nextMinorVersion();
                StateChangeRequest req = new StateChangeRequest(msg, bltHistItem, state.state(), stateChangeTopVer);
                exchangeActions.stateChangeRequest(req);
                msg.exchangeActions(exchangeActions);
                if (newState.state() != state.state() && this.ctx.event().isRecordable(145)) {
                    this.ctx.pools().getStripedExecutorService().execute(() -> this.ctx.event().record(new ClusterStateChangeStartedEvent(state.state(), newState.state(), this.ctx.discovery().localNode(), "Cluster state change started.")));
                }
                return true;
            }
            stateFut = this.changeStateFuture(msg);
            if (stateFut != null) {
                stateFut.onDone();
            }
        }
        return false;
    }

    protected boolean isApplicable(ChangeGlobalStateMessage msg, DiscoveryDataClusterState state) {
        return !GridClusterStateProcessor.isEquivalent(msg, state);
    }

    protected static boolean isEquivalent(ChangeGlobalStateMessage msg, DiscoveryDataClusterState state) {
        return msg.state() == state.state() && BaselineTopology.equals(msg.baselineTopology(), state.baselineTopology());
    }

    @Override
    public DiscoveryDataClusterState clusterState() {
        return this.globalState;
    }

    @Override
    public DiscoveryDataClusterState pendingState(ChangeGlobalStateMessage stateMsg) {
        ClusterState state = stateMsg.state().active() ? stateMsg.state() : (stateMsg.forceChangeBaselineTopology() ? ClusterState.ACTIVE : ClusterState.INACTIVE);
        return DiscoveryDataClusterState.createState(state, stateMsg.baselineTopology());
    }

    @Nullable
    private GridChangeGlobalStateFuture changeStateFuture(ChangeGlobalStateMessage msg) {
        return this.changeStateFuture(msg.initiatorNodeId(), msg.requestId());
    }

    @Nullable
    private GridChangeGlobalStateFuture changeStateFuture(UUID initiatorNode, UUID reqId) {
        GridChangeGlobalStateFuture fut;
        assert (initiatorNode != null);
        assert (reqId != null);
        if (initiatorNode.equals(this.ctx.localNodeId()) && (fut = this.stateChangeFut.get()) != null && fut.requestId.equals(reqId)) {
            return fut;
        }
        return null;
    }

    protected IgniteCheckedException concurrentStateChangeError(ClusterState state, ClusterState transitionState) {
        return new IgniteCheckedException("Failed to " + GridClusterStateProcessor.prettyStr(state) + ", because another state change operation is currently in progress: " + GridClusterStateProcessor.prettyStr(transitionState));
    }

    @Override
    public void cacheProcessorStarted() {
        this.cacheProc = this.ctx.cache();
        this.sharedCtx = this.cacheProc.context();
        this.sharedCtx.io().addCacheHandler(0, GridChangeGlobalStateMessageResponse.class, this::processChangeGlobalStateResponse);
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        super.stop(cancel);
        if (this.sharedCtx != null) {
            this.sharedCtx.io().removeHandler(false, 0, GridChangeGlobalStateMessageResponse.class);
        }
        this.ctx.event().removeLocalEventListener(this.lsr, 11, 12);
        IgniteCheckedException stopErr = new IgniteCheckedException("Node is stopping: " + this.ctx.igniteInstanceName());
        GridChangeGlobalStateFuture f = this.stateChangeFut.get();
        if (f != null) {
            f.onDone(stopErr);
        }
    }

    @Override
    @Nullable
    public GridComponent.DiscoveryDataExchangeType discoveryDataType() {
        return GridComponent.DiscoveryDataExchangeType.STATE_PROC;
    }

    @Override
    public void collectJoiningNodeData(DiscoveryDataBag dataBag) {
        try {
            byte[] marshalledState = this.marsh.marshal(this.globalState);
            dataBag.addJoiningNodeData(this.discoveryDataType().ordinal(), (Serializable)marshalledState);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    public void collectGridNodeData(DiscoveryDataBag dataBag) {
        DiscoveryDataBag.JoiningNodeDiscoveryData joiningNodeData = dataBag.newJoinerDiscoveryData(GridComponent.DiscoveryDataExchangeType.STATE_PROC.ordinal());
        if (joiningNodeData != null && !joiningNodeData.hasJoiningNodeData()) {
            this.compatibilityMode = true;
        }
        if (dataBag.commonDataCollectedFor(GridComponent.DiscoveryDataExchangeType.STATE_PROC.ordinal()) || joiningNodeData == null) {
            return;
        }
        if (!joiningNodeData.hasJoiningNodeData() || this.compatibilityMode) {
            dataBag.addGridCommonData(GridComponent.DiscoveryDataExchangeType.STATE_PROC.ordinal(), this.globalState);
            return;
        }
        DiscoveryDataClusterState joiningNodeState = null;
        try {
            if (joiningNodeData.joiningNodeData() != null) {
                joiningNodeState = (DiscoveryDataClusterState)this.marsh.unmarshal((byte[])joiningNodeData.joiningNodeData(), U.resolveClassLoader(this.ctx.config()));
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to unmarshal disco data from joining node: " + joiningNodeData.joiningNodeId());
            return;
        }
        BaselineTopologyHistory historyToSend = null;
        if (!this.bltHist.isEmpty()) {
            if (joiningNodeState != null && joiningNodeState.baselineTopology() != null) {
                int lastId = joiningNodeState.baselineTopology().id();
                historyToSend = this.bltHist.tailFrom(lastId);
            } else {
                historyToSend = this.bltHist;
            }
        }
        dataBag.addGridCommonData(GridComponent.DiscoveryDataExchangeType.STATE_PROC.ordinal(), new BaselineStateAndHistoryData(this.globalState, historyToSend));
    }

    @Override
    public void onGridDataReceived(DiscoveryDataBag.GridDiscoveryData data) {
        if (data.commonData() instanceof DiscoveryDataClusterState) {
            if (this.globalState != null && this.globalState.baselineTopology() != null) {
                throw new IgniteException("Node with BaselineTopology cannot join mixed cluster running in compatibility mode");
            }
            this.globalState = (DiscoveryDataClusterState)data.commonData();
            this.compatibilityMode = true;
            this.ctx.cache().context().readOnlyMode(this.globalState.state() == ClusterState.ACTIVE_READ_ONLY);
            return;
        }
        BaselineStateAndHistoryData stateDiscoData = (BaselineStateAndHistoryData)data.commonData();
        if (stateDiscoData != null) {
            DiscoveryDataClusterState state = stateDiscoData.globalState;
            if (state.transition()) {
                this.transitionFuts.put(state.transitionRequestId(), new GridFutureAdapter());
            }
            this.globalState = state;
            if (stateDiscoData.recentHistory != null) {
                for (BaselineTopologyHistoryItem item : stateDiscoData.recentHistory.history()) {
                    this.bltHist.bufferHistoryItemForStore(item);
                }
            }
            this.ctx.cache().context().readOnlyMode(this.globalState.state() == ClusterState.ACTIVE_READ_ONLY);
        }
    }

    @Override
    public IgniteInternalFuture<?> changeGlobalState(ClusterState state, boolean forceDeactivation, Collection<? extends BaselineNode> baselineNodes, boolean forceChangeBaselineTopology) {
        return this.changeGlobalState(state, forceDeactivation, baselineNodes, forceChangeBaselineTopology, false);
    }

    private BaselineTopology calculateNewBaselineTopology(ClusterState state, Collection<? extends BaselineNode> baselineNodes, boolean forceChangeBaselineTopology) {
        BaselineTopology newBlt;
        BaselineTopology currBlt = this.globalState.baselineTopology();
        int newBltId = 0;
        if (currBlt != null) {
            int n = newBltId = state.active() ? currBlt.id() + 1 : currBlt.id();
        }
        if (baselineNodes != null && !baselineNodes.isEmpty()) {
            ArrayList<? extends BaselineNode> baselineNodes0 = new ArrayList<BaselineNode>();
            for (BaselineNode baselineNode : baselineNodes) {
                if (baselineNode instanceof ClusterNode) {
                    ClusterNode clusterNode = (ClusterNode)baselineNode;
                    if (clusterNode.isClient() || clusterNode.isDaemon()) continue;
                    baselineNodes0.add(baselineNode);
                    continue;
                }
                baselineNodes0.add(baselineNode);
            }
            baselineNodes = baselineNodes0;
        }
        if (forceChangeBaselineTopology) {
            newBlt = BaselineTopology.build(baselineNodes, newBltId);
        } else if (state.active()) {
            if (baselineNodes == null) {
                baselineNodes = this.baselineNodes();
            }
            if (currBlt == null) {
                newBlt = BaselineTopology.build(baselineNodes, newBltId);
            } else {
                newBlt = currBlt;
                newBlt.updateHistory(baselineNodes);
            }
        } else {
            newBlt = null;
        }
        return newBlt;
    }

    private Collection<BaselineNode> baselineNodes() {
        List<ClusterNode> clNodes = this.ctx.discovery().serverNodes(AffinityTopologyVersion.NONE);
        ArrayList<BaselineNode> bltNodes = new ArrayList<BaselineNode>(clNodes.size());
        for (ClusterNode clNode : clNodes) {
            bltNodes.add(clNode);
        }
        return bltNodes;
    }

    public IgniteInternalFuture<?> changeGlobalState(ClusterState state, boolean forceDeactivation, Collection<? extends BaselineNode> baselineNodes, boolean forceChangeBaselineTopology, boolean isAutoAdjust) {
        if (this.ctx.maintenanceRegistry().isMaintenanceMode()) {
            return new GridFinishedFuture(new IgniteCheckedException("Failed to " + GridClusterStateProcessor.prettyStr(state) + " (node is in maintenance mode)."));
        }
        BaselineTopology blt = this.compatibilityMode && !forceChangeBaselineTopology ? null : this.calculateNewBaselineTopology(state, baselineNodes, forceChangeBaselineTopology);
        boolean isBaselineAutoAdjustEnabled = this.isBaselineAutoAdjustEnabled();
        if (forceChangeBaselineTopology && isBaselineAutoAdjustEnabled != isAutoAdjust) {
            throw new BaselineAdjustForbiddenException(isBaselineAutoAdjustEnabled);
        }
        if (this.ctx.isDaemon() || this.ctx.clientNode()) {
            return this.sendComputeChangeGlobalState(state, forceDeactivation, blt, forceChangeBaselineTopology);
        }
        if (this.cacheProc.transactions().tx() != null || this.sharedCtx.lockedTopologyVersion(null) != null) {
            return new GridFinishedFuture(new IgniteCheckedException("Failed to " + GridClusterStateProcessor.prettyStr(state) + " (must invoke the method outside of an active transaction)."));
        }
        DiscoveryDataClusterState curState = this.globalState;
        if (!(curState.transition() || curState.state() != state || state.active() && !BaselineTopology.equals(curState.baselineTopology(), blt))) {
            return new GridFinishedFuture();
        }
        GridChangeGlobalStateFuture startedFut = null;
        GridChangeGlobalStateFuture fut = this.stateChangeFut.get();
        while (fut == null || fut.isDone()) {
            fut = new GridChangeGlobalStateFuture(UUID.randomUUID(), state, this.ctx);
            if (this.stateChangeFut.compareAndSet(null, fut)) {
                startedFut = fut;
                break;
            }
            fut = this.stateChangeFut.get();
        }
        if (startedFut == null) {
            if (fut.state != state) {
                return new GridFinishedFuture(new IgniteCheckedException("Failed to " + GridClusterStateProcessor.prettyStr(state) + ", because another state change operation is currently in progress: " + GridClusterStateProcessor.prettyStr(fut.state)));
            }
            return fut;
        }
        List<StoredCacheData> storedCfgs = null;
        if (this.activate(curState.state(), state) && !this.inMemoryMode) {
            try {
                Map<String, StoredCacheData> cfgs = this.ctx.cache().configManager().readCacheConfigurations();
                if (!F.isEmpty(cfgs)) {
                    storedCfgs = new ArrayList<StoredCacheData>(cfgs.values());
                    IgniteDiscoverySpi spi = (IgniteDiscoverySpi)this.ctx.discovery().getInjectedDiscoverySpi();
                    boolean splittedCacheCfgs = spi.allNodesSupport(IgniteFeatures.SPLITTED_CACHE_CONFIGURATIONS);
                    storedCfgs = storedCfgs.stream().map(storedCacheData -> splittedCacheCfgs ? storedCacheData.withSplittedCacheConfig(this.ctx.cache().splitter()) : storedCacheData.withOldCacheConfig(this.ctx.cache().enricher())).collect(Collectors.toList());
                }
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to read stored cache configurations: " + e, e);
                startedFut.onDone(e);
                return startedFut;
            }
        }
        ChangeGlobalStateMessage msg = new ChangeGlobalStateMessage(startedFut.requestId, this.ctx.localNodeId(), storedCfgs, state, forceDeactivation, blt, forceChangeBaselineTopology, System.currentTimeMillis());
        IgniteInternalFuture<?> resFut = this.wrapStateChangeFuture(startedFut, msg);
        try {
            U.log(this.log, "Sending " + GridClusterStateProcessor.prettyStr(state) + " request with BaselineTopology " + blt);
            this.ctx.discovery().sendCustomEvent(msg);
            if (this.ctx.isStopping()) {
                startedFut.onDone(new IgniteCheckedException("Failed to execute " + GridClusterStateProcessor.prettyStr(state) + " request , node is stopping."));
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to send global state change request: " + GridClusterStateProcessor.prettyStr(state), e);
            startedFut.onDone(e);
        }
        return resFut;
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode node, DiscoveryDataBag.JoiningNodeDiscoveryData discoData) {
        DiscoveryDataClusterState joiningNodeState;
        if (node.isClient() || node.isDaemon()) {
            return null;
        }
        if (this.globalState.state() == ClusterState.ACTIVE_READ_ONLY && !IgniteFeatures.nodeSupports(node, IgniteFeatures.CLUSTER_READ_ONLY_MODE)) {
            String msg = "Node not supporting cluster read-only mode is not allowed to join the cluster with enabled read-only mode";
            return new IgniteNodeValidationResult(node.id(), msg, msg);
        }
        if (discoData.joiningNodeData() == null) {
            if (this.globalState.baselineTopology() != null) {
                String msg = "Node not supporting BaselineTopology is not allowed to join the cluster with BaselineTopology";
                return new IgniteNodeValidationResult(node.id(), msg);
            }
            return null;
        }
        try {
            joiningNodeState = (DiscoveryDataClusterState)this.marsh.unmarshal((byte[])discoData.joiningNodeData(), U.resolveClassLoader(this.ctx.config()));
        }
        catch (IgniteCheckedException e) {
            String msg = "Error on unmarshalling discovery data from node " + node.consistentId() + ": " + e.getMessage() + "; node is not allowed to join";
            return new IgniteNodeValidationResult(node.id(), msg);
        }
        if (joiningNodeState == null || joiningNodeState.baselineTopology() == null) {
            return null;
        }
        if ((this.globalState == null || this.globalState.baselineTopology() == null) && joiningNodeState != null && joiningNodeState.baselineTopology() != null) {
            String msg = "Node with set up BaselineTopology is not allowed to join cluster without one: " + node.consistentId();
            return new IgniteNodeValidationResult(node.id(), msg);
        }
        if (this.globalState.transition() && this.globalState.previousBaselineTopology() == null) {
            String msg = "Node with set up BaselineTopology is not allowed to join cluster in the process of first activation: " + node.consistentId();
            return new IgniteNodeValidationResult(node.id(), msg);
        }
        BaselineTopology clusterBlt = this.globalState.transition() ? this.globalState.previousBaselineTopology() : this.globalState.baselineTopology();
        BaselineTopology joiningNodeBlt = joiningNodeState.baselineTopology();
        String recommendation = " Consider cleaning persistent storage of the node and adding it to the cluster again.";
        if (joiningNodeBlt.id() > clusterBlt.id()) {
            String msg = "BaselineTopology of joining node (" + node.consistentId() + ") is not compatible with BaselineTopology in the cluster. Joining node BlT id (" + joiningNodeBlt.id() + ") is greater than cluster BlT id (" + clusterBlt.id() + "). New BaselineTopology was set on joining node with set-baseline command." + recommendation;
            return new IgniteNodeValidationResult(node.id(), msg);
        }
        if (joiningNodeBlt.id() == clusterBlt.id()) {
            if (!clusterBlt.isCompatibleWith(joiningNodeBlt)) {
                String msg = "BaselineTopology of joining node (" + node.consistentId() + ") is not compatible with BaselineTopology in the cluster. Branching history of cluster BlT (" + clusterBlt.branchingHistory() + ") doesn't contain branching point hash of joining node BlT (" + joiningNodeBlt.branchingPointHash() + ")." + recommendation;
                return new IgniteNodeValidationResult(node.id(), msg);
            }
        } else if (joiningNodeBlt.id() < clusterBlt.id() && !this.bltHist.isCompatibleWith(joiningNodeBlt)) {
            String msg = "BaselineTopology of joining node (" + node.consistentId() + ") is not compatible with BaselineTopology in the cluster. BlT id of joining node (" + joiningNodeBlt.id() + ") less than BlT id of cluster (" + clusterBlt.id() + ") but cluster's BaselineHistory doesn't contain branching point hash of joining node BlT (" + joiningNodeBlt.branchingPointHash() + ")." + recommendation;
            return new IgniteNodeValidationResult(node.id(), msg);
        }
        return null;
    }

    protected IgniteInternalFuture<?> wrapStateChangeFuture(IgniteInternalFuture fut, ChangeGlobalStateMessage msg) {
        return fut;
    }

    private IgniteInternalFuture<Void> sendComputeChangeGlobalState(ClusterState state, boolean forceDeactivation, BaselineTopology blt, boolean forceBlt) {
        AffinityTopologyVersion topVer = this.ctx.discovery().topologyVersionEx();
        U.log(this.log, "Sending " + GridClusterStateProcessor.prettyStr(state) + " request from node [id=" + this.ctx.localNodeId() + ", topVer=" + topVer + ", client=" + this.ctx.clientNode() + ", daemon=" + this.ctx.isDaemon() + "]");
        IgniteCompute comp = ((ClusterGroupAdapter)this.ctx.cluster().get().forServers()).compute();
        IgniteFuture<Void> fut = comp.runAsync(new ClientSetClusterStateComputeRequest(state, forceDeactivation, blt, forceBlt));
        return ((IgniteFutureImpl)fut).internalFuture();
    }

    private IgniteFuture<ClusterState> sendComputeCheckGlobalState() {
        ClusterGroupAdapter clusterGroupAdapter;
        AffinityTopologyVersion topVer = this.ctx.discovery().topologyVersionEx();
        if (this.log.isInfoEnabled()) {
            this.log.info("Sending check cluster state request from node [id=" + this.ctx.localNodeId() + ", topVer=" + topVer + ", client=" + this.ctx.clientNode() + ", daemon " + this.ctx.isDaemon() + "]");
        }
        if (F.isEmpty((clusterGroupAdapter = (ClusterGroupAdapter)this.ctx.cluster().get().forServers()).nodes())) {
            return new IgniteFinishedFutureImpl<ClusterState>(ClusterState.INACTIVE);
        }
        return clusterGroupAdapter.compute().callAsync(new ClientGetClusterStateComputeRequest());
    }

    @Override
    public void onStateChangeError(Map<UUID, Exception> errs, StateChangeRequest req) {
        GridChangeGlobalStateFuture fut;
        assert (!F.isEmpty(errs));
        if (req.activeChanged() && req.activate()) {
            try {
                this.cacheProc.onKernalStopCaches(true);
                this.cacheProc.stopCaches(true);
                this.sharedCtx.affinity().clearGroupHoldersAndRegistry();
                if (!this.ctx.clientNode()) {
                    this.sharedCtx.deactivate();
                }
            }
            catch (Exception e) {
                U.error(this.log, "Failed to revert activation request changes", e);
            }
        }
        if ((fut = this.changeStateFuture(req.initiatorNodeId(), req.requestId())) != null) {
            IgniteCheckedException e = new IgniteCheckedException("Failed to " + GridClusterStateProcessor.prettyStr(req.state()), null, false);
            for (Map.Entry<UUID, Exception> entry : errs.entrySet()) {
                e.addSuppressed(entry.getValue());
            }
            fut.onDone(e);
        }
    }

    private void onFinalActivate(final StateChangeRequest req) {
        this.ctx.dataStructures().onBeforeActivate();
        this.checkLocalNodeInBaseline(this.globalState.baselineTopology());
        this.ctx.closure().runLocalSafe(new GridPlainRunnable(){

            @Override
            public void run() {
                boolean client = GridClusterStateProcessor.this.ctx.clientNode();
                try {
                    GridClusterStateProcessor.this.ctx.dataStructures().onActivate(GridClusterStateProcessor.this.ctx);
                    GridClusterStateProcessor.this.ctx.task().onActivate(GridClusterStateProcessor.this.ctx);
                    GridClusterStateProcessor.this.ctx.encryption().onActivate(GridClusterStateProcessor.this.ctx);
                    GridClusterStateProcessor.this.distributedBaselineConfiguration.onActivate();
                    if (GridClusterStateProcessor.this.log.isInfoEnabled()) {
                        GridClusterStateProcessor.this.log.info("Successfully performed final activation steps [nodeId=" + GridClusterStateProcessor.this.ctx.localNodeId() + ", client=" + client + ", topVer=" + req.topologyVersion() + "]");
                    }
                }
                catch (Exception ex) {
                    throw new IgniteException(ex);
                }
            }
        });
    }

    @Override
    public void onStateChangeExchangeDone(StateChangeRequest req) {
        try {
            if (req.activeChanged()) {
                if (req.state().active()) {
                    this.onFinalActivate(req);
                }
                this.globalState.setTransitionResult(req.requestId(), req.state());
            }
            this.sendChangeGlobalStateResponse(req.requestId(), req.initiatorNodeId(), null);
        }
        catch (Exception ex) {
            IgniteCheckedException e = new IgniteCheckedException("Failed to perform final activation steps", ex);
            U.error(this.log, "Failed to perform final activation steps [nodeId=" + this.ctx.localNodeId() + ", client=" + this.ctx.clientNode() + ", topVer=" + req.topologyVersion() + "]. New state: " + (Object)((Object)req.state()), ex);
            this.sendChangeGlobalStateResponse(req.requestId(), req.initiatorNodeId(), e);
        }
    }

    @Override
    public void onBaselineTopologyChanged(BaselineTopology blt, BaselineTopologyHistoryItem prevBltHistItem) throws IgniteCheckedException {
        if (this.compatibilityMode) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BaselineTopology won't be stored as this node is running in compatibility mode");
            }
            return;
        }
        this.writeBaselineTopology(blt, prevBltHistItem);
    }

    private void sendChangeGlobalStateResponse(UUID reqId, UUID initNodeId, Exception ex) {
        assert (reqId != null);
        assert (initNodeId != null);
        GridChangeGlobalStateMessageResponse res = new GridChangeGlobalStateMessageResponse(reqId, ex);
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Sending global state change response [nodeId=" + this.ctx.localNodeId() + ", topVer=" + this.ctx.discovery().topologyVersionEx() + ", res=" + res + "]");
            }
            if (this.ctx.localNodeId().equals(initNodeId)) {
                this.processChangeGlobalStateResponse(this.ctx.localNodeId(), res);
            } else {
                this.sharedCtx.io().send(initNodeId, (GridCacheMessage)res, (byte)2);
            }
        }
        catch (ClusterTopologyCheckedException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to send change global state response, node left [node=" + initNodeId + ", res=" + res + ']');
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to send change global state response [node=" + initNodeId + ", res=" + res + ']', e);
        }
    }

    private void processChangeGlobalStateResponse(final UUID nodeId, final GridChangeGlobalStateMessageResponse msg) {
        assert (nodeId != null);
        assert (msg != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received activation response [requestId=" + msg.getRequestId() + ", nodeId=" + nodeId + "]");
        }
        UUID requestId = msg.getRequestId();
        final GridChangeGlobalStateFuture fut = this.stateChangeFut.get();
        if (fut != null && requestId.equals(fut.requestId)) {
            if (fut.initFut.isDone()) {
                fut.onResponse(nodeId, msg);
            } else {
                fut.initFut.listen(new CI1<IgniteInternalFuture<?>>(){

                    @Override
                    public void apply(IgniteInternalFuture<?> f) {
                        GridClusterStateProcessor.this.ctx.pools().getSystemExecutorService().execute(new Runnable(){

                            @Override
                            public void run() {
                                fut.onResponse(nodeId, msg);
                            }
                        });
                    }
                });
            }
        }
    }

    private void onStateRestored(BaselineTopology blt) {
        DiscoveryDataClusterState state = this.globalState;
        if (!state.state().active() && !state.transition() && state.baselineTopology() == null) {
            this.globalState = DiscoveryDataClusterState.createState(ClusterState.INACTIVE, blt);
        }
    }

    public boolean autoAdjustInMemoryClusterState(UUID nodeId, Collection<ClusterNode> topSnapshot, DiscoCache discoCache, long topVer, int minorTopVer) {
        boolean autoAdjustBaseline;
        IgniteClusterImpl cluster = this.ctx.cluster().get();
        DiscoveryDataClusterState oldState = this.globalState;
        boolean isInMemoryCluster = CU.isInMemoryCluster(this.ctx.discovery().allNodes(), this.ctx.marshallerContext().jdkMarshaller(), U.resolveClassLoader(this.ctx.config()));
        boolean bl = autoAdjustBaseline = isInMemoryCluster && oldState.state().active() && !oldState.transition() && cluster.isBaselineAutoAdjustEnabled() && cluster.baselineAutoAdjustTimeout() == 0L;
        if (autoAdjustBaseline) {
            BaselineTopology oldBlt = oldState.baselineTopology();
            Collection bltNodes = topSnapshot.stream().filter(n -> !n.isClient() && !n.isDaemon()).collect(Collectors.toList());
            if (!bltNodes.isEmpty()) {
                int newBltId = oldBlt == null ? 0 : oldBlt.id();
                BaselineTopology newBlt = BaselineTopology.build(bltNodes, newBltId);
                ChangeGlobalStateMessage changeGlobalStateMsg = new ChangeGlobalStateMessage(nodeId, nodeId, null, oldState.state(), true, newBlt, true, System.currentTimeMillis());
                AffinityTopologyVersion ver = new AffinityTopologyVersion(topVer, minorTopVer);
                this.onStateChangeMessage(ver, changeGlobalStateMsg, discoCache);
                ChangeGlobalStateFinishMessage finishMsg = new ChangeGlobalStateFinishMessage(nodeId, oldState.state(), true);
                this.onStateFinishMessage(finishMsg);
                this.globalState.localBaselineAutoAdjustment(true);
                return true;
            }
        }
        return false;
    }

    public ExchangeActions autoAdjustExchangeActions(ExchangeActions exchActs) {
        DiscoveryDataClusterState clusterState = this.globalState;
        if (clusterState.localBaselineAutoAdjustment()) {
            BaselineTopology blt = clusterState.baselineTopology();
            ChangeGlobalStateMessage msg = new ChangeGlobalStateMessage(UUID.randomUUID(), this.ctx.localNodeId(), null, clusterState.state().active() ? clusterState.state() : ClusterState.ACTIVE, true, blt, true, System.currentTimeMillis());
            StateChangeRequest stateChangeReq = new StateChangeRequest(msg, BaselineTopologyHistoryItem.fromBaseline(blt), msg.state(), null);
            if (exchActs == null) {
                exchActs = new ExchangeActions();
            }
            exchActs.stateChangeRequest(stateChangeReq);
        }
        return exchActs;
    }

    @Override
    public void onExchangeFinishedOnCoordinator(IgniteInternalFuture exchangeFuture, boolean hasMovingPartitions) {
    }

    @Override
    public boolean evictionsAllowed() {
        return true;
    }

    public boolean isBaselineAutoAdjustEnabled() {
        return this.distributedBaselineConfiguration.isBaselineAutoAdjustEnabled();
    }

    public void baselineAutoAdjustEnabled(boolean baselineAutoAdjustEnabled) {
        this.baselineAutoAdjustEnabledAsync(baselineAutoAdjustEnabled).get();
    }

    public IgniteFuture<?> baselineAutoAdjustEnabledAsync(boolean baselineAutoAdjustEnabled) {
        try {
            return new IgniteFutureImpl(this.distributedBaselineConfiguration.updateBaselineAutoAdjustEnabledAsync(baselineAutoAdjustEnabled));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    public long baselineAutoAdjustTimeout() {
        return this.distributedBaselineConfiguration.getBaselineAutoAdjustTimeout();
    }

    public void baselineAutoAdjustTimeout(long baselineAutoAdjustTimeout) {
        this.baselineAutoAdjustTimeoutAsync(baselineAutoAdjustTimeout).get();
    }

    public IgniteFuture<?> baselineAutoAdjustTimeoutAsync(long baselineAutoAdjustTimeout) {
        A.ensure(baselineAutoAdjustTimeout >= 0L, "timeout should be positive or zero");
        try {
            return new IgniteFutureImpl(this.distributedBaselineConfiguration.updateBaselineAutoAdjustTimeoutAsync(baselineAutoAdjustTimeout));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    public DistributedBaselineConfiguration baselineConfiguration() {
        return this.distributedBaselineConfiguration;
    }

    public BaselineAutoAdjustStatus baselineAutoAdjustStatus() {
        return this.baselineTopologyUpdater.getStatus();
    }

    private static String prettyStr(ClusterState state) {
        switch (state) {
            case ACTIVE: {
                return "activate cluster";
            }
            case INACTIVE: {
                return "deactivate cluster";
            }
            case ACTIVE_READ_ONLY: {
                return "activate cluster in read-only mode";
            }
        }
        throw new IllegalStateException("Unknown cluster state: " + (Object)((Object)state));
    }

    private boolean activate(ClusterState state, ClusterState newState) {
        assert (state != null);
        assert (newState != null);
        return state == ClusterState.INACTIVE && newState.active();
    }

    private boolean getBooleanFieldFromConfig(IgniteConfiguration cfg, String fieldName, boolean defaultValue) {
        block4: {
            A.notNull(cfg, "cfg");
            A.notNull(fieldName, "fieldName");
            Field field = U.findField(IgniteConfiguration.class, fieldName);
            try {
                if (field == null) break block4;
                field.setAccessible(true);
                boolean val = defaultValue;
                try {
                    val = field.getBoolean(cfg);
                }
                catch (IllegalAccessException | IllegalArgumentException | NullPointerException e) {
                    this.log.error("Can't get value of field with name " + fieldName + " from config: " + cfg, e);
                }
                return val;
            }
            catch (SecurityException e) {
                this.log.error("Can't get field with name " + fieldName + " from config: " + cfg + " due to security reasons", e);
            }
        }
        return defaultValue;
    }

    private Collection<BaselineNodeView> nodeViewSupplier() {
        BaselineTopology blt = this.globalState.baselineTopology();
        if (blt == null) {
            return Collections.emptyList();
        }
        Set<Object> consistentIds = blt.consistentIds();
        ArrayList<BaselineNodeView> rows = new ArrayList<BaselineNodeView>(consistentIds.size());
        Collection<ClusterNode> srvNodes = this.ctx.discovery().aliveServerNodes();
        HashSet<Object> aliveNodeIds = new HashSet<Object>(F.nodeConsistentIds(srvNodes));
        for (Object consistentId : consistentIds) {
            rows.add(new BaselineNodeView(consistentId, aliveNodeIds.contains(consistentId)));
        }
        return rows;
    }

    private Iterable<BaselineNodeAttributeView> nodeAttributeViewSupplier(Map<String, Object> filter) {
        String nodeConsistentId = (String)filter.get("nodeConsistentId");
        String attrName = (String)filter.get("name");
        BaselineTopology blt = this.globalState.baselineTopology();
        if (blt == null) {
            return Collections.emptyList();
        }
        return F.flat(F.iterator(blt.currentBaseline(), node -> {
            Map<String, Object> attrs = node.attributes();
            if (nodeConsistentId != null && !nodeConsistentId.equals(IgniteUtils.toStringSafe(node.consistentId()))) {
                return Collections.emptyList();
            }
            if (attrName != null) {
                Object attrVal = attrs.get(attrName);
                if (attrVal == null) {
                    return Collections.emptyList();
                }
                attrs = F.asMap(attrName, attrs.get(attrName));
            }
            return F.iterator(attrs.entrySet(), na -> new BaselineNodeAttributeView(node.consistentId(), (String)na.getKey(), na.getValue()), true, new IgnitePredicate[0]);
        }, true, new IgnitePredicate[0]));
    }

    public static ClusterState stateWithMinimalFeatures(ClusterState state1, ClusterState state2) {
        if (state1 == state2) {
            return state1;
        }
        if (state1 == ClusterState.INACTIVE || state2 == ClusterState.INACTIVE) {
            return ClusterState.INACTIVE;
        }
        if (state1 == ClusterState.ACTIVE_READ_ONLY || state2 == ClusterState.ACTIVE_READ_ONLY) {
            return ClusterState.ACTIVE_READ_ONLY;
        }
        throw new IllegalArgumentException("Unknown cluster states. state1: " + (Object)((Object)state1) + ", state2: " + (Object)((Object)state2));
    }

    @Override
    public String toString() {
        return S.toString(GridClusterStateProcessor.class, this);
    }

    private List<String> listInMemoryUserCaches() {
        IgniteBiPredicate<DynamicCacheDescriptor, DataRegionConfiguration> inMemoryPred = (desc, dataRegionCfg) -> !(dataRegionCfg != null && dataRegionCfg.isPersistenceEnabled() || desc.cacheConfiguration().isWriteThrough() && desc.cacheConfiguration().isReadThrough());
        if (this.ctx.discovery().localNode().isClient()) {
            List<ClusterNode> srvs = this.ctx.discovery().discoCache().serverNodes();
            if (F.isEmpty(srvs)) {
                return Collections.emptyList();
            }
            return this.ctx.cache().cacheDescriptors().values().stream().filter(desc -> !CU.isSystemCache(desc.cacheName())).filter(desc -> {
                ClusterNode n;
                String dataRegionName = desc.cacheConfiguration().getDataRegionName();
                DataRegionConfiguration dataRegionCfg = null;
                Iterator iterator = srvs.iterator();
                while (iterator.hasNext() && (dataRegionCfg = CU.findRemoteDataRegionConfiguration(n = (ClusterNode)iterator.next(), this.ctx.marshallerContext().jdkMarshaller(), U.resolveClassLoader(this.ctx.config()), dataRegionName)) == null) {
                }
                return inMemoryPred.apply((DynamicCacheDescriptor)desc, dataRegionCfg);
            }).map(DynamicCacheDescriptor::cacheName).collect(Collectors.toList());
        }
        return this.ctx.cache().cacheDescriptors().values().stream().filter(desc -> !CU.isSystemCache(desc.cacheName())).filter(desc -> {
            DataRegionConfiguration dataRegionCfg;
            block1: {
                ClusterNode n;
                String dataRegionName = desc.cacheConfiguration().getDataRegionName();
                dataRegionCfg = CU.findDataRegionConfiguration(this.ctx.config().getDataStorageConfiguration(), dataRegionName);
                if (dataRegionCfg != null) break block1;
                List<ClusterNode> srvs = this.ctx.discovery().discoCache().serverNodes();
                Iterator<ClusterNode> iterator = srvs.iterator();
                while (iterator.hasNext() && (dataRegionCfg = CU.findRemoteDataRegionConfiguration(n = iterator.next(), this.ctx.marshallerContext().jdkMarshaller(), U.resolveClassLoader(this.ctx.config()), dataRegionName)) == null) {
                }
            }
            return inMemoryPred.apply((DynamicCacheDescriptor)desc, dataRegionCfg);
        }).map(DynamicCacheDescriptor::cacheName).collect(Collectors.toList());
    }

    private static class BaselineStateAndHistoryData
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final DiscoveryDataClusterState globalState;
        private final BaselineTopologyHistory recentHistory;

        BaselineStateAndHistoryData(DiscoveryDataClusterState globalState, BaselineTopologyHistory recentHistory) {
            this.globalState = globalState;
            this.recentHistory = recentHistory;
        }
    }

    class TransitionOnJoinWaitFuture
    extends GridFutureAdapter<Boolean> {
        private DiscoveryDataClusterState transitionState;
        private final Set<UUID> transitionNodes;

        TransitionOnJoinWaitFuture(DiscoveryDataClusterState state, DiscoCache discoCache) {
            assert (state.transition()) : state;
            this.transitionNodes = U.newHashSet(state.transitionNodes().size());
            for (UUID nodeId : state.transitionNodes()) {
                if (discoCache.node(nodeId) == null) continue;
                this.transitionNodes.add(nodeId);
            }
        }

        @Override
        public boolean onDone(@Nullable Boolean res, @Nullable Throwable err) {
            if (super.onDone(res, err)) {
                GridClusterStateProcessor.this.joinFut = null;
                return true;
            }
            return false;
        }
    }

    private class GridChangeGlobalStateFuture
    extends GridFutureAdapter<Void> {
        @GridToStringInclude
        private final UUID requestId;
        @GridToStringInclude
        private final ClusterState state;
        @GridToStringInclude
        private final Set<UUID> remaining = new HashSet<UUID>();
        @GridToStringInclude
        private final Map<UUID, GridChangeGlobalStateMessageResponse> responses = new HashMap<UUID, GridChangeGlobalStateMessageResponse>();
        @GridToStringExclude
        private final GridKernalContext ctx;
        @GridToStringExclude
        private final Object mux = new Object();
        @GridToStringInclude
        private final GridFutureAdapter<?> initFut = new GridFutureAdapter();
        @GridToStringExclude
        private final IgniteLogger log;

        GridChangeGlobalStateFuture(UUID reqId, ClusterState state, GridKernalContext ctx) {
            this.requestId = reqId;
            this.state = state;
            this.ctx = ctx;
            this.log = ctx.log(this.getClass());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onNodeLeft(DiscoveryEvent event) {
            assert (event != null);
            if (this.isDone()) {
                return;
            }
            boolean allReceived = false;
            Object object = this.mux;
            synchronized (object) {
                if (this.remaining.remove(event.eventNode().id())) {
                    allReceived = this.remaining.isEmpty();
                }
            }
            if (allReceived) {
                this.onAllReceived();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setRemaining(Set<UUID> nodesIds, AffinityTopologyVersion topVer) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Setup remaining node [id=" + this.ctx.localNodeId() + ", client=" + this.ctx.clientNode() + ", topVer=" + topVer + ", nodes=" + nodesIds + "]");
            }
            Object object = this.mux;
            synchronized (object) {
                this.remaining.addAll(nodesIds);
            }
            this.initFut.onDone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResponse(UUID nodeId, GridChangeGlobalStateMessageResponse msg) {
            assert (msg != null);
            if (this.isDone()) {
                return;
            }
            boolean allReceived = false;
            Object object = this.mux;
            synchronized (object) {
                if (this.remaining.remove(nodeId)) {
                    allReceived = this.remaining.isEmpty();
                }
                this.responses.put(nodeId, msg);
            }
            if (allReceived) {
                this.onAllReceived();
            }
        }

        private void onAllReceived() {
            IgniteCheckedException e = new IgniteCheckedException();
            boolean fail = false;
            for (Map.Entry<UUID, GridChangeGlobalStateMessageResponse> entry : this.responses.entrySet()) {
                GridChangeGlobalStateMessageResponse r = entry.getValue();
                if (r.getError() == null) continue;
                fail = true;
                e.addSuppressed(r.getError());
            }
            if (fail) {
                this.onDone(e);
            } else {
                this.onDone();
            }
        }

        @Override
        public boolean onDone(@Nullable Void res, @Nullable Throwable err) {
            if (super.onDone(res, err)) {
                GridClusterStateProcessor.this.stateChangeFut.compareAndSet(this, null);
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            return S.toString(GridChangeGlobalStateFuture.class, this);
        }
    }
}

