/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.colocated;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.ReadRepairStrategy;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheConcurrentMap;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheLockTimeoutException;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedLockCancelledException;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedUnlockRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtEmbeddedFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtFinishedFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtLockFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTransactionalCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridPartitionedGetFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridPartitionedSingleGetFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.colocated.GridDhtColocatedLockFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearGetResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearLockResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearSingleGetResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTransactionalCache;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearUnlockRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.consistency.GridNearReadRepairCheckOnlyFuture;
import org.apache.ignite.internal.processors.cache.mvcc.MvccQueryTracker;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalEx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.future.GridEmbeddedFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.lang.IgnitePair;
import org.apache.ignite.internal.util.typedef.C2;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.CI2;
import org.apache.ignite.internal.util.typedef.CX1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.Nullable;

public class GridDhtColocatedCache<K, V>
extends GridDhtTransactionalCacheAdapter<K, V> {
    private static final long serialVersionUID = 0L;

    public GridDhtColocatedCache() {
    }

    public GridDhtColocatedCache(GridCacheContext<K, V> ctx) {
        super(ctx);
    }

    public GridDhtColocatedCache(GridCacheContext<K, V> ctx, GridCacheConcurrentMap map) {
        super(ctx, map);
    }

    @Override
    public boolean isColocated() {
        return true;
    }

    @Override
    public void start() throws IgniteCheckedException {
        super.start();
        this.ctx.io().addCacheHandler(this.ctx.cacheId(), GridNearGetResponse.class, new CI2<UUID, GridNearGetResponse>(){

            @Override
            public void apply(UUID nodeId, GridNearGetResponse res) {
                GridDhtColocatedCache.this.processNearGetResponse(nodeId, res);
            }
        });
        this.ctx.io().addCacheHandler(this.ctx.cacheId(), GridNearSingleGetResponse.class, new CI2<UUID, GridNearSingleGetResponse>(){

            @Override
            public void apply(UUID nodeId, GridNearSingleGetResponse res) {
                GridDhtColocatedCache.this.processNearSingleGetResponse(nodeId, res);
            }
        });
        this.ctx.io().addCacheHandler(this.ctx.cacheId(), GridNearLockResponse.class, new CI2<UUID, GridNearLockResponse>(){

            @Override
            public void apply(UUID nodeId, GridNearLockResponse res) {
                GridDhtColocatedCache.this.processNearLockResponse(nodeId, res);
            }
        });
    }

    public GridDistributedCacheEntry entryExx(KeyCacheObject key, AffinityTopologyVersion topVer, boolean allowDetached) {
        return allowDetached && !this.ctx.affinity().primaryByKey(this.ctx.localNode(), key, topVer) ? this.createEntry(key) : this.entryExx(key, topVer);
    }

    @Override
    public boolean isLocked(K key) {
        KeyCacheObject cacheKey = this.ctx.toCacheKeyObject(key);
        return this.ctx.mvcc().isLockedByThread(this.ctx.txKey(cacheKey), -1L);
    }

    @Override
    public boolean isLockedByThread(K key) {
        KeyCacheObject cacheKey = this.ctx.toCacheKeyObject(key);
        return this.ctx.mvcc().isLockedByThread(this.ctx.txKey(cacheKey), Thread.currentThread().getId());
    }

    @Override
    protected IgniteInternalFuture<V> getAsync(final K key, boolean forcePrimary, boolean skipTx, String taskName, final boolean deserializeBinary, final boolean skipVals, final boolean needVer) {
        ReadRepairStrategy readRepairStrategy;
        this.ctx.checkSecurity(SecurityPermission.CACHE_READ);
        GridNearTxLocal tx = this.checkCurrentTx();
        final CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        final boolean recovery = opCtx != null && opCtx.recovery();
        ReadRepairStrategy readRepairStrategy2 = readRepairStrategy = opCtx != null ? opCtx.readRepairStrategy() : null;
        if (!(this.ctx.mvccEnabled() || tx == null || tx.implicit() || skipTx)) {
            return this.asyncOp(tx, new GridCacheAdapter.AsyncOp<V>(){

                @Override
                public IgniteInternalFuture<V> op(GridNearTxLocal tx, AffinityTopologyVersion readyTopVer) {
                    IgniteInternalFuture fut = tx.getAllAsync(GridDhtColocatedCache.this.ctx, readyTopVer, Collections.singleton(GridDhtColocatedCache.this.ctx.toCacheKeyObject(key)), deserializeBinary, skipVals, false, opCtx != null && opCtx.skipStore(), recovery, readRepairStrategy, needVer);
                    return fut.chain(new CX1<IgniteInternalFuture<Map<Object, Object>>, V>(){

                        @Override
                        public V applyx(IgniteInternalFuture<Map<Object, Object>> e) throws IgniteCheckedException {
                            Map<Object, Object> map = e.get();
                            assert (map.isEmpty() || map.size() == 1) : map.size();
                            if (skipVals) {
                                Boolean val = map.isEmpty() ? false : (Boolean)F.firstValue(map);
                                return val;
                            }
                            return F.firstValue(map);
                        }
                    });
                }
            }, opCtx, false);
        }
        MvccSnapshot mvccSnapshot = null;
        MvccQueryTracker mvccTracker = null;
        if (this.ctx.mvccEnabled()) {
            try {
                if (tx != null) {
                    mvccSnapshot = MvccUtils.requestSnapshot(tx);
                } else {
                    mvccTracker = MvccUtils.mvccTracker(this.ctx, null);
                    mvccSnapshot = mvccTracker.snapshot();
                }
                assert (mvccSnapshot != null);
            }
            catch (IgniteCheckedException ex) {
                return new GridFinishedFuture(ex);
            }
        }
        AffinityTopologyVersion topVer = tx != null ? tx.topologyVersion() : (mvccTracker != null ? mvccTracker.topologyVersion() : this.ctx.affinity().affinityTopologyVersion());
        if (readRepairStrategy != null) {
            return new GridNearReadRepairCheckOnlyFuture(topVer, this.ctx, Collections.singleton(this.ctx.toCacheKeyObject(key)), readRepairStrategy, opCtx == null || !opCtx.skipStore(), taskName, deserializeBinary, recovery, skipVals ? null : this.expiryPolicy(opCtx != null ? opCtx.expiry() : null), skipVals, needVer, false, tx).single();
        }
        GridPartitionedSingleGetFuture fut = new GridPartitionedSingleGetFuture(this.ctx, this.ctx.toCacheKeyObject(key), topVer, opCtx == null || !opCtx.skipStore(), forcePrimary, taskName, deserializeBinary, skipVals ? null : this.expiryPolicy(opCtx != null ? opCtx.expiry() : null), skipVals, needVer, false, opCtx != null && opCtx.recovery(), null, mvccSnapshot);
        fut.init();
        if (mvccTracker != null) {
            final MvccQueryTracker mvccTracker0 = mvccTracker;
            fut.listen(new CI1<IgniteInternalFuture<Object>>(){

                @Override
                public void apply(IgniteInternalFuture<Object> future) {
                    if (future.isDone()) {
                        mvccTracker0.onDone();
                    }
                }
            });
        }
        return fut;
    }

    @Override
    public IgniteInternalFuture<Map<K, V>> getAllAsync(final @Nullable Collection<? extends K> keys, boolean forcePrimary, boolean skipTx, String taskName, final boolean deserializeBinary, final boolean recovery, final ReadRepairStrategy readRepairStrategy, final boolean skipVals, final boolean needVer) {
        this.ctx.checkSecurity(SecurityPermission.CACHE_READ);
        if (F.isEmpty(keys)) {
            return new GridFinishedFuture(Collections.emptyMap());
        }
        this.warnIfUnordered(keys, GridCacheAdapter.BulkOperation.GET);
        GridNearTxLocal tx = this.checkCurrentTx();
        final CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        if (!(this.ctx.mvccEnabled() || tx == null || tx.implicit() || skipTx)) {
            return this.asyncOp(tx, new GridCacheAdapter.AsyncOp<Map<K, V>>(keys){

                @Override
                public IgniteInternalFuture<Map<K, V>> op(GridNearTxLocal tx, AffinityTopologyVersion readyTopVer) {
                    return tx.getAllAsync(GridDhtColocatedCache.this.ctx, readyTopVer, GridDhtColocatedCache.this.ctx.cacheKeysView(keys), deserializeBinary, skipVals, false, opCtx != null && opCtx.skipStore(), recovery, readRepairStrategy, needVer);
                }
            }, opCtx, false);
        }
        MvccSnapshot mvccSnapshot = null;
        MvccQueryTracker mvccTracker = null;
        if (this.ctx.mvccEnabled()) {
            try {
                if (tx != null) {
                    mvccSnapshot = MvccUtils.requestSnapshot(tx);
                } else {
                    mvccTracker = MvccUtils.mvccTracker(this.ctx, null);
                    mvccSnapshot = mvccTracker.snapshot();
                }
                assert (mvccSnapshot != null);
            }
            catch (IgniteCheckedException ex) {
                return new GridFinishedFuture<Map<K, V>>(ex);
            }
        }
        AffinityTopologyVersion topVer = tx != null ? tx.topologyVersion() : (mvccTracker != null ? mvccTracker.topologyVersion() : this.ctx.affinity().affinityTopologyVersion());
        if (readRepairStrategy != null) {
            return new GridNearReadRepairCheckOnlyFuture(topVer, this.ctx, this.ctx.cacheKeysView(keys), readRepairStrategy, opCtx == null || !opCtx.skipStore(), taskName, deserializeBinary, recovery, skipVals ? null : this.expiryPolicy(opCtx != null ? opCtx.expiry() : null), skipVals, needVer, false, tx).multi();
        }
        IgniteInternalFuture<Map<K, V>> fut = this.loadAsync(this.ctx.cacheKeysView(keys), opCtx == null || !opCtx.skipStore(), forcePrimary, topVer, taskName, deserializeBinary, recovery, skipVals ? null : this.expiryPolicy(opCtx != null ? opCtx.expiry() : null), skipVals, needVer, false, null, mvccSnapshot);
        if (mvccTracker != null) {
            final MvccQueryTracker mvccTracker0 = mvccTracker;
            fut.listen(new CI1<IgniteInternalFuture<Map<K, V>>>(){

                @Override
                public void apply(IgniteInternalFuture<Map<K, V>> future) {
                    if (future.isDone()) {
                        mvccTracker0.onDone();
                    }
                }
            });
        }
        return fut;
    }

    public final IgniteInternalFuture<Object> loadAsync(KeyCacheObject key, boolean readThrough, boolean forcePrimary, AffinityTopologyVersion topVer, String taskName, boolean deserializeBinary, @Nullable IgniteCacheExpiryPolicy expiryPlc, boolean skipVals, boolean needVer, boolean keepCacheObj, boolean recovery, @Nullable MvccSnapshot mvccSnapshot, @Nullable String txLbl) {
        GridPartitionedSingleGetFuture fut = new GridPartitionedSingleGetFuture(this.ctx, this.ctx.toCacheKeyObject(key), topVer, readThrough, forcePrimary, taskName, deserializeBinary, expiryPlc, skipVals, needVer, keepCacheObj, recovery, txLbl, mvccSnapshot);
        fut.init();
        return fut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final IgniteInternalFuture<Map<K, V>> loadAsync(@Nullable Collection<KeyCacheObject> keys, boolean readThrough, boolean forcePrimary, AffinityTopologyVersion topVer, String taskName, boolean deserializeBinary, boolean recovery, @Nullable IgniteCacheExpiryPolicy expiryPlc, boolean skipVals, boolean needVer, boolean keepCacheObj, @Nullable String txLbl, @Nullable MvccSnapshot mvccSnapshot) {
        block30: {
            assert (mvccSnapshot == null == !this.ctx.mvccEnabled());
            if (keys == null) return new GridFinishedFuture(Collections.emptyMap());
            if (keys.isEmpty()) {
                return new GridFinishedFuture(Collections.emptyMap());
            }
            if (expiryPlc == null) {
                expiryPlc = this.expiryPolicy(null);
            }
            if (forcePrimary || !this.ctx.config().isReadFromBackup() || !this.ctx.affinityNode() || !this.ctx.topology().lostPartitions().isEmpty()) break block30;
            this.ctx.shared().database().checkpointReadLock();
            try {
                HashMap locVals = null;
                boolean success = true;
                boolean readNoEntry = this.ctx.readNoEntry(expiryPlc, false);
                boolean evt = !skipVals;
                for (KeyCacheObject key : keys) {
                    block33: {
                        block31: {
                            block32: {
                                CacheDataRow row;
                                if (!readNoEntry) break block31;
                                CacheDataRow cacheDataRow = row = mvccSnapshot != null ? this.ctx.offheap().mvccRead(this.ctx, key, mvccSnapshot) : this.ctx.offheap().read(this.ctx, key);
                                if (row == null) break block32;
                                long expireTime = row.expireTime();
                                if (expireTime == 0L || expireTime > U.currentTimeMillis()) {
                                    if (locVals == null) {
                                        locVals = U.newHashMap(keys.size());
                                    }
                                    this.ctx.addResult(locVals, key, row.value(), skipVals, keepCacheObj, deserializeBinary, true, null, row.version(), 0L, 0L, needVer, U.deploymentClassLoader(this.ctx.kernalContext(), U.contextDeploymentClassLoaderId(this.ctx.kernalContext())));
                                    if (evt) {
                                        this.ctx.events().readEvent(key, null, txLbl, row.value(), taskName, !deserializeBinary);
                                    }
                                    break block33;
                                } else {
                                    success = false;
                                }
                                break block33;
                            }
                            success = false;
                            break block33;
                        }
                        GridCacheEntryEx entry = null;
                        while (true) {
                            try {
                                entry = this.entryEx(key);
                                if (entry != null) {
                                    boolean isNew = entry.isNewLocked();
                                    EntryGetResult getRes = null;
                                    CacheObject v = null;
                                    GridCacheVersion ver = null;
                                    if (needVer) {
                                        getRes = entry.innerGetVersioned(null, null, false, evt, null, taskName, expiryPlc, !deserializeBinary, null);
                                        if (getRes != null) {
                                            v = (CacheObject)getRes.value();
                                            ver = getRes.version();
                                        }
                                    } else {
                                        v = entry.innerGet(null, null, false, false, evt, null, taskName, expiryPlc, !deserializeBinary);
                                    }
                                    if (v == null) {
                                        GridCacheVersion obsoleteVer = this.nextVersion();
                                        if (isNew && entry.markObsoleteIfEmpty(obsoleteVer)) {
                                            this.removeEntry(entry);
                                        }
                                        success = false;
                                        break;
                                    }
                                    if (locVals == null) {
                                        locVals = U.newHashMap(keys.size());
                                    }
                                    this.ctx.addResult(locVals, key, v, skipVals, keepCacheObj, deserializeBinary, true, getRes, ver, 0L, 0L, needVer, U.deploymentClassLoader(this.ctx.kernalContext(), U.contextDeploymentClassLoaderId(this.ctx.kernalContext())));
                                    break;
                                }
                                success = false;
                            }
                            catch (GridCacheEntryRemovedException isNew) {
                                continue;
                            }
                            catch (GridDhtInvalidPartitionException ignored) {
                                success = false;
                            }
                            finally {
                                if (entry == null) continue;
                                entry.touch();
                                continue;
                            }
                            break;
                        }
                    }
                    if (!success) break;
                    if (skipVals || !this.ctx.statisticsEnabled()) continue;
                    this.ctx.cache().metrics0().onRead(true);
                }
                if (success) {
                    this.sendTtlUpdateRequest(expiryPlc);
                    GridFinishedFuture<Object> gridFinishedFuture = new GridFinishedFuture<Object>(locVals);
                    return gridFinishedFuture;
                }
            }
            catch (IgniteCheckedException e) {
                GridFinishedFuture<Map<K, V>> gridFinishedFuture = new GridFinishedFuture<Map<K, V>>(e);
                return gridFinishedFuture;
            }
            finally {
                this.ctx.shared().database().checkpointReadUnlock();
            }
        }
        if (expiryPlc != null) {
            expiryPlc.reset();
        }
        GridPartitionedGetFuture fut = new GridPartitionedGetFuture(this.ctx, keys, readThrough, forcePrimary, taskName, deserializeBinary, recovery, expiryPlc, skipVals, needVer, keepCacheObj, txLbl, mvccSnapshot, null);
        fut.init(topVer);
        return fut;
    }

    @Override
    public IgniteInternalFuture<Boolean> lockAllAsync(Collection<KeyCacheObject> keys, long timeout, @Nullable IgniteTxLocalEx tx, boolean isInvalidate, boolean isRead, boolean retval, @Nullable TransactionIsolation isolation, long createTtl, long accessTtl) {
        assert (tx == null || tx instanceof GridNearTxLocal) : tx;
        GridNearTxLocal txx = (GridNearTxLocal)tx;
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        GridDhtColocatedLockFuture fut = new GridDhtColocatedLockFuture(this.ctx, keys, txx, isRead, retval, timeout, createTtl, accessTtl, CU.empty0(), opCtx != null && opCtx.skipStore(), opCtx != null && opCtx.isKeepBinary(), opCtx != null && opCtx.recovery());
        fut.map();
        return fut;
    }

    @Override
    public GridNearTransactionalCache<K, V> near() {
        assert (false) : "Near cache is not available in colocated mode.";
        return null;
    }

    @Override
    public void unlockAll(Collection<? extends K> keys) {
        if (keys.isEmpty()) {
            return;
        }
        try {
            GridCacheVersion ver = null;
            int keyCnt = -1;
            HashMap<ClusterNode, GridNearUnlockRequest> map = null;
            ArrayList<KeyCacheObject> locKeys = new ArrayList<KeyCacheObject>();
            for (K k : keys) {
                KeyCacheObject cacheKey = this.ctx.toCacheKeyObject(k);
                IgniteTxKey txKey = this.ctx.txKey(cacheKey);
                GridDhtCacheEntry entry = this.peekExx(cacheKey);
                GridCacheMvccCandidate lock = this.ctx.mvcc().removeExplicitLock(Thread.currentThread().getId(), txKey, null);
                if (lock == null) continue;
                AffinityTopologyVersion topVer = lock.topologyVersion();
                assert (topVer.compareTo(AffinityTopologyVersion.ZERO) > 0);
                ClusterNode primary = this.ctx.affinity().primaryByKey(k, topVer);
                if (primary == null) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Failed to unlock keys (all partition nodes left the grid).");
                    continue;
                }
                if (map == null) {
                    Collection<ClusterNode> affNodes = CU.affinityNodes(this.ctx, topVer);
                    keyCnt = (int)Math.ceil((double)keys.size() / (double)affNodes.size());
                    map = U.newHashMap(affNodes.size());
                }
                if (ver == null) {
                    ver = lock.version();
                }
                if (!lock.reentry()) {
                    if (!ver.equals(lock.version())) {
                        throw new IgniteCheckedException("Failed to unlock (if keys were locked separately, then they need to be unlocked separately): " + keys);
                    }
                    if (!primary.isLocal()) {
                        GridNearUnlockRequest req = (GridNearUnlockRequest)map.get(primary);
                        if (req == null) {
                            req = new GridNearUnlockRequest(this.ctx.cacheId(), keyCnt, this.ctx.deploymentEnabled());
                            map.put(primary, req);
                            req.version(ver);
                        }
                        KeyCacheObject key0 = entry != null ? entry.key() : cacheKey;
                        req.addKey(key0, this.ctx);
                    } else {
                        locKeys.add(cacheKey);
                    }
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Removed lock (will distribute): " + lock);
                    continue;
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Current thread still owns lock (or there are no other nodes) [lock=" + lock + ", curThreadId=" + Thread.currentThread().getId() + ']');
            }
            if (ver == null) {
                return;
            }
            if (!locKeys.isEmpty()) {
                this.removeLocks(this.ctx.localNodeId(), ver, locKeys, true);
            }
            for (Map.Entry entry : map.entrySet()) {
                ClusterNode n = (ClusterNode)entry.getKey();
                GridDistributedUnlockRequest req = (GridDistributedUnlockRequest)entry.getValue();
                assert (!n.isLocal());
                if (F.isEmpty(req.keys())) continue;
                try {
                    this.ctx.io().send(n, (GridCacheMessage)req, this.ctx.ioPolicy());
                }
                catch (ClusterTopologyCheckedException e) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Failed to send unlock request (node has left the grid) [keys=" + req.keys() + ", n=" + n + ", e=" + e + ']');
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to send unlock request [keys=" + req.keys() + ", n=" + n + ']', e);
                }
            }
        }
        catch (IgniteCheckedException ex) {
            U.error(this.log, "Failed to unlock the lock for keys: " + keys, ex);
        }
    }

    public void removeLocks(long threadId, GridCacheVersion ver, Collection<KeyCacheObject> keys) {
        if (keys.isEmpty()) {
            return;
        }
        try {
            GridDistributedUnlockRequest req;
            int keyCnt = -1;
            HashMap<ClusterNode, GridNearUnlockRequest> map = null;
            LinkedList<KeyCacheObject> locKeys = new LinkedList<KeyCacheObject>();
            for (KeyCacheObject key : keys) {
                ClusterNode primary;
                IgniteTxKey txKey = this.ctx.txKey(key);
                GridCacheMvccCandidate lock = this.ctx.mvcc().removeExplicitLock(threadId, txKey, ver);
                if (lock == null) continue;
                AffinityTopologyVersion topVer = lock.topologyVersion();
                if (map == null) {
                    Collection<ClusterNode> affNodes = CU.affinityNodes(this.ctx, topVer);
                    keyCnt = (int)Math.ceil((double)keys.size() / (double)affNodes.size());
                    map = U.newHashMap(affNodes.size());
                }
                if ((primary = this.ctx.affinity().primaryByKey(key, topVer)) == null) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Failed to remove locks (all partition nodes left the grid).");
                    continue;
                }
                if (!primary.isLocal()) {
                    GridCacheEntryEx entry;
                    req = (GridNearUnlockRequest)map.get(primary);
                    if (req == null) {
                        req = new GridNearUnlockRequest(this.ctx.cacheId(), keyCnt, this.ctx.deploymentEnabled());
                        map.put(primary, (GridNearUnlockRequest)req);
                        req.version(ver);
                    }
                    KeyCacheObject key0 = (entry = this.peekEx(key)) != null ? entry.key() : key;
                    req.addKey(key0, this.ctx);
                    continue;
                }
                locKeys.add(key);
            }
            if (!locKeys.isEmpty()) {
                this.removeLocks(this.ctx.localNodeId(), ver, locKeys, true);
            }
            if (map == null || map.isEmpty()) {
                return;
            }
            IgnitePair<Collection<GridCacheVersion>> versPair = this.ctx.tm().versions(ver);
            Collection committed = (Collection)versPair.get1();
            Collection rolledback = (Collection)versPair.get2();
            for (Map.Entry mapping : map.entrySet()) {
                ClusterNode n = (ClusterNode)mapping.getKey();
                req = (GridDistributedUnlockRequest)mapping.getValue();
                if (F.isEmpty(req.keys())) continue;
                req.completedVersions(committed, rolledback);
                try {
                    this.ctx.io().send(n, (GridCacheMessage)req, this.ctx.ioPolicy());
                }
                catch (ClusterTopologyCheckedException e) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Failed to send unlock request (node has left the grid) [keys=" + req.keys() + ", n=" + n + ", e=" + e + ']');
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to send unlock request [keys=" + req.keys() + ", n=" + n + ']', e);
                }
            }
        }
        catch (IgniteCheckedException ex) {
            U.error(this.log, "Failed to unlock the lock for keys: " + keys, ex);
        }
    }

    IgniteInternalFuture<Exception> lockAllAsync(final GridCacheContext<?, ?> cacheCtx, final @Nullable GridNearTxLocal tx, final long threadId, final GridCacheVersion ver, final AffinityTopologyVersion topVer, final Collection<KeyCacheObject> keys, final boolean txRead, final boolean retval, final long timeout, final long createTtl, final long accessTtl, final @Nullable CacheEntryPredicate[] filter, final boolean skipStore, final boolean keepBinary) {
        assert (keys != null);
        GridDhtFuture<Object> keyFut = this.ctx.group().preloader().request(cacheCtx, keys, topVer);
        if (keyFut == null || keyFut.isDone()) {
            if (keyFut != null && keyFut.error() != null) {
                return new GridFinishedFuture<Exception>(keyFut.error());
            }
            return this.lockAllAsync0(cacheCtx, tx, threadId, ver, topVer, keys, txRead, retval, timeout, createTtl, accessTtl, filter, skipStore, keepBinary);
        }
        return new GridEmbeddedFuture<Exception, Object>(keyFut, new C2<Object, Exception, IgniteInternalFuture<Exception>>(){

            @Override
            public IgniteInternalFuture<Exception> apply(Object o, Exception exx) {
                if (exx != null) {
                    return new GridDhtFinishedFuture<Exception>((Throwable)exx);
                }
                return GridDhtColocatedCache.this.lockAllAsync0(cacheCtx, tx, threadId, ver, topVer, keys, txRead, retval, timeout, createTtl, accessTtl, filter, skipStore, keepBinary);
            }
        });
    }

    private IgniteInternalFuture<Exception> lockAllAsync0(GridCacheContext<?, ?> cacheCtx, final @Nullable GridNearTxLocal tx, long threadId, final GridCacheVersion ver, AffinityTopologyVersion topVer, Collection<KeyCacheObject> keys, boolean txRead, boolean retval, long timeout, long createTtl, long accessTtl, @Nullable CacheEntryPredicate[] filter, boolean skipStore, boolean keepBinary) {
        int cnt = keys.size();
        if (tx == null) {
            GridDhtLockFuture fut = new GridDhtLockFuture(this.ctx, this.ctx.localNodeId(), ver, topVer, cnt, txRead, retval, timeout, tx, threadId, createTtl, accessTtl, filter, skipStore, keepBinary);
            if (!this.ctx.mvcc().addFuture(fut)) {
                throw new IllegalStateException("Duplicate future ID: " + fut);
            }
            boolean timedout = false;
            block3: for (KeyCacheObject key : keys) {
                if (timedout) break;
                while (true) {
                    GridDhtCacheEntry entry = this.entryExx(key, topVer);
                    try {
                        fut.addEntry(key == null ? null : entry);
                        if (!fut.isDone()) continue block3;
                        timedout = true;
                        continue block3;
                    }
                    catch (GridCacheEntryRemovedException ignore) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Got removed entry when adding lock (will retry): " + entry);
                        continue;
                    }
                    catch (GridDistributedLockCancelledException e) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Failed to add entry [err=" + e + ", entry=" + entry + ']');
                        }
                        fut.onError(e);
                        return new GridDhtFinishedFuture<Exception>((Throwable)e);
                    }
                    break;
                }
            }
            fut.map();
            return new GridDhtEmbeddedFuture<Exception, Boolean>(new C2<Boolean, Exception, Exception>(){

                @Override
                public Exception apply(Boolean b, Exception e) {
                    if (e != null) {
                        e = U.unwrap(e);
                    } else if (!b.booleanValue()) {
                        e = new GridCacheLockTimeoutException(ver);
                    }
                    return e;
                }
            }, fut);
        }
        this.ctx.tm().txContext(tx);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Performing colocated lock [tx=" + tx + ", keys=" + keys + ']');
        }
        IgniteInternalFuture<GridCacheReturn> txFut = tx.lockAllAsync(cacheCtx, keys, retval, txRead, createTtl, accessTtl, skipStore, keepBinary);
        return new GridDhtEmbeddedFuture<Exception, GridCacheReturn>(new C2<GridCacheReturn, Exception, Exception>(){

            @Override
            public Exception apply(GridCacheReturn ret, Exception e) {
                if (e != null) {
                    e = U.unwrap(e);
                }
                assert (!tx.empty());
                return e;
            }
        }, txFut);
    }

    private void processNearLockResponse(UUID nodeId, GridNearLockResponse res) {
        if (this.txLockMsgLog.isDebugEnabled()) {
            this.txLockMsgLog.debug("Received near lock response [txId=" + res.version() + ", node=" + nodeId + ']');
        }
        assert (nodeId != null);
        assert (res != null);
        GridDhtColocatedLockFuture fut = (GridDhtColocatedLockFuture)this.ctx.mvcc().versionedFuture(res.version(), res.futureId());
        if (fut != null) {
            fut.onResult(nodeId, res);
        } else if (this.txLockMsgLog.isDebugEnabled()) {
            this.txLockMsgLog.debug("Received near lock response for unknown future [txId=" + res.version() + ", node=" + nodeId + ", res=" + res + ']');
        }
    }

    @Override
    public String toString() {
        return S.toString(GridDhtColocatedCache.class, this, super.toString());
    }
}

