/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.cache.configuration.Factory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.ignite.client.SslMode;
import org.apache.ignite.client.SslProtocol;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.internal.client.thin.ClientError;
import org.apache.ignite.ssl.SslContextFactory;

public class ClientSslUtils {
    public static final char[] EMPTY_CHARS = new char[0];
    private static final TrustManager ignoreErrorsTrustMgr = new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
        }
    };

    public static SSLContext getSslContext(ClientConfiguration cfg) {
        TrustManager[] trustManagerArray;
        if (cfg.getSslMode() == SslMode.DISABLED) {
            return null;
        }
        Factory<SSLContext> sslCtxFactory = cfg.getSslContextFactory();
        if (sslCtxFactory != null) {
            try {
                return (SSLContext)sslCtxFactory.create();
            }
            catch (Exception e) {
                throw new ClientError("SSL Context Factory failed", e);
            }
        }
        BiFunction<String, String, String> or = (val, dflt) -> val == null || val.isEmpty() ? dflt : val;
        String keyStore = or.apply(cfg.getSslClientCertificateKeyStorePath(), System.getProperty("javax.net.ssl.keyStore"));
        String keyStoreType = or.apply(cfg.getSslClientCertificateKeyStoreType(), or.apply(System.getProperty("javax.net.ssl.keyStoreType"), SslContextFactory.DFLT_STORE_TYPE));
        String keyStorePwd = or.apply(cfg.getSslClientCertificateKeyStorePassword(), System.getProperty("javax.net.ssl.keyStorePassword"));
        String trustStore = or.apply(cfg.getSslTrustCertificateKeyStorePath(), System.getProperty("javax.net.ssl.trustStore"));
        String trustStoreType = or.apply(cfg.getSslTrustCertificateKeyStoreType(), or.apply(System.getProperty("javax.net.ssl.trustStoreType"), SslContextFactory.DFLT_STORE_TYPE));
        String trustStorePwd = or.apply(cfg.getSslTrustCertificateKeyStorePassword(), System.getProperty("javax.net.ssl.trustStorePassword"));
        String algorithm = or.apply(cfg.getSslKeyAlgorithm(), SslContextFactory.DFLT_KEY_ALGORITHM);
        String proto = ClientSslUtils.toString(cfg.getSslProtocol());
        if (Stream.of(keyStore, keyStorePwd, keyStoreType, trustStore, trustStorePwd, trustStoreType).allMatch(s -> s == null || s.isEmpty())) {
            try {
                return SSLContext.getDefault();
            }
            catch (NoSuchAlgorithmException e) {
                throw new ClientError("Default SSL context cryptographic algorithm is not available", e);
            }
        }
        KeyManager[] keyManagers = ClientSslUtils.getKeyManagers(algorithm, keyStore, keyStoreType, keyStorePwd);
        if (cfg.isSslTrustAll()) {
            TrustManager[] trustManagerArray2 = new TrustManager[1];
            trustManagerArray = trustManagerArray2;
            trustManagerArray2[0] = ignoreErrorsTrustMgr;
        } else {
            trustManagerArray = ClientSslUtils.getTrustManagers(algorithm, trustStore, trustStoreType, trustStorePwd);
        }
        TrustManager[] trustManagers = trustManagerArray;
        try {
            SSLContext sslCtx = SSLContext.getInstance(proto);
            sslCtx.init(keyManagers, trustManagers, null);
            return sslCtx;
        }
        catch (NoSuchAlgorithmException e) {
            throw new ClientError("SSL context cryptographic algorithm is not available", e);
        }
        catch (KeyManagementException e) {
            throw new ClientError("Failed to create SSL Context", e);
        }
    }

    private static String toString(SslProtocol proto) {
        switch (proto) {
            case TLSv1_1: {
                return "TLSv1.1";
            }
            case TLSv1_2: {
                return "TLSv1.2";
            }
        }
        return proto.toString();
    }

    private static KeyManager[] getKeyManagers(String algorithm, String keyStore, String keyStoreType, String keyStorePwd) {
        KeyManagerFactory keyMgrFactory;
        try {
            keyMgrFactory = KeyManagerFactory.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ClientError("Key manager cryptographic algorithm is not available", e);
        }
        Predicate<String> empty = s -> s == null || s.isEmpty();
        if (!empty.test(keyStore) && !empty.test(keyStoreType)) {
            char[] pwd = keyStorePwd == null ? EMPTY_CHARS : keyStorePwd.toCharArray();
            KeyStore store = ClientSslUtils.loadKeyStore("Client", keyStore, keyStoreType, pwd);
            try {
                keyMgrFactory.init(store, pwd);
            }
            catch (UnrecoverableKeyException e) {
                throw new ClientError("Could not recover key store key", e);
            }
            catch (KeyStoreException e) {
                throw new ClientError(String.format("Client key store provider of type [%s] is not available", keyStoreType), e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ClientError("Client key store integrity check algorithm is not available", e);
            }
        }
        return keyMgrFactory.getKeyManagers();
    }

    private static TrustManager[] getTrustManagers(String algorithm, String trustStore, String trustStoreType, String trustStorePwd) {
        TrustManagerFactory trustMgrFactory;
        try {
            trustMgrFactory = TrustManagerFactory.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ClientError("Trust manager cryptographic algorithm is not available", e);
        }
        Predicate<String> empty = s -> s == null || s.isEmpty();
        if (!empty.test(trustStore) && !empty.test(trustStoreType)) {
            char[] pwd = trustStorePwd == null ? EMPTY_CHARS : trustStorePwd.toCharArray();
            KeyStore store = ClientSslUtils.loadKeyStore("Trust", trustStore, trustStoreType, pwd);
            try {
                trustMgrFactory.init(store);
            }
            catch (KeyStoreException e) {
                throw new ClientError(String.format("Trust key store provider of type [%s] is not available", trustStoreType), e);
            }
        }
        return trustMgrFactory.getTrustManagers();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static KeyStore loadKeyStore(String lb, String path, String type, char[] pwd) {
        KeyStore store;
        try {
            store = KeyStore.getInstance(type);
        }
        catch (KeyStoreException e) {
            throw new ClientError(String.format("%s key store provider of type [%s] is not available", lb, type), e);
        }
        try (FileInputStream in = new FileInputStream(new File(path));){
            store.load(in, pwd);
            KeyStore keyStore = store;
            return keyStore;
        }
        catch (FileNotFoundException e) {
            throw new ClientError(String.format("%s key store file [%s] does not exist", lb, path), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ClientError(String.format("%s key store integrity check algorithm is not available", lb), e);
        }
        catch (CertificateException e) {
            throw new ClientError(String.format("Could not load certificate from %s key store", lb), e);
        }
        catch (IOException e) {
            throw new ClientError(String.format("Could not read %s key store", lb), e);
        }
    }
}

