/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import org.apache.ignite.client.ClientCluster;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.client.ClientFeatureNotSupportedByServerException;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.client.thin.ClientBinaryMarshaller;
import org.apache.ignite.internal.client.thin.ClientClusterGroupImpl;
import org.apache.ignite.internal.client.thin.ClientError;
import org.apache.ignite.internal.client.thin.ClientOperation;
import org.apache.ignite.internal.client.thin.ProtocolBitmaskFeature;
import org.apache.ignite.internal.client.thin.ProtocolContext;
import org.apache.ignite.internal.client.thin.ProtocolVersionFeature;
import org.apache.ignite.internal.client.thin.ReliableChannel;

class ClientClusterImpl
extends ClientClusterGroupImpl
implements ClientCluster {
    private final ClientClusterGroupImpl dfltClusterGrp = (ClientClusterGroupImpl)this.forServers();

    ClientClusterImpl(ReliableChannel ch, ClientBinaryMarshaller marsh) {
        super(ch, marsh);
    }

    @Override
    public ClusterState state() {
        try {
            return this.ch.service(ClientOperation.CLUSTER_GET_STATE, req -> this.checkClusterApiSupported(req.clientChannel().protocolCtx()), res -> ClusterState.fromOrdinal(res.in().readByte()));
        }
        catch (ClientError e) {
            throw new ClientException(e);
        }
    }

    @Override
    public void state(ClusterState newState) throws ClientException {
        try {
            this.ch.service(ClientOperation.CLUSTER_CHANGE_STATE, req -> {
                ProtocolContext protocolCtx = req.clientChannel().protocolCtx();
                this.checkClusterApiSupported(protocolCtx);
                if (newState.ordinal() > 1 && !protocolCtx.isFeatureSupported(ProtocolBitmaskFeature.CLUSTER_STATES)) {
                    throw new ClientFeatureNotSupportedByServerException("State " + newState.name() + " is not supported by the server");
                }
                req.out().writeByte((byte)newState.ordinal());
            }, null);
        }
        catch (ClientError e) {
            throw new ClientException(e);
        }
    }

    @Override
    public boolean disableWal(String cacheName) throws ClientException {
        return this.changeWalState(cacheName, false);
    }

    @Override
    public boolean enableWal(String cacheName) throws ClientException {
        return this.changeWalState(cacheName, true);
    }

    @Override
    public boolean isWalEnabled(String cacheName) {
        try {
            return this.ch.service(ClientOperation.CLUSTER_GET_WAL_STATE, req -> {
                this.checkClusterApiSupported(req.clientChannel().protocolCtx());
                try (BinaryRawWriterEx writer = this.utils.createBinaryWriter(req.out());){
                    writer.writeString(cacheName);
                }
            }, res -> res.in().readBoolean());
        }
        catch (ClientError e) {
            throw new ClientException(e);
        }
    }

    private boolean changeWalState(String cacheName, boolean enable) throws ClientException {
        try {
            return this.ch.service(ClientOperation.CLUSTER_CHANGE_WAL_STATE, req -> {
                this.checkClusterApiSupported(req.clientChannel().protocolCtx());
                try (BinaryRawWriterEx writer = this.utils.createBinaryWriter(req.out());){
                    writer.writeString(cacheName);
                    writer.writeBoolean(enable);
                }
            }, res -> res.in().readBoolean());
        }
        catch (ClientError e) {
            throw new ClientException(e);
        }
    }

    private void checkClusterApiSupported(ProtocolContext protocolCtx) throws ClientFeatureNotSupportedByServerException {
        if (!protocolCtx.isFeatureSupported(ProtocolVersionFeature.CLUSTER_API) && !protocolCtx.isFeatureSupported(ProtocolBitmaskFeature.CLUSTER_STATES)) {
            throw new ClientFeatureNotSupportedByServerException(ProtocolBitmaskFeature.CLUSTER_STATES);
        }
    }

    ClientClusterGroupImpl defaultClusterGroup() {
        return this.dfltClusterGrp;
    }
}

