/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import org.apache.ignite.client.ClientClusterGroup;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.client.ClientFeatureNotSupportedByServerException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.client.thin.ClientBinaryMarshaller;
import org.apache.ignite.internal.client.thin.ClientClusterNodeImpl;
import org.apache.ignite.internal.client.thin.ClientError;
import org.apache.ignite.internal.client.thin.ClientOperation;
import org.apache.ignite.internal.client.thin.ClientUtils;
import org.apache.ignite.internal.client.thin.ProtocolBitmaskFeature;
import org.apache.ignite.internal.client.thin.ReliableChannel;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.lang.IgniteProductVersion;
import org.jetbrains.annotations.Nullable;

class ClientClusterGroupImpl
implements ClientClusterGroup {
    protected final ReliableChannel ch;
    protected final ClientUtils utils;
    private final ProjectionFilters projectionFilters;
    private long cachedTopVer;
    private Collection<UUID> cachedNodeIds;
    private final Map<UUID, ClusterNode> cachedNodes = new ConcurrentHashMap<UUID, ClusterNode>();

    ClientClusterGroupImpl(ReliableChannel ch, ClientBinaryMarshaller marsh) {
        this.ch = ch;
        this.utils = new ClientUtils(marsh);
        this.projectionFilters = ProjectionFilters.FULL_PROJECTION;
    }

    private ClientClusterGroupImpl(ReliableChannel ch, ClientUtils utils, ProjectionFilters projectionFilters) {
        this.ch = ch;
        this.utils = utils;
        this.projectionFilters = projectionFilters;
    }

    @Override
    public ClientClusterGroup forNodes(Collection<? extends ClusterNode> nodes) {
        A.notNull(nodes, "nodes");
        ClientClusterGroupImpl grp = this.forProjectionFilters(this.projectionFilters.forNodeIds(new HashSet<UUID>(F.nodeIds(nodes))));
        for (ClusterNode clusterNode : nodes) {
            grp.cachedNodes.put(clusterNode.id(), clusterNode);
        }
        return grp;
    }

    @Override
    public ClientClusterGroup forNode(ClusterNode node, ClusterNode ... nodes) {
        A.notNull(node, "node");
        return this.forNodes(ClientClusterGroupImpl.collection(ArrayList::new, node, nodes));
    }

    @Override
    public ClientClusterGroup forOthers(ClusterNode node, ClusterNode ... nodes) {
        A.notNull(node, "node");
        Collection<ClusterNode> nodes0 = ClientClusterGroupImpl.collection(IgniteUtils::newHashSet, node, nodes);
        return this.forPredicate(n -> !nodes0.contains(n));
    }

    @Override
    public ClientClusterGroup forOthers(ClientClusterGroup prj) {
        A.notNull(prj, "prj");
        Collection<ClusterNode> nodes0 = prj.nodes();
        return this.forPredicate(n -> !nodes0.contains(n));
    }

    @Override
    public ClientClusterGroup forNodeIds(Collection<UUID> ids) {
        A.notNull(ids, "ids");
        return this.forProjectionFilters(this.projectionFilters.forNodeIds(new HashSet<UUID>(ids)));
    }

    @Override
    public ClientClusterGroup forNodeId(UUID id, UUID ... ids) {
        A.notNull(id, "id");
        return this.forProjectionFilters(this.projectionFilters.forNodeIds(ClientClusterGroupImpl.collection(ArrayList::new, id, ids)));
    }

    @Override
    public ClientClusterGroup forPredicate(Predicate<ClusterNode> p) {
        A.notNull(p, "p");
        return this.forProjectionFilters(this.projectionFilters.forPredicate(p));
    }

    @Override
    public ClientClusterGroup forAttribute(String name, @Nullable Object val) {
        A.notNull(name, "name");
        return this.forProjectionFilters(this.projectionFilters.forAttribute(name, val));
    }

    @Override
    public ClientClusterGroup forServers() {
        return this.forProjectionFilters(this.projectionFilters == ProjectionFilters.FULL_PROJECTION ? ProjectionFilters.DEFAULT_PROJECTION : this.projectionFilters.forNodeType(true));
    }

    @Override
    public ClientClusterGroup forClients() {
        return this.forProjectionFilters(this.projectionFilters.forNodeType(false));
    }

    @Override
    public ClientClusterGroup forRandom() {
        return this.forProjectionFilters(this.projectionFilters.forResultFilter(nodes -> {
            if (F.isEmpty(nodes)) {
                return nodes;
            }
            return Collections.singletonList(nodes.get(ThreadLocalRandom.current().nextInt(nodes.size())));
        }));
    }

    @Override
    public ClientClusterGroup forOldest() {
        return this.forProjectionFilters(this.projectionFilters.forResultFilter(nodes -> {
            if (F.isEmpty(nodes)) {
                return nodes;
            }
            return nodes.stream().min(Comparator.comparing(ClusterNode::order)).map(Collections::singletonList).orElse(Collections.emptyList());
        }));
    }

    @Override
    public ClientClusterGroup forYoungest() {
        return this.forProjectionFilters(this.projectionFilters.forResultFilter(nodes -> {
            if (F.isEmpty(nodes)) {
                return nodes;
            }
            return nodes.stream().max(Comparator.comparing(ClusterNode::order)).map(Collections::singletonList).orElse(Collections.emptyList());
        }));
    }

    @Override
    public ClientClusterGroup forHost(ClusterNode node) {
        A.notNull(node, "node");
        String macs = (String)node.attribute("org.apache.ignite.macs");
        assert (macs != null);
        return this.forAttribute("org.apache.ignite.macs", macs);
    }

    @Override
    public ClientClusterGroup forHost(String host, String ... hosts) {
        A.notNull(host, "host");
        Collection<String> hosts0 = ClientClusterGroupImpl.collection(IgniteUtils::newHashSet, host, hosts);
        return this.forPredicate(n -> {
            for (String hostName : n.hostNames()) {
                if (!hosts0.contains(hostName)) continue;
                return true;
            }
            return false;
        });
    }

    private ClientClusterGroupImpl forProjectionFilters(ProjectionFilters projectionFilters) {
        return this.projectionFilters == projectionFilters ? this : new ClientClusterGroupImpl(this.ch, this.utils, projectionFilters);
    }

    @Override
    public Collection<ClusterNode> nodes() {
        return Collections.unmodifiableCollection(this.nodes0());
    }

    @Override
    public ClusterNode node(UUID nid) {
        ClusterNode node = this.cachedNodes.get(nid);
        if (this.projectionFilters.resultFilter == null) {
            if (node == null) {
                node = F.first(this.nodesByIds(Collections.singleton(nid)));
            }
            return node != null && this.projectionFilters.testAllPredicates(node) ? node : null;
        }
        return F.find(this.nodes0(), null, F.nodeForNodeId(nid));
    }

    @Override
    public ClusterNode node() {
        return F.first(this.nodes0());
    }

    public Collection<UUID> nodeIds() {
        if (this.projectionFilters == ProjectionFilters.DEFAULT_PROJECTION) {
            return null;
        }
        if (this.projectionFilters.hasOnlyNodeIdsFilters()) {
            return Collections.unmodifiableCollection(this.projectionFilters.nodeIds);
        }
        if (this.projectionFilters.hasOnlyServerSideFilters()) {
            Collection<UUID> nodeIds = this.requestNodeIds();
            if (this.projectionFilters.nodeIds != null) {
                nodeIds.retainAll(this.projectionFilters.nodeIds);
            }
            return nodeIds;
        }
        return F.nodeIds(this.nodes0());
    }

    private Collection<ClusterNode> nodes0() {
        return this.projectionFilters.hasOnlyNodeIdsFilters() ? this.nodesByIds(this.projectionFilters.nodeIds) : this.nodesByIds(this.requestNodeIds());
    }

    private synchronized Collection<UUID> requestNodeIds() {
        try {
            return this.ch.service(ClientOperation.CLUSTER_GROUP_GET_NODE_IDS, req -> {
                if (!req.clientChannel().protocolCtx().isFeatureSupported(ProtocolBitmaskFeature.CLUSTER_GROUPS)) {
                    throw new ClientFeatureNotSupportedByServerException(ProtocolBitmaskFeature.CLUSTER_GROUPS);
                }
                try (BinaryRawWriterEx writer = this.utils.createBinaryWriter(req.out());){
                    writer.writeLong(this.cachedTopVer);
                    this.projectionFilters.write(writer);
                }
            }, res -> {
                if (!res.in().readBoolean()) {
                    return new ArrayList<UUID>(this.cachedNodeIds);
                }
                long topVer = res.in().readLong();
                int nodesCnt = res.in().readInt();
                ArrayList<UUID> nodeIds = new ArrayList<UUID>(nodesCnt);
                for (int i = 0; i < nodesCnt; ++i) {
                    nodeIds.add(new UUID(res.in().readLong(), res.in().readLong()));
                }
                this.cachedNodes.keySet().retainAll(nodeIds);
                this.cachedTopVer = topVer;
                this.cachedNodeIds = nodeIds;
                return new ArrayList<UUID>(nodeIds);
            });
        }
        catch (ClientError e) {
            throw new ClientException(e);
        }
    }

    private Collection<ClusterNode> nodesByIds(Collection<UUID> nodeIds) {
        ArrayList<ClusterNode> nodes = new ArrayList<ClusterNode>();
        ArrayList<UUID> nodesToReq = null;
        for (UUID nodeId : nodeIds) {
            ClusterNode node = this.cachedNodes.get(nodeId);
            if (node != null) {
                if (!this.projectionFilters.testClientSidePredicates(node)) continue;
                nodes.add(node);
                continue;
            }
            if (nodesToReq == null) {
                nodesToReq = new ArrayList<UUID>(nodeIds.size());
            }
            nodesToReq.add(nodeId);
        }
        if (!F.isEmpty(nodesToReq)) {
            nodes.addAll(this.requestNodesByIds(nodesToReq));
        }
        return this.projectionFilters.applyResultFilter(nodes);
    }

    private Collection<ClusterNode> requestNodesByIds(Collection<UUID> nodeIds) {
        try {
            return this.ch.service(ClientOperation.CLUSTER_GROUP_GET_NODE_INFO, req -> {
                if (!req.clientChannel().protocolCtx().isFeatureSupported(ProtocolBitmaskFeature.CLUSTER_GROUPS)) {
                    throw new ClientFeatureNotSupportedByServerException(ProtocolBitmaskFeature.CLUSTER_GROUPS);
                }
                req.out().writeInt(nodeIds.size());
                for (UUID nodeId : nodeIds) {
                    req.out().writeLong(nodeId.getMostSignificantBits());
                    req.out().writeLong(nodeId.getLeastSignificantBits());
                }
            }, res -> {
                try (BinaryReaderExImpl reader = this.utils.createBinaryReader(res.in());){
                    int nodesCnt = reader.readInt();
                    ArrayList<ClusterNode> nodes = new ArrayList<ClusterNode>();
                    for (int i = 0; i < nodesCnt; ++i) {
                        ClusterNode node = this.readClusterNode(reader);
                        this.cachedNodes.put(node.id(), node);
                        if (!this.projectionFilters.testClientSidePredicates(node)) continue;
                        nodes.add(node);
                    }
                    ArrayList<ClusterNode> arrayList = nodes;
                    return arrayList;
                }
                catch (IOException e) {
                    throw new ClientError(e);
                }
            });
        }
        catch (ClientError e) {
            throw new ClientException(e);
        }
    }

    private ClusterNode readClusterNode(BinaryReaderExImpl reader) {
        return new ClientClusterNodeImpl(reader.readUuid(), this.readNodeAttributes(reader), reader.readCollection(), reader.readCollection(), reader.readLong(), reader.readBoolean(), reader.readBoolean(), reader.readBoolean(), reader.readObjectDetached(), this.readProductVersion(reader));
    }

    private Map<String, Object> readNodeAttributes(BinaryReaderExImpl reader) {
        int attrCnt = reader.readInt();
        HashMap<String, Object> attrs = new HashMap<String, Object>(attrCnt);
        for (int i = 0; i < attrCnt; ++i) {
            attrs.put(reader.readString(), reader.readObjectDetached());
        }
        return attrs;
    }

    private IgniteProductVersion readProductVersion(BinaryReaderExImpl reader) {
        return new IgniteProductVersion(reader.readByte(), reader.readByte(), reader.readByte(), reader.readString(), reader.readLong(), reader.readByteArray());
    }

    private static <T> Collection<T> collection(IntFunction<Collection<T>> factory, T item, T ... items) {
        Collection<T> col = factory.apply((item != null ? 1 : 0) + (items == null ? 0 : items.length));
        if (item != null) {
            col.add(item);
        }
        if (!F.isEmpty(items)) {
            col.addAll(Arrays.asList(items));
        }
        return col;
    }

    private static class ProjectionFilters {
        public static final ProjectionFilters FULL_PROJECTION = new ProjectionFilters();
        public static final ProjectionFilters DEFAULT_PROJECTION = new ProjectionFilters(null, null, Boolean.TRUE, null, null);
        public static final ProjectionFilters EMPTY_PROJECTION = new ProjectionFilters(Collections.emptySet(), null, null, null, null);
        private static final short ATTRIBUTE_FILTER = 1;
        private static final short NODE_TYPE_FILTER = 2;
        private final Collection<UUID> nodeIds;
        private final Map<String, Object> attrs;
        private final Boolean nodeType;
        private final Predicate<ClusterNode> predicate;
        private final Function<List<ClusterNode>, List<ClusterNode>> resultFilter;

        ProjectionFilters() {
            this.nodeIds = null;
            this.attrs = null;
            this.nodeType = null;
            this.predicate = null;
            this.resultFilter = null;
        }

        ProjectionFilters(Collection<UUID> nodeIds, Map<String, Object> attrs, Boolean nodeType, Predicate<ClusterNode> predicate) {
            this.nodeIds = nodeIds;
            this.attrs = attrs;
            this.nodeType = nodeType;
            this.predicate = predicate;
            this.resultFilter = null;
        }

        ProjectionFilters(Collection<UUID> nodeIds, Map<String, Object> attrs, Boolean nodeType, Predicate<ClusterNode> predicate, Function<List<ClusterNode>, List<ClusterNode>> resultFilter) {
            this.nodeIds = nodeIds;
            this.attrs = attrs;
            this.nodeType = nodeType;
            this.predicate = predicate;
            this.resultFilter = resultFilter;
        }

        ProjectionFilters forNodeIds(Collection<UUID> nodeIds) {
            if (this == EMPTY_PROJECTION || nodeIds == null) {
                return this;
            }
            if (this.resultFilter != null) {
                return this.forResultFilter(ProjectionFilters.resultFilterForPredicate(ProjectionFilters.predicateForNodeIds(nodeIds)));
            }
            if (this.nodeIds != null) {
                if (this.nodeIds.equals(nodeIds)) {
                    return this;
                }
                HashSet<UUID> nodeIdsIntersect = new HashSet<UUID>(this.nodeIds);
                nodeIdsIntersect.retainAll(nodeIds);
                nodeIds = nodeIdsIntersect;
            }
            if (nodeIds.isEmpty()) {
                return EMPTY_PROJECTION;
            }
            return new ProjectionFilters(nodeIds, this.attrs, this.nodeType, this.predicate);
        }

        ProjectionFilters forNodeType(boolean nodeType) {
            if (this == EMPTY_PROJECTION) {
                return this;
            }
            if (this.resultFilter != null) {
                return this.forResultFilter(ProjectionFilters.resultFilterForPredicate(ProjectionFilters.predicateForNodeType(nodeType)));
            }
            if (this.nodeType != null) {
                return this.nodeType == nodeType ? this : EMPTY_PROJECTION;
            }
            return new ProjectionFilters(this.nodeIds, this.attrs, nodeType, this.predicate);
        }

        ProjectionFilters forAttribute(String name, @Nullable Object val) {
            if (this == EMPTY_PROJECTION) {
                return this;
            }
            if (this.resultFilter != null) {
                return this.forResultFilter(ProjectionFilters.resultFilterForPredicate(ProjectionFilters.predicateForAttribute(name, val)));
            }
            if (this.attrs == null) {
                return new ProjectionFilters(this.nodeIds, Collections.singletonMap(name, val), this.nodeType, this.predicate);
            }
            HashMap<String, Object> attrsIntersect = new HashMap<String, Object>(this.attrs);
            Object oldVal = attrsIntersect.putIfAbsent(name, val);
            if (F.eq(val, oldVal)) {
                return this;
            }
            return oldVal != null && val != null ? EMPTY_PROJECTION : new ProjectionFilters(this.nodeIds, attrsIntersect, this.nodeType, this.predicate);
        }

        ProjectionFilters forPredicate(Predicate<ClusterNode> p) {
            if (this == EMPTY_PROJECTION || p == null) {
                return this;
            }
            if (this.resultFilter != null) {
                return this.forResultFilter(ProjectionFilters.resultFilterForPredicate(p));
            }
            return new ProjectionFilters(this.nodeIds, this.attrs, this.nodeType, this.predicate == null ? p : this.predicate.and(p));
        }

        ProjectionFilters forResultFilter(Function<List<ClusterNode>, List<ClusterNode>> resultFilter) {
            if (this == EMPTY_PROJECTION || resultFilter == null) {
                return this;
            }
            return new ProjectionFilters(this.nodeIds, this.attrs, this.nodeType, this.predicate, this.resultFilter == null ? resultFilter : this.resultFilter.andThen(resultFilter));
        }

        boolean hasOnlyNodeIdsFilters() {
            return this.nodeIds != null && this.nodeType == null && this.attrs == null && this.predicate == null && this.resultFilter == null;
        }

        boolean hasOnlyServerSideFilters() {
            return (this.nodeType != null || this.attrs != null) && this.predicate == null && this.resultFilter == null;
        }

        boolean testClientSidePredicates(ClusterNode node) {
            if (this.nodeIds != null && !this.nodeIds.contains(node.id())) {
                return false;
            }
            return this.predicate == null || this.predicate.test(node);
        }

        boolean testAllPredicates(ClusterNode node) {
            if (this.nodeType != null && !ProjectionFilters.predicateForNodeType(this.nodeType).test(node)) {
                return false;
            }
            if (!F.isEmpty(this.attrs)) {
                for (Map.Entry<String, Object> attr : this.attrs.entrySet()) {
                    if (ProjectionFilters.predicateForAttribute(attr.getKey(), attr.getValue()).test(node)) continue;
                    return false;
                }
            }
            return this.testClientSidePredicates(node);
        }

        List<ClusterNode> applyResultFilter(List<ClusterNode> nodes) {
            return this.resultFilter != null ? this.resultFilter.apply(nodes) : nodes;
        }

        static Function<List<ClusterNode>, List<ClusterNode>> resultFilterForPredicate(Predicate<ClusterNode> p) {
            return nodes -> {
                if (F.isEmpty(nodes)) {
                    return nodes;
                }
                ArrayList<ClusterNode> nodes0 = new ArrayList<ClusterNode>();
                for (ClusterNode node : nodes) {
                    if (!p.test(node)) continue;
                    nodes0.add(node);
                }
                return nodes0;
            };
        }

        static Predicate<ClusterNode> predicateForNodeIds(Collection<UUID> nodeIds) {
            return node -> nodeIds.contains(node.id());
        }

        static Predicate<ClusterNode> predicateForNodeType(boolean nodeType) {
            return node -> nodeType == !node.isClient();
        }

        static Predicate<ClusterNode> predicateForAttribute(String name, @Nullable Object val) {
            return val == null ? node -> node.attributes().containsKey(name) : node -> val.equals(node.attribute(name));
        }

        void write(BinaryRawWriterEx writer) {
            int size = (this.attrs == null ? 0 : this.attrs.size()) + (this.nodeType == null ? 0 : 1);
            writer.writeInt(size);
            if (!F.isEmpty(this.attrs)) {
                for (Map.Entry<String, Object> entry : this.attrs.entrySet()) {
                    writer.writeShort((short)1);
                    writer.writeString(entry.getKey());
                    writer.writeObject(entry.getValue());
                }
            }
            if (this.nodeType != null) {
                writer.writeShort((short)2);
                writer.writeBoolean(this.nodeType);
            }
        }
    }
}

