/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteDeploymentCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.managers.deployment.GridDeploymentInfoBean;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.continuous.GridContinuousBatch;
import org.apache.ignite.internal.processors.continuous.GridContinuousBatchAdapter;
import org.apache.ignite.internal.processors.continuous.GridContinuousHandler;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridPeerDeployAware;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.jetbrains.annotations.Nullable;

public class GridMessageListenHandler
implements GridContinuousHandler {
    private static final long serialVersionUID = 0L;
    private Object topic;
    private IgniteBiPredicate<UUID, Object> pred;
    private byte[] topicBytes;
    private byte[] predBytes;
    private String clsName;
    private GridDeploymentInfoBean depInfo;
    private boolean depEnabled;
    private IgniteInternalFuture<Void> p2pUnmarshalFut = new GridFinishedFuture<Void>();

    public GridMessageListenHandler() {
    }

    public GridMessageListenHandler(@Nullable Object topic, IgniteBiPredicate<UUID, Object> pred) {
        assert (pred != null);
        this.topic = topic;
        this.pred = pred;
    }

    @Override
    public boolean isEvents() {
        return false;
    }

    @Override
    public boolean isMessaging() {
        return true;
    }

    @Override
    public boolean isQuery() {
        return false;
    }

    @Override
    public boolean keepBinary() {
        return false;
    }

    @Override
    public String cacheName() {
        throw new IllegalStateException();
    }

    @Override
    public void updateCounters(AffinityTopologyVersion topVer, Map<UUID, Map<Integer, T2<Long, Long>>> cntrsPerNode, Map<Integer, T2<Long, Long>> cntrs) {
    }

    @Override
    public Map<Integer, T2<Long, Long>> updateCounters() {
        return Collections.emptyMap();
    }

    @Override
    public GridContinuousHandler.RegisterStatus register(UUID nodeId, UUID routineId, GridKernalContext ctx) {
        this.p2pUnmarshalFut.listen(fut -> {
            if (fut.error() == null) {
                ctx.io().addUserMessageListener(this.topic, this.pred, nodeId);
            }
        });
        return GridContinuousHandler.RegisterStatus.REGISTERED;
    }

    @Override
    public void unregister(UUID routineId, GridKernalContext ctx) {
        ctx.io().removeUserMessageListener(this.topic, this.pred);
    }

    @Override
    public void notifyCallback(UUID nodeId, UUID routineId, Collection<?> objs, GridKernalContext ctx) {
        assert (false);
    }

    @Override
    public void p2pMarshal(GridKernalContext ctx) throws IgniteCheckedException {
        assert (ctx != null);
        assert (ctx.config().isPeerClassLoadingEnabled());
        if (this.topic != null) {
            this.topicBytes = U.marshal(ctx.config().getMarshaller(), this.topic);
        }
        this.predBytes = U.marshal(ctx.config().getMarshaller(), this.pred);
        GridPeerDeployAware pda = U.peerDeployAware(this.pred);
        this.clsName = pda.deployClass().getName();
        GridDeployment dep = ctx.deploy().deploy(pda.deployClass(), pda.classLoader());
        if (dep == null) {
            throw new IgniteDeploymentCheckedException("Failed to deploy message listener.");
        }
        this.depInfo = new GridDeploymentInfoBean(dep);
        this.depEnabled = true;
    }

    @Override
    public void p2pUnmarshal(UUID nodeId, GridKernalContext ctx) throws IgniteCheckedException {
        assert (nodeId != null);
        assert (ctx != null);
        assert (ctx.config().isPeerClassLoadingEnabled());
        try {
            GridDeployment dep = ctx.deploy().getGlobalDeployment(this.depInfo.deployMode(), this.clsName, this.clsName, this.depInfo.userVersion(), nodeId, this.depInfo.classLoaderId(), this.depInfo.participants(), null);
            if (dep == null) {
                throw new IgniteDeploymentCheckedException("Failed to obtain deployment for class: " + this.clsName);
            }
            ClassLoader ldr = dep.classLoader();
            if (this.topicBytes != null) {
                this.topic = U.unmarshal(ctx, this.topicBytes, U.resolveClassLoader(ldr, ctx.config()));
            }
            this.pred = (IgniteBiPredicate)U.unmarshal(ctx, this.predBytes, U.resolveClassLoader(ldr, ctx.config()));
        }
        catch (IgniteCheckedException | IgniteException e) {
            ((GridFutureAdapter)this.p2pUnmarshalFut).onDone(e);
            throw e;
        }
        catch (ExceptionInInitializerError e) {
            ((GridFutureAdapter)this.p2pUnmarshalFut).onDone(e);
            throw new IgniteCheckedException("Failed to unmarshal deployable object.", e);
        }
        ((GridFutureAdapter)this.p2pUnmarshalFut).onDone();
    }

    @Override
    public GridContinuousBatch createBatch() {
        return new GridContinuousBatchAdapter();
    }

    @Override
    public void onClientDisconnected() {
    }

    @Override
    public void onBatchAcknowledged(UUID routineId, GridContinuousBatch batch, GridKernalContext ctx) {
    }

    @Override
    @Nullable
    public Object orderedTopic() {
        return null;
    }

    @Override
    public GridContinuousHandler clone() {
        try {
            return (GridContinuousHandler)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.depEnabled);
        if (this.depEnabled) {
            U.writeByteArray(out, this.topicBytes);
            U.writeByteArray(out, this.predBytes);
            U.writeString(out, this.clsName);
            out.writeObject(this.depInfo);
        } else {
            out.writeObject(this.topic);
            out.writeObject(this.pred);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.depEnabled = in.readBoolean();
        if (this.depEnabled) {
            this.p2pUnmarshalFut = new GridFutureAdapter<Void>();
            this.topicBytes = U.readByteArray(in);
            this.predBytes = U.readByteArray(in);
            this.clsName = U.readString(in);
            this.depInfo = (GridDeploymentInfoBean)in.readObject();
        } else {
            this.topic = in.readObject();
            this.pred = (IgniteBiPredicate)in.readObject();
        }
    }

    public String toString() {
        return S.toString(GridMessageListenHandler.class, this);
    }
}

