/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.trait;

import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.DeriveMode;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRel;
import org.apache.ignite.internal.processors.query.calcite.trait.CorrelationTrait;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistribution;
import org.apache.ignite.internal.processors.query.calcite.trait.RewindabilityTrait;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitUtils;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;

public interface TraitsAwareIgniteRel
extends IgniteRel {
    default public List<RelNode> derive(List<List<RelTraitSet>> inTraits) {
        return TraitUtils.derive(this, inTraits);
    }

    @Override
    default public Pair<RelTraitSet, List<RelTraitSet>> passThroughTraits(RelTraitSet required) {
        return TraitUtils.passThrough(this, required);
    }

    @Override
    default public Pair<RelTraitSet, List<RelTraitSet>> deriveTraits(RelTraitSet childTraits, int childId) {
        throw new RuntimeException(this.getClass().getName() + "#deriveTraits() is not implemented.");
    }

    default public DeriveMode getDeriveMode() {
        return DeriveMode.OMAKASE;
    }

    default public RelNode createNode(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        return this.copy(nodeTraits, Commons.transform(Ord.zip(inTraits), o -> RelOptRule.convert((RelNode)this.getInput(o.i), (RelTraitSet)((RelTraitSet)o.e))));
    }

    default public Pair<RelTraitSet, List<RelTraitSet>> passThroughRewindability(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        RewindabilityTrait rewindability = TraitUtils.rewindability(nodeTraits);
        return Pair.of((Object)nodeTraits, Commons.transform(inTraits, t -> t.replace((RelTrait)rewindability)));
    }

    default public Pair<RelTraitSet, List<RelTraitSet>> passThroughDistribution(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        IgniteDistribution distribution = TraitUtils.distribution(nodeTraits);
        return Pair.of((Object)nodeTraits, Commons.transform(inTraits, t -> t.replace((RelTrait)distribution)));
    }

    default public Pair<RelTraitSet, List<RelTraitSet>> passThroughCollation(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        if (inTraits.size() > 1) {
            throw new RuntimeException(this.getClass().getName() + "#passThroughCollation() is not implemented.");
        }
        RelCollation collation = TraitUtils.collation(nodeTraits);
        return Pair.of((Object)nodeTraits, Commons.transform(inTraits, t -> t.replace((RelTrait)collation)));
    }

    default public Pair<RelTraitSet, List<RelTraitSet>> passThroughCorrelation(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        CorrelationTrait correlation = TraitUtils.correlation(nodeTraits);
        return Pair.of((Object)nodeTraits, Commons.transform(inTraits, t -> t.replace((RelTrait)correlation)));
    }

    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveRewindability(RelTraitSet var1, List<RelTraitSet> var2);

    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveDistribution(RelTraitSet var1, List<RelTraitSet> var2);

    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveCollation(RelTraitSet var1, List<RelTraitSet> var2);

    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveCorrelation(RelTraitSet var1, List<RelTraitSet> var2);
}

