/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.sql.kill;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.ignite.internal.processors.query.calcite.sql.IgniteSqlKill;

public class IgniteSqlKillScanQuery
extends IgniteSqlKill {
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("KILL SCAN", SqlKind.OTHER_DDL);
    private final SqlCharStringLiteral nodeId;
    private final SqlCharStringLiteral cacheName;
    private final SqlNumericLiteral qryId;

    public IgniteSqlKillScanQuery(SqlParserPos pos, SqlCharStringLiteral nodeId, SqlCharStringLiteral cacheName, SqlNumericLiteral qryId) {
        super(OPERATOR, pos);
        this.nodeId = Objects.requireNonNull(nodeId, "nodeId");
        this.cacheName = Objects.requireNonNull(cacheName, "cacheName");
        this.qryId = Objects.requireNonNull(qryId, "qryId");
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.nodeId, (Object)this.cacheName, (Object)this.qryId);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword(this.getOperator().getName());
        this.nodeId.unparse(writer, 0, 0);
        this.cacheName.unparse(writer, 0, 0);
        this.qryId.unparse(writer, 0, 0);
    }

    public SqlCharStringLiteral nodeId() {
        return this.nodeId;
    }

    public SqlCharStringLiteral cacheName() {
        return this.cacheName;
    }

    public SqlNumericLiteral queryId() {
        return this.qryId;
    }
}

