/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.schema;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.SystemViewScan;
import org.apache.ignite.internal.processors.query.calcite.metadata.ColocationGroup;
import org.apache.ignite.internal.processors.query.calcite.rel.logical.IgniteLogicalIndexScan;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteIndex;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteTable;
import org.apache.ignite.internal.processors.query.calcite.schema.SystemViewTableDescriptorImpl;
import org.apache.ignite.internal.processors.query.calcite.schema.SystemViewTableImpl;
import org.apache.ignite.internal.processors.query.calcite.util.IndexConditions;
import org.apache.ignite.internal.processors.query.calcite.util.RexUtils;
import org.jetbrains.annotations.Nullable;

public class SystemViewIndexImpl
implements IgniteIndex {
    private final String idxName;
    private final SystemViewTableImpl tbl;

    public SystemViewIndexImpl(SystemViewTableImpl tbl) {
        this.tbl = tbl;
        this.idxName = ((SystemViewTableDescriptorImpl)tbl.descriptor()).name() + "_IDX";
    }

    @Override
    public RelCollation collation() {
        return RelCollations.EMPTY;
    }

    @Override
    public String name() {
        return this.idxName;
    }

    @Override
    public IgniteTable table() {
        return this.tbl;
    }

    @Override
    public IgniteLogicalIndexScan toRel(RelOptCluster cluster, RelOptTable relOptTbl, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable ImmutableBitSet requiredColumns) {
        return IgniteLogicalIndexScan.create(cluster, cluster.traitSet(), relOptTbl, this.idxName, proj, cond, requiredColumns);
    }

    @Override
    public <Row> Iterable<Row> scan(ExecutionContext<Row> execCtx, ColocationGroup grp, Predicate<Row> filters, Supplier<Row> lowerIdxConditions, Supplier<Row> upperIdxConditions, Function<Row, Row> rowTransformer, @Nullable ImmutableBitSet requiredColumns) {
        return new SystemViewScan(execCtx, this.tbl.descriptor(), lowerIdxConditions, filters, rowTransformer, requiredColumns);
    }

    @Override
    public long count(ExecutionContext<?> ectx, ColocationGroup grp) {
        return ((SystemViewTableDescriptorImpl)this.tbl.descriptor()).systemView().size();
    }

    @Override
    public IndexConditions toIndexCondition(RelOptCluster cluster, @Nullable RexNode cond, @Nullable ImmutableBitSet requiredColumns) {
        if (cond == null) {
            return new IndexConditions();
        }
        RelDataType rowType = this.tbl.getRowType(cluster.getTypeFactory());
        List<RexNode> searchRow = RexUtils.buildHashSearchRow(cluster, cond, rowType, requiredColumns, true);
        return new IndexConditions(searchRow, searchRow, searchRow, searchRow);
    }
}

