/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.schema;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.cache.query.index.Index;
import org.apache.ignite.internal.cache.query.index.sorted.inline.IndexQueryContext;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndex;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.IndexScan;
import org.apache.ignite.internal.processors.query.calcite.metadata.ColocationGroup;
import org.apache.ignite.internal.processors.query.calcite.rel.logical.IgniteLogicalIndexScan;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteCacheTable;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteIndex;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteTable;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.processors.query.calcite.util.IndexConditions;
import org.apache.ignite.internal.processors.query.calcite.util.RexUtils;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.apache.ignite.spi.indexing.IndexingQueryFilterImpl;
import org.jetbrains.annotations.Nullable;

public class CacheIndexImpl
implements IgniteIndex {
    private final RelCollation collation;
    private final String idxName;
    @Nullable
    private final Index idx;
    private final IgniteCacheTable tbl;

    public CacheIndexImpl(RelCollation collation, String name, @Nullable Index idx, IgniteCacheTable tbl) {
        this.collation = collation;
        this.idxName = name;
        this.idx = idx;
        this.tbl = tbl;
    }

    @Override
    public RelCollation collation() {
        return this.collation;
    }

    @Override
    public String name() {
        return this.idxName;
    }

    @Override
    public IgniteTable table() {
        return this.tbl;
    }

    public Index queryIndex() {
        return this.idx;
    }

    @Override
    public IgniteLogicalIndexScan toRel(RelOptCluster cluster, RelOptTable relOptTbl, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable ImmutableBitSet requiredColumns) {
        return IgniteLogicalIndexScan.create(cluster, cluster.traitSet(), relOptTbl, this.idxName, proj, cond, requiredColumns);
    }

    @Override
    public <Row> Iterable<Row> scan(ExecutionContext<Row> execCtx, ColocationGroup group, Predicate<Row> filters, Supplier<Row> lowerIdxConditions, Supplier<Row> upperIdxConditions, Function<Row, Row> rowTransformer, @Nullable ImmutableBitSet requiredColumns) {
        UUID localNodeId = execCtx.localNodeId();
        if (group.nodeIds().contains(localNodeId) && this.idx != null) {
            return new IndexScan<Row>(execCtx, this.tbl.descriptor(), (InlineIndex)this.idx.unwrap(InlineIndex.class), this.collation.getKeys(), group.partitions(localNodeId), filters, lowerIdxConditions, upperIdxConditions, rowTransformer, requiredColumns);
        }
        return Collections.emptyList();
    }

    @Override
    public long count(ExecutionContext<?> ectx, ColocationGroup grp) {
        long cnt = 0L;
        if (this.idx != null && grp.nodeIds().contains(ectx.localNodeId())) {
            IndexingQueryFilterImpl filter = new IndexingQueryFilterImpl(this.tbl.descriptor().cacheContext().kernalContext(), ectx.topologyVersion(), grp.partitions(ectx.localNodeId()));
            InlineIndex iidx = (InlineIndex)this.idx.unwrap(InlineIndex.class);
            try {
                for (int i = 0; i < iidx.segmentsCount(); ++i) {
                    cnt += iidx.count(i, new IndexQueryContext((IndexingQueryFilter)filter, null, ectx.mvccSnapshot()));
                }
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException("Unable to count index records.", (Throwable)e);
            }
        }
        return cnt;
    }

    @Override
    public IndexConditions toIndexCondition(RelOptCluster cluster, @Nullable RexNode cond, @Nullable ImmutableBitSet requiredColumns) {
        RelCollation collation = this.collation;
        RelDataType rowType = this.tbl.getRowType(cluster.getTypeFactory());
        if (requiredColumns != null) {
            collation = (RelCollation)collation.apply(Commons.mapping(requiredColumns, rowType.getFieldCount()));
        }
        if (!collation.getFieldCollations().isEmpty()) {
            return RexUtils.buildSortedIndexConditions(cluster, collation, cond, rowType, requiredColumns);
        }
        return new IndexConditions();
    }
}

