/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rule;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteConvention;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteUnionAll;
import org.apache.ignite.internal.processors.query.calcite.rule.ImmutableUnionConverterRule;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.immutables.value.Value;

@Value.Enclosing
public class UnionConverterRule
extends RelRule<Config> {
    public static final RelOptRule INSTANCE = Config.DEFAULT.toRule();

    public UnionConverterRule(Config cfg) {
        super((RelRule.Config)cfg);
    }

    public void onMatch(RelOptRuleCall call) {
        LogicalUnion union = (LogicalUnion)call.rel(0);
        RelOptCluster cluster = union.getCluster();
        RelTraitSet traits = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE);
        List<RelNode> inputs = Commons.transform(union.getInputs(), input -> UnionConverterRule.convert((RelNode)input, (RelTraitSet)traits));
        IgniteUnionAll res = new IgniteUnionAll(cluster, traits, inputs);
        if (!union.all) {
            RelBuilder relBuilder = this.relBuilderFactory.create(union.getCluster(), null);
            relBuilder.push((RelNode)res).aggregate(relBuilder.groupKey(ImmutableBitSet.range((int)union.getRowType().getFieldCount())), new RelBuilder.AggCall[0]);
            res = UnionConverterRule.convert((RelNode)relBuilder.build(), (RelTraitSet)union.getTraitSet());
        }
        call.transformTo((RelNode)res);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableUnionConverterRule.Config.of().withDescription("UnionConverterRule").withOperandFor(LogicalUnion.class);

        default public Config withOperandFor(Class<? extends LogicalUnion> union) {
            return (Config)this.withOperandSupplier(o0 -> o0.operand(union).anyInputs()).as(Config.class);
        }

        default public UnionConverterRule toRule() {
            return new UnionConverterRule(this);
        }
    }
}

