/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rule;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteConvention;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteLimit;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteSort;
import org.apache.ignite.internal.processors.query.calcite.rule.ImmutableSortConverterRule;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistributions;
import org.immutables.value.Value;

@Value.Enclosing
public class SortConverterRule
extends RelRule<Config> {
    public static final RelOptRule INSTANCE = Config.DEFAULT.toRule();

    protected SortConverterRule(Config config) {
        super((RelRule.Config)config);
    }

    public void onMatch(RelOptRuleCall call) {
        Sort sort = (Sort)call.rel(0);
        RelOptCluster cluster = sort.getCluster();
        if (sort.fetch != null || sort.offset != null) {
            RelTraitSet traits = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)sort.getCollation()).replace((RelTrait)IgniteDistributions.single());
            if (sort.collation == RelCollations.EMPTY || sort.fetch == null) {
                call.transformTo((RelNode)new IgniteLimit(cluster, traits, SortConverterRule.convert((RelNode)sort.getInput(), (RelTraitSet)traits), sort.offset, sort.fetch));
            } else {
                IgniteSort igniteSort = new IgniteSort(cluster, cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)sort.getCollation()), SortConverterRule.convert((RelNode)sort.getInput(), (RelTraitSet)cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE)), sort.getCollation(), sort.offset, sort.fetch, false);
                call.transformTo((RelNode)new IgniteLimit(cluster, traits, SortConverterRule.convert((RelNode)igniteSort, (RelTraitSet)traits), sort.offset, sort.fetch), (Map)ImmutableMap.of((Object)new IgniteLimit(cluster, traits, SortConverterRule.convert((RelNode)sort.getInput(), (RelTraitSet)traits), sort.offset, sort.fetch), (Object)sort));
            }
        } else {
            RelTraitSet outTraits = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)sort.getCollation());
            RelTraitSet inTraits = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE);
            RelNode input = SortConverterRule.convert((RelNode)sort.getInput(), (RelTraitSet)inTraits);
            call.transformTo((RelNode)new IgniteSort(cluster, outTraits, input, sort.getCollation(), false));
        }
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableSortConverterRule.Config.of().withOperandSupplier(b -> b.operand(LogicalSort.class).anyInputs());

        default public SortConverterRule toRule() {
            return new SortConverterRule(this);
        }
    }
}

