/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rel;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteConvention;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRel;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRelVisitor;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistributions;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitUtils;
import org.apache.ignite.internal.processors.query.calcite.util.RexUtils;

public class IgniteLimit
extends SingleRel
implements IgniteRel {
    private final RexNode offset;
    private final RexNode fetch;

    public IgniteLimit(RelOptCluster cluster, RelTraitSet traits, RelNode child, RexNode offset, RexNode fetch) {
        super(cluster, traits, child);
        this.offset = offset;
        this.fetch = fetch;
    }

    public IgniteLimit(RelInput input) {
        super(input.getCluster(), input.getTraitSet().replace((RelTrait)IgniteConvention.INSTANCE), (RelNode)input.getInputs().get(0));
        this.offset = input.getExpression("offset");
        this.fetch = input.getExpression("fetch");
    }

    public final IgniteLimit copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new IgniteLimit(this.getCluster(), traitSet, (RelNode)IgniteLimit.sole(inputs), this.offset, this.fetch);
    }

    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        pw.itemIf("offset", (Object)this.offset, this.offset != null);
        pw.itemIf("fetch", (Object)this.fetch, this.fetch != null);
        return pw;
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughTraits(RelTraitSet required) {
        if (required.getConvention() != IgniteConvention.INSTANCE) {
            return null;
        }
        if (TraitUtils.distribution(required) != IgniteDistributions.single()) {
            return null;
        }
        RelCollation requiredCollation = TraitUtils.collation(required);
        RelCollation relCollation = TraitUtils.collation(this.traitSet);
        if (relCollation.satisfies((RelTrait)requiredCollation)) {
            required = required.replace((RelTrait)relCollation);
        } else if (!requiredCollation.satisfies((RelTrait)relCollation)) {
            return null;
        }
        return Pair.of((Object)required, (Object)ImmutableList.of((Object)required));
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> deriveTraits(RelTraitSet childTraits, int childId) {
        assert (childId == 0);
        if (childTraits.getConvention() != IgniteConvention.INSTANCE) {
            return null;
        }
        if (TraitUtils.distribution(childTraits) != IgniteDistributions.single()) {
            return null;
        }
        if (!TraitUtils.collation(childTraits).satisfies((RelTrait)TraitUtils.collation(this.traitSet))) {
            return null;
        }
        return Pair.of((Object)childTraits, (Object)ImmutableList.of((Object)childTraits));
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double inputRowCount = mq.getRowCount(this.getInput());
        double lim = this.fetch != null ? RexUtils.doubleFromRex(this.fetch, inputRowCount * 0.01) : inputRowCount;
        double off = this.offset != null ? RexUtils.doubleFromRex(this.offset, inputRowCount * 0.5) : 0.0;
        double rows = Math.min(lim + off, inputRowCount);
        return planner.getCostFactory().makeCost(rows, rows * 1.0, 0.0);
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        double inputRowCount = mq.getRowCount(this.getInput());
        double lim = this.fetch != null ? RexUtils.doubleFromRex(this.fetch, inputRowCount * 0.01) : inputRowCount;
        double off = this.offset != null ? RexUtils.doubleFromRex(this.offset, inputRowCount * 0.5) : 0.0;
        return Math.min(lim, inputRowCount - off);
    }

    public RexNode offset() {
        return this.offset;
    }

    public RexNode fetch() {
        return this.fetch;
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteLimit(cluster, this.getTraitSet(), (RelNode)IgniteLimit.sole(inputs), this.offset, this.fetch);
    }
}

