/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rel;

import java.util.Collections;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRel;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRelVisitor;
import org.apache.ignite.internal.processors.query.calcite.rel.SourceAwareIgniteRel;

public class IgniteIndexCount
extends AbstractRelNode
implements SourceAwareIgniteRel {
    private static final double INDEX_TRAVERSE_COST_DIVIDER = 1000.0;
    private final RelOptTable tbl;
    private final String idxName;
    private final long sourceId;

    public IgniteIndexCount(RelInput input) {
        super(input.getCluster(), input.getTraitSet());
        this.idxName = input.getString("index");
        this.tbl = input.getTable("table");
        Object srcIdObj = input.get("sourceId");
        this.sourceId = srcIdObj != null ? ((Number)srcIdObj).longValue() : -1L;
    }

    public IgniteIndexCount(RelOptCluster cluster, RelTraitSet traits, RelOptTable tbl, String idxName) {
        this(-1L, cluster, traits, tbl, idxName);
    }

    private IgniteIndexCount(long sourceId, RelOptCluster cluster, RelTraitSet traits, RelOptTable tbl, String idxName) {
        super(cluster, traits);
        this.idxName = idxName;
        this.tbl = tbl;
        this.sourceId = sourceId;
    }

    protected RelDataType deriveRowType() {
        RelDataTypeFactory tf = this.getCluster().getTypeFactory();
        return tf.createStructType(Collections.singletonList(tf.createSqlType(SqlTypeName.BIGINT)), Collections.singletonList("COUNT"));
    }

    public String indexName() {
        return this.idxName;
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        return 1.0;
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return planner.getCostFactory().makeCost(1.0, this.tbl.getRowCount() / 1000.0, 0.0);
    }

    @Override
    public long sourceId() {
        return this.sourceId;
    }

    public RelOptTable getTable() {
        return this.tbl;
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("index", (Object)this.idxName).item("table", (Object)this.tbl.getQualifiedName()).itemIf("sourceId", (Object)this.sourceId, this.sourceId != -1L);
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteIndexCount(this.sourceId, cluster, this.traitSet, this.tbl, this.idxName);
    }

    @Override
    public IgniteRel clone(long srcId) {
        return new IgniteIndexCount(srcId, this.getCluster(), this.traitSet, this.tbl, this.idxName);
    }
}

